# $Header: /home/yav/catty/fkiss/RCS/Makefile.x,v 1.18 2000/09/28 07:49:58 yav Exp $
# Makefile for French-KISS! for xmkmf not supported operating system
# written by yav (UHD98984@biglobe.ne.jp)
#

#STD_DEFINES = -D_POSIX_SOURCE -D_BSD_SOURCE
XINCDIR = -I/usr/X11R6/include
XLIBDIR = -L/usr/X11R6/lib
XLIB = -lX11

DEFINES = 
CDEBUGFLAGS = -O2
CFLAGS = $(STD_DEFINES) $(CDEBUGFLAGS) $(XINCDIR) $(DEFINES)
SYS_LIBRARIES = $(XLIB)

TARGET = fkiss
OBJS = fkiss.o menu.o selcnf.o cursor.o dir.o sound.o kisscnf.o sub.o\
 color.o kisseve.o comment.o bg.o timer.o\
 codeconv.o jiscode.o work.o message.o

HEADERS = config.h headers.h kiss.h fkiss.h work.h timer.h extern.h
ICON_BITMAP = icon.xbm
CURSOR_BITMAPS = hand0.xbm hand1.xbm grip0.xbm grip1.xbm

all : $(TARGET)

clean:
	rm -f *.o config.h coptions

$(TARGET) : $(OBJS)
	$(CC) $(XLIBDIR) $(LDFLAGS) $(OBJS) -o $@ $(SYS_LIBRARIES)

$(OBJS) : $(HEADERS)
fkiss.o : $(ICON_BITMAP)
cursor.o : $(CURSOR_BITMAPS)
sound.o : ulaw.h
work.o : version.h coptions

coptions: config.h.in
	awk -f coptions.awk config.h.in >coptions

config.h: config.h.in
	/bin/sh configure

doc: README.en README.sjis README.euc

README.en: fkiss.doc
	sed -f english.sed $^ >$@
README.euc: README.sjis
	nkf -euc $^ >$@
README.sjis: fkiss.doc
	sed -f japanese.sed $^ >$@

# End of file
