/* $Header: /home/yav/catty/fkiss/RCS/bg.c,v 1.10 2000/08/25 06:50:36 yav Exp $
 * fkiss background task and signal handling
 * written by yav <yav@bigfoot.com>
 */

char id_bg[] = "$Id: bg.c,v 1.10 2000/08/25 06:50:36 yav Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>

#include "config.h"

#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_BG_C
#include "extern.h"

/* for System V signal symbol */
#ifndef SIGCHLD
#define SIGCHLD SIGCLD
#endif

static FILE *bgfp = NULL;
static char sound_mark[] = "**sound";
static char play_command[] = "play";
static char shell_command[] = "/bin/sh";

RETSIGTYPE sigchld_handler()
{
  wait(NULL);
  signal(SIGCHLD, sigchld_handler); /* reset signal handler for SysV */
}

void bg_child()
{
  FILE *fp;
  int i, s, sound_mark_len;
  char *p;
  char buf[256];
  
  signal(SIGCHLD, sigchld_handler);
  sound_mark_len = strlen(sound_mark);
  fp = fdopen(0, "r");
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    cut_crlf(buf);
    if (debug_mode)
      fprintf(stderr, "Background:%s\n", buf);
    p = buf;
    s = 0;
    if (strncmp(p, sound_mark, sound_mark_len) == 0) {
      p += sound_mark_len + 1;	/* skip sound_mark + ' ' */
      s = 1;
    }
    if (fork() == 0) {
      /* child process */
      switch(s) {
      case 1:			/* Sound function */
	if (sound_mode & 1) {
	  /* internal sound routine */
	  i = sound_play(p);
	  switch (i) {
	  case 0:		/* no error */
	    exit(0);
	  case 1:		/* sound file open error */
	    msg("W sound file ``%s'' open error.\n", p);
	    break;
	  case 2:		/* device open error */
	    msg("W sound device ``%s'' open error.\n", sound_device);
	    break;
	  case 3:		/* Not supported format */
	    msg("W ``%s'' not supported sound format.\n", p);
	    break;
	  default:
	    msg("W unknown sound error (%d)!?\n", i);
	    break;
	  }
	} else {
	  execlp(play_command, play_command, p, NULL);
	  /* play_command exec failed, try shell_command */
	  execlp(shell_command, shell_command, play_command, p, NULL);
	  /* shell_command exec failed */
	}
	break;
      default:			/* Other function */
	system(p);
	exit(0);
      }
      exit(1);			/* exec failed */
    }
  }
  exit(0);
}

/* fork background process */
int background()
{
  int i;
  int pfd[2];
  
  if (pipe(pfd) < 0)
    return -1;			/* pipe open failed */
  i = fork();
  if (i < 0)
    return -1;			/* fork failed */
  if (i == 0) {
    /* child */
    close(0);
    dup(pfd[0]);
    close(pfd[0]);
    close(pfd[1]);
    bg_child();
    /* NOT REACHED */
  }
  /* parent */
  close(pfd[0]);
  bgfp = fdopen(pfd[1], "w");
  return 0;
}

int bg_shell(str)
     char *str;
{
  if (bgfp != NULL) {
    fprintf(bgfp, "%s\n", str);
    fflush(bgfp);
  }
  return 0;
}

int bg_play(name)
     char *name;
{
  if (sound_mode && bgfp != NULL) {
    fprintf(bgfp, "%s %s\n", sound_mark, name);
    fflush(bgfp);
  }
  return 0;
}

void bg_exit()
{
  if (bgfp != NULL) {
    fclose(bgfp);
    bgfp = NULL;
    wait(NULL);
  }
}


RETSIGTYPE signal_handler(sig)
     int sig;
{
  signal(sig, SIG_IGN);		/* for SysV */
  if (debug_mode)
    printf("fkiss: signal %d!\n", sig);
  kiss_exit(1);
}

void setup_signal_handler()
{
  int i;
  static int trap_signals[] = {
    SIGHUP, SIGINT, SIGQUIT, SIGPIPE, SIGTERM,
#ifdef SIGXCPU
    SIGXCPU,
#endif
#ifdef SIGXFSZ
    SIGXFSZ,
#endif
    0
  };
  
  for (i = 0; trap_signals[i]; i++) {
    /* Don't trap already ignored signals */
    if (signal(trap_signals[i], SIG_IGN) != SIG_IGN)
      signal(trap_signals[i], signal_handler);
  }
}

/* End of file */
