/* $Header: /home/yav/catty/fkiss/RCS/fkiss.h,v 1.39 2000/09/28 07:51:48 yav Exp $
 * fkiss global symbols
 * written by yav <yav@bigfoot.com>
 */

#ifndef _FKISS_H
#define _FKISS_H

#ifndef _KISS_H
#include "kiss.h"
#endif

#ifndef MAXCOL
#define MAXCOL KISSGS4_MAXCOL
#endif

#ifndef MAXCEL
#if (KISSGS4_MAXCEL < 4096)
#define MAXCEL 4096		/* <= Maximum value of signed short */
#else
#define MAXCEL KISSGS4_MAXCEL
#endif
#endif

#ifndef MAXOBJ
#define MAXOBJ MAXCEL		/* <= Maximum value of signed short */
#endif

/* System pixel number */
#define SPX_BG	0		/* Background */
#define SPX_FG	1		/* Foreground */
#define SPX_BG2	2		/* Light background */
#define SPX_MN	3		/* Menu background */
#define SPX_BT	4		/* Button background */
#define SPX_MAX	5

/* System GC number */
#define SGC_GEN	0		/* generic */
#define SGC_MN	1		/* menu */
#define SGC_BT0	2		/* normal menu button */
#define SGC_BT1	3		/* reversed menu button */
#define SGC_IN0	4
#define SGC_IN1	5
#define SGC_T8	6		/* ASCII data comment */
#define SGC_T16	7		/* Japanese KANJI data comment */
#define SGC_MAX	8

typedef struct {
  short x;
  short y;
  short w;
  short h;
} AREA;

/* Menu Window structure */
typedef struct {
  short n;			/* index number 0,1,2... -1(End) */
  short st;			/* menu status */
  short w;			/* width */
  short h;			/* height */
  Window win;			/* Window ID */
} MW;

typedef struct {
  int n;			/* cell or object no. */
  int s;			/* hit status (0:No, other:Hit) */
} HITP;

/* data structure */
typedef struct {
  unsigned char *image;
  long *iline;
  Pixmap pixmap;
  Pixmap clip;
  Pixmap transclip;
  GC gc;
  char *filename;
  char *comment;
  short orgw;			/* original width */
  short orgh;			/* original height */
  short orgx;			/* original offset-x */
  short orgy;			/* original offset-y */
  short width;			/* optimized width */
  short height;			/* optimized height */
  short ofsx;			/* optimized offset-x */
  short ofsy;			/* optimized offset-y */
  short obj;
  short fix;
  short transparency;		/* 0:Solid 128:Half 256:Transparent */
  int colfile;
  int pixpal;
  char setflag[MAXSET];		/* 0:no use 1:active */
  char unmap;			/* 0:mapped 1:unmapped */
  short line;			/* line number described in *.cnf */
  short bpp;			/* bit per pixel */
  int hitn;			/* hit check cell number */
  HITP *hitp;			/* hit check cell list */
} CELL;

typedef struct {
  unsigned char r;
  unsigned char g;
  unsigned char b;
} KISSCOLOR;

typedef struct {
  short bpc;			/* bit per color */
  short cpg;			/* color per palette group */
  short pg;			/* number of palette group */
  char *filename;
} COLOR;

typedef struct {
  short width;
  short height;
  short fix;
  short pesi;
  short ncel;			/* 0 ... MAXCEL */
  int ohitn;			/* hit check obj number */
  HITP *ohitp;			/* hit check obj list */
} OBJECT;

typedef struct {
  short x;
  short y;
  short ox;			/* original position-x (specified in cnf) */
  short oy;			/* original position-y (specified in cnf) */
} OBJPOS;

typedef struct {
  short pal;
  OBJPOS *obj;
} SETINFO;


/* KISS event code */
#define BIT_EVENT	0x100
#define BIT_ACTION	0x200

#define EVE_top		BIT_EVENT
#define EVE_NEVER		(EVE_top+0)
#define EVE_INITIALIZE		(EVE_top+1)
#define EVE_ALARM		(EVE_top+2)
#define EVE_BEGIN		(EVE_top+3)
#define EVE_END			(EVE_top+4)
#define EVE_PRESS		(EVE_top+5)
#define EVE_RELEASE		(EVE_top+6)
#define EVE_CATCH		(EVE_top+7)
#define EVE_DROP		(EVE_top+8)
#define EVE_FIXCATCH		(EVE_top+9)
#define EVE_FIXDROP		(EVE_top+10)
#define EVE_UNFIX		(EVE_top+11)
#define EVE_SET			(EVE_top+12)
#define EVE_COL			(EVE_top+13)
#define EVE_IN			(EVE_top+14)
#define EVE_OUT			(EVE_top+15)
#define EVE_STILLIN		(EVE_top+16)
#define EVE_STILLOUT		(EVE_top+17)
#define EVE_COLLIDE		(EVE_top+18)
#define EVE_APART		(EVE_top+19)
#define EVE_VERSION		(EVE_top+20)

#define ACT_top		BIT_ACTION+21
#define ACT_NOP			(ACT_top+0)
#define ACT_DEBUG		(ACT_top+1)
#define ACT_SHELL		(ACT_top+2)
#define ACT_UNMAP		(ACT_top+3)
#define ACT_MAP			(ACT_top+4)
#define ACT_ALTMAP		(ACT_top+5)
#define ACT_MOVE		(ACT_top+6)
#define ACT_SOUND		(ACT_top+7)
#define ACT_TIMER		(ACT_top+8)
#define ACT_RANDOMTIMER		(ACT_top+9)
#define ACT_QUIT		(ACT_top+10)
#define ACT_CHANGESET		(ACT_top+11)
#define ACT_CHANGECOL		(ACT_top+12)
#define ACT_TRANSPARENT		(ACT_top+13)
#define ACT_WINDOWSIZE		(ACT_top+14)
#define ACT_VIEWPORT		(ACT_top+15)
#define ACT_IFFIXED		(ACT_top+16)
#define ACT_IFNOTFIXED		(ACT_top+17)
#define ACT_IFMAPPED		(ACT_top+18)
#define ACT_IFNOTMAPPED		(ACT_top+19)
#define ACT_IFMOVED		(ACT_top+20)
#define ACT_IFNOTMOVED		(ACT_top+21)
#define ACT_SETFIX		(ACT_top+22)
#define ACT_MOVEBYX		(ACT_top+23)
#define ACT_MOVEBYY		(ACT_top+24)
#define ACT_MOVETO		(ACT_top+25)
#define ACT_MOVERANDX		(ACT_top+26)
#define ACT_MOVERANDY		(ACT_top+27)
#define ACT_MOVETORAND		(ACT_top+28)
#define ACT_MUSIC		(ACT_top+29)
#define ACT_NOTIFY		(ACT_top+30)


/* event handler result code */
#define ACTBIT_SOUND	1	/* sound playing status changed */
#define ACTBIT_MAP	2	/* cell mapping status changed */

typedef struct {
  int objn;
  int objx;
  int objy;
} EVHITWK;

/* Japanese text coding type */
#define CODING_UNKNOWN	0
#define CODING_SJIS	1
#define CODING_EUC	2
#define CODING_JIS	3
#define CODING_MAX	4	/* number of coding types */

typedef struct {
  char *buf;			/* buffer */
  int len;			/* alloced length */
  int n;			/* current ptr (buf[n] '\0') */
} LSTR;


#endif /* _FKISS_H */

/* End of file */
