.\" -*- nroff -*-
.\" $Id: fkiss.man,v 1.27 2000/09/11 08:07:45 yav Exp $
.\"
.TH fkiss 1 "Mon Sep 11, 2000"
.SH NAME
fkiss \- Freely enjoy childlike KISS, French-KISS!
.SH SYNOPSIS
\fBfkiss\fP [\fIoption\fP...] [\fIfile.lzh\fP...] [\fIfile.cnf\fP]
.SH DESCRIPTION
.B French\-KISS!
(\fBfkiss\fP) is a sample implementation of
KISekae Set system (KISS) for X Window System.
KISS is a paper doll playing system on computers.
.br
.B fkiss
read
.I file.cnf
(KISS configuration file),
and read color and cell files described in it.
If \fIfile.lzh\fP (LHa archive) is specified,
.B fkiss
call \fBlha\fP to extract archive
and search *.cnf.
If \fIfile.lzh\fP nor \fIfile.cnf\fP is not specified,
.B fkiss
search *.cnf in current work directory.
.SH OPTIONS
.TP
.BI \-display " name"
Display connection.
.TP
.BI \-geometry " geom"
Window geometry.
.TP
.B \-debug
Print debug informations to stderr.
.TP
.B \-silent
Silent mode.
Warning messages are not displayed.
Sounds are not played.
.TP
.B \-verbose
Verbose mode.
.TP
.BI \-font " font"
Use a font named \fIfont\fP to print menu strings etc.
.TP
.BI \-font8 " font"
Use a font named \fIfont\fP to print comment strings.
By default "rk16" or "8x16" is used.
.TP
.BI \-font16 " font"
Use a font named \fIfont\fP to print Japanese comment strings.
By default "kanji16" or "k14" is used.
.TP
.BI \-fg " color"
Foreground color.
.TP
.BI \-bg " color"
Background color.
.TP
.BI \-bw " width"
Border width.
.TP
.BI \-cursor " n"
Cursor font control.
.br
.B 0
	(no control)
.br
.B 1
	hand   (null)
.br
.B 2
	undef  grip
.br
.B 3
	hand   grip	(*default)
.TP
.B \-s
Same as \fB\-cursor 1\fP.
.TP
.BI \-fixed " n"
Do not move a object its fix value is more than or equal to \fIn\fP.
If not specified, use maximum value described in configuration file.
.TP
.B \-scroll
Unlimited scroll.
.TP
.B \-gray
Convert RGB value to Gray scale brightness level.
(On GrayScale visual class server, This option is turned on automatically)
.TP
.B \-test
Automatically display all set, and print cell informations to stderr.
.TP
.B \-t
Execute time command with arguments "fkiss -test ..." to report running time.
"fkiss -t kissmars.lzh" is same as "time fkiss -test kissmars.lzh".
.TP
.B \-nosound
Disable sound function. (same as \fB\-sound 0\fP)
.TP
.BI \-sound " n"
Select sound handling mode.
.br
.B 0
	Disable sound function.
.br
.B 1
	Use internal sound routine (cf. sound.c).
.br
.B 2
	Execute "play" command to play sound.
.TP
.BI \-soundcache " n[k|m]"
Change sound data cache buffer size limit \fIn\fP (kilo|mega) bytes.
By default, 256 kilobytes limit.
.TP
.B \-p
Use private color cells.
.TP
.B \-nocolormap
Disable to make new colormap.
.TP
.BI \-k " keyword"
Decode encrypted lzh archives (suffix .hes) with \fIkeyword\fP.
.TP
.BI \-randseed " n"
Use \fIn\fP for randomize seed.
If this option is not specified, use current time.
.TP
.B \-noevent
Disable fkiss event extension.
.TP
.B \-eventshell
Enable to execute shell command described in KISS configuration file.
Take care, this funciton makes a SECURITY HOLE!
.TP
.B \-wkiss
Emulate WKISS bug.
.TP
.BI \-transparency " n"
Set pseudo transparency mode.
.br
.B 0
	Disable pseudo transparency functions.
.br
.B 1
	Static dithered pseudo transparency mode.
.br
.B 2
	Under construnction. Buggy.
.TP
.BI \-comment " n"
Set cell comment display mode.
.br
.B 0
	Not display cell comment.
.br
.B 1
	Display pointed cell comment.
.br
.B 2
	Display all cell comment pointed object.
.TP
.B \-commentline
Display cell comment with cnf line number.
.TP
.BI \-button1 " n"
Assign function \fIn\fP to mouse button1 (left).
.br
.B 0
	No operation.
.br
.B 1
	Object catch, move and drop.
.br
.B 2
	Iconify window.
.br
.B 3
	Display cell comment.
.TP
.BI \-button2 " n"
Assign function \fIn\fP to mouse button2 (center).
.TP
.BI \-button3 " n"
Assign function \fIn\fP to mouse button3 (right).
.TP
.BI \-document " document_browse_command"
Execute \fIdocument_browse_command\fP to browse document.
By default, execute DOC_COMMAND defined in fkiss.c.
(Initial DOC_COMMAND defined "xemacs")
If the character % is not found in DOC_COMMAND,
Append " %P" string.
If the character at end of DOC_COMMAND is not &,
Append & character.
Following parameters in \fIdocument_browse_command\fP substitute.
.br
.B %A
	directory
.br
.B %P
	pathnames
.br
.B %F
	filenames
.br
Exmple:
.br
-document "(cd %A; more %F) &"
.br
"(cd /tmp/fkiss123; more litks09.doc readme.txt) &"
.br
-document "(emacs %P) &"
.br
"(emacs /tmp/fkiss123/litks09.doc /tmp/fkiss123/readme.txt) &"
.TP
.BI \-suffix " .foo"
Add suffix \fI.foo\fP into document suffix list.
.TP
.BI \-nosuffix " .foo"
Delete suffix \fI.foo\fP from document suffix list.
.TP
.BI \-autoadjust " n"
Automatic object position adjustment range \fIn\fP pixels.
4 pixels by default.
"-autoadjust 0" to disable automatic object position adjustment.
.TP
.B \-nowarncase
Suppress CEL and Sound file case-ignore warnings.
.TP
.BI \-maxaction " n"
Change maximum number of actions per event.
Default 256.
.TP
.BI \-maxtimer " n"
Change maximum number of timers.
Default 256.
.TP
.BI \-maxevent " n"
Change maximum number of events.
Default 256.
.TP
.BI \-maxsoundfile " n"
Change maximum number of sound files.
Default 256.
.TP
.BI \-alpha " n"
Change alpha channel tranparency level.
Add \fIn\fP to each pixel alpha level (0..255).
.br
.B -255
	All pixels transparent.
.br
.B +255
	Not transparent.
.br
.SH "KEY BINDINGS"
.TP
.B Button1
Catch the object which is pointed.
If no objects or fixed object is pointed,
scroll the image with moving mouse.
.TP
.B Button2
Iconify window.
.TP
.B Button3
Display cell comment.
.TP
.B \-
Previous set.
.TP
.B =
Next set.
.TP
.B [
Previous color group.
.TP
.B ]
Next color group.
.TP
.B Space
Toggle upper/lower menu bar.
.TP
.B Escape
Iconify window.
.TP
.B Control\-S
Save cnf file.
Original cnf file is renamed *.cnf~.
.TP
.B q
Quit.
.TP
.B Control\-Button1
Unmap the cell which is pointed.
And register it for 'v' toggle mapping.
.br
For KISS data creaters ONLY.
Others must NOT use this function.
.TP
.B v
Toggle mapping/unmapping the cell which is unmapped by Contol-Button1.
Don't forget mapping it again before next Control-Button1.
.TP
.B d
Browse document files (*.doc *.txt *.hed).
Initial settings, use \fBxemacs\fP program.
.TP
.B r
Revert position of all objects in current set to initial.
If fkiss event extension is detected,
this function is disabled.
.SH FILES
.TP
*.cnf
KISS configuration file
.TP
*.kcf
KISS color file
.TP
*.cel
KISS cell file
.TP
*.lzh
LHa archive file
.TP
lha
LHa archiver
.TP
\fBTMPDIR\fP/fkiss*
temporary directory to extract files
.TP
\fBHOME\fP/.fkissrc
rc file for fkiss.
.TP
\fBHOME\fP/fkiss.au
startup sound file
.TP
play
command for playing sound file
.SH STANDARDS
.B fkiss
is conforming to KISS/GS2, KISS/GS4 (draft).
See kissgs.doc - KISS/GS (KISS General Specification) Manual.
.SH BUGS
Cannot to enjoy colorful dresses on GrayScale and StaticGray visual
class server.
.br
TrueColor or DirectColor visual class server is required to display
True-colored CEL data.
.br
Transrucent image operation is emulated with dither stipple pattern.
.br
Not correspond with Network Audio System.
.br
\fBXdefaults\fP settings are ignored.
.br
If you have any advices and BUG reports,
please send E-mail.
.SH "SEE ALSO"
kissconv(1), celtoppm(1), ppmtocel(1), xkiss(1)
.SH COPYING
.B French\-KISS!
is a public domain soft\fIwear\fP.
Permission to use, copy, modify, distribute and sell this software
for any purpose is granted without fee,
if you do not disturb my original distribution.
.br
To get more informations or current version,
Visit my Website "http://www2s.biglobe.ne.jp/~yav/"
.SH AUTHOR
yav <yav@bigfoot.com>
