/* $Header: /home/yav/catty/fkiss/RCS/headers.h,v 1.11 2000/08/24 02:21:46 yav Exp $
 * fkiss header files and macros for portability
 * written by yav (UHD98984@biglobe.ne.jp)
 */

/* for malloc free... */
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif

#ifndef HAVE_INDEX
# define index strchr
#endif
#ifndef HAVE_RINDEX
# define rindex strrchr
#endif
#ifndef HAVE_BCOPY
# define bcopy(src,dst,len) memcpy((dst),(src),(len))
#endif
#ifndef HAVE_BCMP
# define bcmp(dst,src,len) memcmp((dst),(src),(len))
#endif
#ifndef HAVE_BZERO
# define bzero(dst,len) memset((dst),0,(len))
#endif

#ifndef MAXPATH
# ifdef MAXPATHLEN
#  define MAXPATH MAXPATHLEN
# else
#  define MAXPATH 1024
# endif
#endif

/* for (void *) not supported C-compiler */
#ifdef __STDC__
typedef void *VOIDPTR;
#else
typedef char *VOIDPTR;
#endif

/* get signed short value (little-endian byte order) */
#define GET_SHORT(p) (*((unsigned char *)p)|(*(((char *)p)+1) << 8))

/* variable arguments */

#ifndef USE_STDARG
#ifndef USE_VARARGS
# if HAVE_STDARG_H
#  define USE_STDARG 1
# else
#  if HAVE_VARARGS_H
#   define USE_VARARGS 1
#  endif
# endif
#endif
#endif

#if USE_STDARG
# if HAVE_STDARG_H
#  include <stdarg.h>
# endif
#endif
#if USE_VARARGS
# if HAVE_VARARGS_H
#  include <varargs.h>
# endif
#endif

/* directory access routine */
#ifndef USE_BSD_DIRLIB
# ifndef HAVE_DIRENT_H
#  ifndef HAVE_SYS_NDIR_H
#   ifndef HAVE_SYS_DIR_H
#    ifndef HAVE_NDIR_H
#     define USE_BSD_DIRLIB 0
#    endif
#   endif
#  endif
# endif
# ifndef USE_BSD_DIRLIB
#  define USE_BSD_DIRLIB 1
# endif
#endif

/*
 * If your system have ctype.h header
 * and library functions conformins to ISO 9899 ("ISO C"),
 * uncomment following.
 */
/* #define HAVE_CTYPE_H 1 */

#ifdef HAVE_CTYPE_H
# define is_digit(c) isdigit(c) 
# define is_lower(c) islower(c)
# define is_upper(c) isupper(c)
# define is_alpha(c) isalpha(c)
# define is_alnum(c) isalnum(c)
# define to_lower(c) tolower(c)
#else /* HAVE_CTYPE_H */
/* (for ASCII character set only) */
# define is_digit(c) ('0'<=(c)&&(c)<='9')
# define is_lower(c) ('a'<=(c)&&(c)<='z')
# define is_upper(c) ('A'<=(c)&&(c)<='Z')
# define is_alpha(c) (is_lower(c)||is_upper(c))
# define is_alnum(c) (is_alpha(c)||is_digit(c))
# define to_lower(c) (is_upper(c) ? ((c) + 0x20) : (c))
#endif /* HAVE_CTYPE_H */


#ifndef USE_UNAME
# ifdef HAVE_UNAME
#  ifdef HAVE_SYS_UTSNAME_H
#   define USE_UNAME 1
#  else
#   define USE_UNAME 0
#  endif
# else
#   define USE_UNAME 0
# endif
#endif /* USE_UNAME */


/* End of file */
