/* $Header: /home/yav/catty/fkiss/RCS/jiscode.c,v 1.3 2000/08/24 02:22:37 yav Exp $
 * JIS code <-> Shift-JIS code
 * written by yav (UHD98984@biglobe.ne.jp)
 */

char id_jiscode[] = "$Id: jiscode.c,v 1.3 2000/08/24 02:22:37 yav Exp $";

int is_sjis_1st(c)
     int c;
{
  return ((c)>=0x81 && (c)<=0x9f)||((c)>=0xe0 && (c)<=0xfc);
}

int is_sjis_2nd(c)
     int c;
{
  return ((c)>=0x40 && (c)<=0x7e)||((c)>=0x80 && (c)<=0xfc);
}

unsigned short ysjis2jis(c)
     unsigned short c;
{
  unsigned char h, l;
  unsigned short dd;
  
  h = c >> 8;
  l = c & 0xff;
  if (!is_sjis_1st(h) || !is_sjis_2nd(l))
    return 0;
  if (h >= 0xe0)
    h -= 0x40;
  if (l < 0x9f) {
    if (l >= 0x80)
      l -= 1;
    dd = 0xe11f;
  } else {
    dd = 0xe07e;
  }
  return (h << 9) + l - dd;
}


unsigned short yjis2sjis(c)
     unsigned short c;
{
  unsigned short h, l;
  
  l = c & 0xff;
  h = c >> 8;
  if ((h < 0x21)||(h > 0x7e)||(l < 0x21)||(l > 0x7e))
    return 0;
  if ((h & 1) != 0) {
    l += 0x1f;
    if (l >= 0x7f)
      l++;
  } else {
    l += 0x7e;
  }
  h += 0xe1;
  h >>= 1;
  if (h >= 0xa0)
    h += 0x40;
  return (h << 8) + l;
}

/* End of file */
