/* $Header: /home/yav/catty/fkiss/RCS/kiss.h,v 1.4 2000/08/24 02:22:46 yav Exp $
 * KISS generic definition
 * written by yav (UHD98984@biglobe.ne.jp)
 */

#ifndef _KISS_H
#define _KISS_H

#define MAXSET 10
#define MAXPAL 10

#define KISSGS1_MAXCEL	128
#define KISSGS2_MAXCEL	256
#define KISSGS3_MAXCEL	256
#define KISSGS4_MAXCEL	512

#define KISSGS1_MAXCOL	16
#define KISSGS2_MAXCOL	256
#define KISSGS3_MAXCOL	256
#define KISSGS4_MAXCOL	256

#define FIXED_OBJECT 32767

#define KISS_MAGIC_NUMBER	{0x4b,0x69,0x53,0x53,0} /* "KiSS" */

/* Cel file header */
#define CEL_MARK	4	/* Cel file mark (1byte 0x20) */
#define CEL_BPP		5	/* bits ber pixel (1byte) */
#define CEL_WIDTH	8	/* Width (2byte) */
#define CEL_HEIGHT	10	/* Height (2byte) */
#define CEL_XOFS	12	/* x-offset (2byte) */
#define CEL_YOFS	14	/* y-offset (2byte) */
#define CEL_HEADER_SIZE	32	/* Cel file header size */

#define CEL_OLD_WIDTH	0	/* Width (2byte) */
#define CEL_OLD_HEIGHT	2	/* Height (2byte) */

/* Palette file header */
#define PAL_MARK	4	/* Palette file mark (1byte 0x10) */
#define PAL_BPC		5	/* bits per color (1byte) */
#define PAL_CPPG	8	/* colors per palette group (2byte) */
#define PAL_PG		10	/* number of palette group (2byte) */
#define PAL_HEADER_SIZE	32

/* default screen size for KISS v2.18 compatibility */
#define KISS_WIDTH_DEFAULT	448
#define KISS_HEIGHT_DEFAULT	320

#endif /* _KISS_H */

/* End of file */
