/* $Header: /home/yav/catty/fkiss/RCS/kisseve.c,v 1.33 2000/09/28 07:53:06 yav Exp $
 * KISS event extension
 * written by yav <yav@bigfoot.com>
 *
 * CAUTION!
 * Experiment of event extension, NOT STANDARD!
 * These extensions are ONLY for checking technical problems.
 * Now we are reseaching:
 *  Which functions users need?
 *  What is smart, eazy, simple description style?
 * These problems are resolved, we'll define advanced KISS officially.
 * BUT, THAT'S FUNCTIONS AND DESCRIPTION STYLE WILL BE DIFFERENT FROM THIS!
 *
 *;@EventHandler		; event extension identifier
 *;@never()			; never happen, ignore
 *;@initialize()		; startup event (before reading datas)
 *;@				;  Caution! at this event
 *;@				;  nop, debug, shell, unmap actions available.
 *;@				;  Don't use other actions!
 *;@	nop()			; No operation
 *;@	debug("here!\n")	; print string to stderr for debug
 *;@				;  arg1 string to print
 *;@	shell("echo Hello `whoami`")	; shell
 *;@				;  arg1 string passed to shell
 *;@				;  Caution! No compatibility (OS depend),
 *;@				;  and this function makes SECURITY HOLE.
 *;@				;  So, by default this function is disabled.
 *;@				;  ONLY -eventshell option is specified,
 *;@				;  this function is enabled.
 *;@	unmap("facered.cel")	; unmap cell
 *;@begin()			; begin event (at window is mapped)
 *;@	timer(1, 3000)		; setup timer
 *;@				;  (same as randomtimer(arg1, arg2, 1))
 *;@	randomtimer(1, 3000, 5000)	; setup timer at random
 *;@				;  After arg2+(rand()%arg3) milliseconds,
 *;@				;  event alarm(arg1) will be happen.
 *;@				;  arg1 timer channel number [0, 63]
 *;@				;  arg2 time (milli-second)
 *;@				;       0 <= arg2 <= 32767 (0:disable timer)
 *;@				;  arg3 range of random time (milli-second)
 *;@				;       1 <= arg3 <= 32768-arg2
 *;@end()			; end event ([quit] is selected)
 *;@	sound("bye.au")		; play PCM sound
 *;@				;  arg1 pcm filename (Sun Audio file)
 *;@alarm(1)			; timer alarm
 *;@				;  arg1 timer channel number [0, 63]
 *;@press("vast.cel")		; mouse button press
 *;@				;  arg1 cell filename or object mark
 *;@	map("facered.cel")	; map cell
 *;@				;  arg1 cell filename
 *;@release("vast.cel")		; mouse button release
 *;@				;  arg1 cell filename or object mark
 *;@	unmap("facered.cel")	; unmap cell
 *;@				;  arg1 cell filename
 *;@catch(#1)			; catch object
 *;@				;  arg1 cell filename or object mark
 *;@	altmap("panties.cel")	; alternate map/unmap cell
 *;@				;  arg1 cell filename
 *;@	altmap("panties2.cel")
 *;@drop(#1)			; release object
 *;@				;  arg1 cell filename or object mark
 *;@	altmap("panties.cel")
 *;@	altmap("panties2.cel")
 *;@fixcatch(#1)		; catch fixed object
 *;@				;  arg1 cell filename or object mark
 *;@	sound("iyaan.au")
 *;@fixdrop(#1)			; release fixed object (and object return)
 *;@				;  arg1 cell filename or object mark
 *;@	move(#1, 10, -2)	; move object
 *;@				;  arg1 object mark
 *;@				;  arg2 delta x (pixel)
 *;@				;  arg3 delta y (pixel)
 *;@unfix(#1)			; fix value is cleared! pesi pesi done.
 *;@				;  arg1 cell filename or object mark
 *;@	changeset(2)		; change set
 *;@				;  arg1 destination set number [0, setcnt-1]
 *;@	changecol(2)		; change color group
 *;@				;  arg1 destination color number [0, palcnt-1]
 *;@set(1)			; set changed
 *;@				;  arg1 set number
 *;@col(1)			; color group changed
 *;@				;  arg1 color number
 *;@	quit()			; quit
 *;@    transparent("a.cel", 8)	; change transparency rate
 *;@				;  arg1 cell filename
 *;@				;  arg2 transparency rate add value [-256, 256]
 *;@    windowsize(-200, -100)	; change top level window size
 *;@				; and viewport position is re-centered
 *;@				;  arg1 width add value (pixel)
 *;@				;  arg2 height add value (pixel)
 *;@    viewport(16, 8)		; change viewport position
 *;@				;  arg1 viewport position x add value (pixel)
 *;@				;  arg2 viewport position y add value (pixel)
 *
 * number
 *	10			decimal number
 *	010	(= 8)		octal number heading "0"
 *	0x10	(= 16)		hexadecimal number heading "0x"
 * string
 *	"Sample string"		Any string is quoted by double quotation marks.
 *	"\t<- Tab"		\t Tab
 *	"Newline ->\n"		\n Newline
 *	"\\<-Backslash"		\\ Backslash
 *	"\"<- Doublequote"	\" Double quotation mark
 *      "\$ <- dollar"		\$ Dollar mark
 *				Don't use other \ escaped character!
 * object mark
 *	#10			Object mark is "#" started number.
 *
 */

char id_kisseve[] = "$Id: kisseve.c,v 1.33 2000/09/28 07:53:06 yav Exp $";

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include "config.h"
#include "headers.h"
#include "fkiss.h"
#include "work.h"
#include "timer.h"
#define PUBLIC_KISSEVE_C
#include "extern.h"


/* #define WARN_ACTION	  64	-- warn if more actions for one event */
/* #define WARN_EVENT	  64	-- warn if more event number, now in extern.h */
/* #define WARN_SOUNDFILE 64	-- warn if more soundfiles, now in extern.h */
/* #define WARN_TIMER	  64	-- warn if more timer channels, now in extern.h */
/* #define MAXACTION	 256	-- maximum action for one event (-> extern.h)*/
/* #define MAXEVENT	 256	-- maximum event, now in extern.h */
/* #define MAXSOUNDFILE	 256	-- maximum sound file, now in extern.h */
/* #define MAXTIMER	 256	-- maximum timer channel, now in extern.h */


/* argument type */
#define OT_CEL	1		/* Cell */
#define OT_OBJ	2		/* Object */
#define OT_SND	3		/* Sound */
#define OT_NUM	4		/* Number */
#define OT_STR	5		/* String */
#define OT_TCH	6		/* Timer channel number */
#define OT_SET	7		/* Set number */
#define OT_COL	8		/* Color group number */

#define EOBJN 3			/* maximum number of event arguments */
#define AOBJN 3			/* maximum number of action arguments */
#if (EOBJN > AOBJN)
# define MAXARGN EOBJN
#else
# define MAXARGN AOBJN
#endif

typedef struct {
  short type;			/* argument type */
  short no;			/* argument code */
  char *name;			/* filename */
} EVOBJ;			/* argument structure */

typedef struct {
  short n;			/* action type */
  EVOBJ aobj[AOBJN];		/* argument */
} ACTION;


typedef struct {
  short elineno;		/* cnf line number */
  short evtype;			/* event type */
  EVOBJ eobj[EOBJN];		/* event argument */
  short alineno;		/* cnf line number action */
  short actn;			/* number of actions (<= MAXACTION) */
				/* nothing changed with alineno, but it is:*/
				/* cnf line number of LAST action of event */
				/* (maybe this is not like it should be ?) */
  ACTION *act;			/* actions */
} EVT;

typedef struct {
  int channel;
  struct TMV alarmtime;
  struct TMV starttime;
} TIMER;


static Bool event_ok = False;
static EVT *evtbl = NULL;	/* event table */
static int soundn = 0;		/* number of sound files (<= MAXSOUNDFILE) */
static char **soundlist = NULL;
static TIMER *timertbl = NULL;
static int timertbln = 0;
static int active_timer;	/* number of active timer-channels */

typedef struct {
  struct TMV tm0;		/* event occured time */
  long event_delay;		/* event delay milliseconds */
  int redraw_xtop, redraw_ytop;
  int redraw_xend, redraw_yend;
} EVW;

/* global buffer for error messages, such as "file not found" */
static char G_ERRbuf[80] = { '\0', /* fill up the rest */ };

/* keyword table */
typedef struct {
  char *str;			/* keyword */
  short n;			/* code */
  char argt[MAXARGN+1];		/* argument type (+1 for terminater 0) */
} KEYWORD_TABLE;

#define KTBL(code,name,pt0,pt1,pt2,pt3) \
{name, code, {pt0, pt1, pt2, pt3}}

static KEYWORD_TABLE event_syntax[] = {
  /* code		keyword 	pt0	pt1	pt2	pt3 */
  KTBL(EVE_NEVER,	"never",	0,	0,	0,	0),
  KTBL(EVE_INITIALIZE,	"initialize",	0,	0,	0,	0),
  KTBL(EVE_ALARM,	"alarm",	OT_TCH,	0,	0,	0),
  KTBL(EVE_BEGIN,	"begin",	0,	0,	0,	0),
  KTBL(EVE_END,		"end",		0,	0,	0,	0),
  KTBL(EVE_PRESS,	"press",	OT_CEL,	0,	0,	0),
  KTBL(EVE_RELEASE,	"release",	OT_CEL,	0,	0,	0),
  KTBL(EVE_CATCH,	"catch",	OT_CEL,	0,	0,	0),
  KTBL(EVE_DROP,	"drop",		OT_CEL,	0,	0,	0),
  KTBL(EVE_FIXCATCH,	"fixcatch",	OT_CEL,	0,	0,	0),
  KTBL(EVE_FIXDROP,	"fixdrop",	OT_CEL,	0,	0,	0),
  KTBL(EVE_UNFIX,	"unfix",	OT_CEL,	0,	0,	0),
  KTBL(EVE_SET,		"set",		OT_SET,	0,	0,	0),
  KTBL(EVE_COL,		"col",		OT_COL,	0,	0,	0),
  KTBL(EVE_IN,		"in",		OT_OBJ,	OT_OBJ,	0,	0),
  KTBL(EVE_OUT,		"out",		OT_OBJ,	OT_OBJ,	0,	0),
  KTBL(EVE_STILLIN,	"stillin",	OT_OBJ,	OT_OBJ,	0,	0),
  KTBL(EVE_STILLOUT,	"stillout",	OT_OBJ,	OT_OBJ,	0,	0),
  KTBL(EVE_COLLIDE,	"collide",	OT_CEL,	OT_CEL,	0,	0),
  KTBL(EVE_APART,	"apart",	OT_CEL,	OT_CEL,	0,	0),
  KTBL(EVE_VERSION,	"version",	OT_NUM,	0,	0,	0),
  KTBL(ACT_NOP,		"nop",		0,	0,	0,	0),
  KTBL(ACT_DEBUG,	"debug",	OT_STR,	0,	0,	0),
  KTBL(ACT_SHELL,	"shell",	OT_STR,	0,	0,	0),
  KTBL(ACT_UNMAP,	"unmap",	OT_CEL,	0,	0,	0),
  KTBL(ACT_MAP,		"map",		OT_CEL,	0,	0,	0),
  KTBL(ACT_ALTMAP,	"altmap",	OT_CEL,	0,	0,	0),
  KTBL(ACT_MOVE,	"move",		OT_OBJ,	OT_NUM,	OT_NUM,	0),
  KTBL(ACT_SOUND,	"sound",	OT_SND,	0,	0,	0),
  KTBL(ACT_TIMER,	"timer",	OT_TCH,	OT_NUM,	0,	0),
  KTBL(ACT_RANDOMTIMER,	"randomtimer",	OT_TCH,	OT_NUM,	OT_NUM,	0),
  KTBL(ACT_QUIT,	"quit",		0,	0,	0,	0),
  KTBL(ACT_CHANGESET,	"changeset",	OT_SET,	0,	0,	0),
  KTBL(ACT_CHANGECOL,	"changecol",	OT_COL,	0,	0,	0),
  KTBL(ACT_TRANSPARENT,	"transparent",	OT_CEL,	OT_NUM,	0,	0),
  KTBL(ACT_WINDOWSIZE,	"windowsize",	OT_NUM,	OT_NUM,	0,	0),
  KTBL(ACT_VIEWPORT,	"viewport",	OT_NUM,	OT_NUM,	0,	0),
  KTBL(ACT_IFFIXED,	"iffixed",	OT_OBJ,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_IFNOTFIXED,	"ifnotfixed",	OT_OBJ,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_IFMAPPED,	"ifmapped",	OT_CEL,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_IFNOTMAPPED,	"ifnotmapped",	OT_CEL,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_IFMOVED,	"ifmoved",	OT_OBJ,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_IFNOTMOVED,	"ifnotmoved",	OT_OBJ,	OT_TCH,	OT_NUM,	0),
  KTBL(ACT_SETFIX,	"setfix",	OT_OBJ,	OT_NUM,	0,	0),
  KTBL(ACT_MOVEBYX,	"movebyx",	OT_OBJ,	OT_OBJ,	OT_NUM,	0),
  KTBL(ACT_MOVEBYY,	"movebyy",	OT_OBJ,	OT_OBJ,	OT_NUM,	0),
  KTBL(ACT_MOVETO,	"moveto",	OT_OBJ,	OT_NUM,	OT_NUM,	0),
  KTBL(ACT_MOVERANDX,	"moverandx",	OT_OBJ,	OT_NUM,	OT_NUM,	0),
  KTBL(ACT_MOVERANDY,	"moverandy",	OT_OBJ,	OT_NUM,	OT_NUM,	0),
  KTBL(ACT_MOVETORAND,	"movetorand",	OT_OBJ,	0,	0,	0),
  KTBL(ACT_MUSIC,	"music",	OT_SND,	0,	0,	0),
  KTBL(ACT_NOTIFY,	"notify",	OT_STR,	0,	0,	0),
  KTBL(-1, 		NULL,		0,	0,	0,	0)
};

#define get_syntax(code) (event_syntax + ((code) & ~(BIT_EVENT|BIT_ACTION)))

int parse_keyword(str)
     char *str;
{
  KEYWORD_TABLE *p;

  for (p = event_syntax; p->n >= 0; p++) {
    if (strcmp(str, p->str) == 0)
      return p->n;
  }
  return -1;			/* keyword not found */
}


char *eval_env(str)
     char *str;			/* Caution! str destroyed */
{
  char *p;
  char *ep;
  int mode;
  
  p = str;
  mode = 0;
  while (!mode && *p) {
    switch (*p) {
    case '-':
    case '=':
    case '+':
    case '?':
      mode = *p;
    case ':':			/* Quick hack, no check ":str" */
      *p = '\0';
      /* FALL THROUGH */
    default:
      p++;
      break;
    }
  }
  ep = getenv(str);
  switch (mode) {
  case '=':
    if (ep == NULL) {
      ep = ks_strdup(p);
      setenv(str, ep, 0);
    }
    break;
  case '-':
    if (ep == NULL)
      ep = ks_strdup(p);
    break;
  case '+':
    if (ep != NULL)
      ep = ks_strdup(p);
    break;
  case '?':
    if (ep == NULL) {
      if (!*p)
	p = "parameter null or not set";
      fprintf(stderr, "%s: %s: %s\n", *oargv, str, p);
    }
    break;
  }
  if (ep == NULL)
    ep = "";
  return ep;			/* Caution! Cannot to free this */
}

/* parse_string - parse string
 * str
 *  >"hello\tworld Here we go!"
 * buf (len = 8)
 *   012345	67
 *  >hello	w
 *
 * return malloced buffer address
 *
 * Analyze:
 *  Heading quotation mark ("/! look quote_charset[])
 *  '\' escaped character (\t \r \n \" \\)
 *  $USER or ${USER} replaced to environment variable "USER"
 * 
 */
char *parse_string(p, charset)
     char **p;			/* string ptr to parse */
     char *charset;		/* available character set (not quoted)
				 * (NULL:all)
				 */
{
  int c;
  int quote;			/* quote character (0:Not quoted) */
  Bool escaped;			/* \ escaped flag */
  Bool inkanji;			/* at Kanji 2nd byte flag */
  int in_env, env_brace;
  LSTR str;
  LSTR env_name;
  static char quote_charset[] = "\"/!";
  
  lstr_init(&str);
  lstr_init(&env_name);
  in_env = env_brace = 0;
  inkanji = escaped = False;
  quote = (**p && index(quote_charset, **p) != NULL) ? *(*p)++ : 0;
  while ((c = **p) != '\0') {
    ++*p;
    if (escaped) {
      switch (c) {
      case 'n':			/* Newline */
	c = '\n';
	break;
      case 'r':			/* CR */
	c = '\r';
	break;
      case 't':			/* Tab */
	c = '\t';
	break;
      default:			/* " or \ or $ */
	break;
      }
      escaped = False;
    } else {
      if (!inkanji) {
	if (c == '\\') {
	  escaped = True;	/* Escape character */
	  continue;
	}
	if (in_env) {
	  if ((env_brace && c == '}') || (!env_brace && !is_alnum(c) && c != '_')) {
	    in_env = 0;
	    lstr_cat(&str, eval_env(env_name.buf));
	    free(env_name.buf);
	    lstr_init(&env_name);
	    if (!env_brace)
	      lstr_ch(&str, c);
	    env_brace = 0;
	  } else {
	    lstr_ch(&env_name, c);
	  }
	  continue;
	}
	if (c == '$') {		/* Shell variable? */
	  in_env = 1;
	  if (**p == '{') {
	    ++*p;
	    env_brace = 1;
	  } else {
	    env_brace = 0;
	  }
	  continue;
	}
	if (quote) {
	  if (c == quote)
	    break;		/* quoted, terminated only quote char */
	} else {
	  if (charset != NULL && index(charset, c) == NULL)
	    break;
	}
      }
    }
    lstr_ch(&str, c);
    inkanji = inkanji ? 0 : is_sjis_1st(c & 0xff);
  }
  if (inkanji) {		/* Kanji 2nd byte? */
    /* --*p; */
    lstr_bs(&str);
  }
  if (in_env) {
    lstr_cat(&str, eval_env(env_name.buf));
    free(env_name.buf);
  }
  return str.buf;
}

/*
 * get token
 * return malloced token buffer
 */
char *get_token(p)
     char **p;			/* string address to parse */
{
  static char token_set[] =
    "#-+/.0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  
  while (**p && (**p != '"') && (index(token_set, **p) == NULL))
    ++*p;
  return parse_string(p, token_set);
}


void addhit(c1, c2)
     int c1;
     int c2;
{
  int hn;
  HITP *hp;
  int i;
  
  hn = (cell+c1)->hitn;
  hp = (cell+c1)->hitp;
  for (i = 0; i < hn; i++) {
    if ((hp + i)->n == c2)
      return;
  }
  if (hp == NULL)
    hp = (HITP *)ks_malloc(sizeof(*hp));
  else
    hp = (HITP *)ks_realloc(hp, (hn + 1) * sizeof(*hp));
  (hp + hn)->n = c2;
  (hp + hn)->s = 0;
  (cell+c1)->hitn = ++hn;
  (cell+c1)->hitp = hp;
}

void addobjhit(o1, o2)
     int o1;
     int o2;
{
  int hn;
  HITP *hp;
  int i;
  
  hn = (object+o1)->ohitn;
  hp = (object+o1)->ohitp;
  for (i = 0; i < hn; i++) {
    if ((hp + i)->n == o2)
      return;
  }
  if (hp == NULL)
    hp = (HITP *)ks_malloc(sizeof(*hp));
  else
    hp = (HITP *)ks_realloc(hp, (hn + 1) * sizeof(*hp));
  (hp + hn)->n = o2;
  (hp + hn)->s = 0;
  (object+o1)->ohitn = ++hn;
  (object+o1)->ohitp = hp;
}

void init_hitck1(p)
     EVT *p;
{
  switch (p->evtype) {
  case EVE_COLLIDE:
  case EVE_APART:
    if (p->eobj[0].type != OT_CEL) {
      msg("W (%d) init_hitck: Not Cel '%s'!\n",
	  p->elineno, p->eobj[0].name);
    } else if (p->eobj[1].type != OT_CEL) {
      msg("W (%d) init_hitck: Not Cel '%s'!\n",
	  p->elineno, p->eobj[1].name);
    } else {
      addhit(p->eobj[0].no, p->eobj[1].no);
      addhit(p->eobj[1].no, p->eobj[0].no);
    }
    break;
  case EVE_IN:
  case EVE_STILLIN:
  case EVE_OUT:
  case EVE_STILLOUT:
    if (p->eobj[0].type != OT_OBJ) {
      msg("W (%d) init_hitck: Not object '%s'!\n",
	  p->elineno, p->eobj[0].name);
    } else if (p->eobj[1].type != OT_OBJ) {
      msg("W (%d) init_hitck: Not object '%s'!\n",
	  p->elineno, p->eobj[1].name);
    } else {
      addobjhit(p->eobj[0].no, p->eobj[1].no);
      addobjhit(p->eobj[1].no, p->eobj[0].no);
    }
    break;
  }
}

void init_hitck()
{
  int i;
  EVT *p;
  
  for (p = evtbl, i = 0; i < evn; p++, i++) {
    init_hitck1(p);
  }
}

/* cnf_event - parse event description line in KISS configuration file
 */
int cnf_event(p, lineno)
     char *p;
     int lineno;		/* cnf line number (from 1) */
{
  int i, n, r;
  char *token;
  static EVT *evp = NULL;

  if (evtbl == NULL) {
    if ( ! (evtbl = (EVT *)malloc(sizeof(EVT)*MAXEVENT)) ) {
      msgset("E out of core while allocating %d bytes for %d events !\n",
	     sizeof(EVT)*MAXEVENT, MAXEVENT);
    }
    /* if we reach this point, all went fine */
  }
  r = 0;
  while (*p) {
    token = get_token(&p);
    if (!*token) {
      free(token);
      break;
    }
    n = parse_keyword(token);
    if (n < 0) {
      msgset("W ``%s'' unknown keyword.\n", token);
      free(token);
      return -1;		/* keyword error */
    }
    free(token);
    if (n & BIT_EVENT) {
      if (evn >= WARN_EVENT) {
	msgset("W events over %d!\n", WARN_EVENT);
	r = -1;			/* event over error */
      }
      if (evn >= MAXEVENT) {
        MAXEVENT++;
        /* allocating enough core for 1 event more : */
        if ( ! (evtbl = (EVT *)realloc(evtbl,sizeof(EVT)*MAXEVENT)) ) {
	  msgset("E out of core while allocating %d bytes for %d events !\n",
		 sizeof(EVT)*MAXEVENT, MAXEVENT);
	}
	/* if we reach this point, all went fine */
      }	
      evp = evtbl + evn++;
      evp->elineno = lineno;
      evp->evtype = n;
      for (i = 0; get_syntax(n)->argt[i]; i++) {
	evp->eobj[i].name = get_token(&p);
      }
      evp->actn = 0;
      /* allocating core for exactly 1 action (the first) */
      if ( ! (evp->act = (ACTION *)malloc(sizeof(ACTION))) ) {
        msgset("E out of core while allocating %d bytes for 1 action !\n",
               sizeof(ACTION));
      }
    } else if (n & BIT_ACTION) {
      int atmp = 0;
      ACTION	*ap_tmp	= NULL;
      if ( !evp ) {
        msgset("W action without an event.\n");
        return -1;
      }
      atmp	= evp->actn + 2;
      evp->alineno = lineno;
      if (evp->actn >= WARN_ACTION) {
	msgset("W actions over %d!\n", WARN_ACTION);
	r = -1;			/* action over error */
      }
      if (evp->actn >= MAXACTION) {
	msgset("W actions over %d, action ignored!\n", MAXACTION);
	return -1;              /* no space to store action, abort! */
      }
      evp->act[evp->actn].n = n;
      for (i = 0; get_syntax(n)->argt[i]; i++) {
	evp->act[evp->actn].aobj[i].name = get_token(&p);
      }
      /* allocating core for 1 action more */
      ap_tmp = (ACTION *)realloc(evp->act,sizeof(ACTION)*atmp);
      if ( ! ap_tmp ) {
	msgset( "E out of core while allocating %d bytes for %d actions !\n",
		sizeof(ACTION), atmp);
      } else { /* this may be unneccesary, but I'm unsure and it doesn't hurt */
	evp->act = ap_tmp;
      }
      evp->actn++;
      debug_printf("evp->actn=%d,\n", evp->actn);
    }
  }
  return r;			/* return error code */
}

int get_named_sound(name)
     char *name;
{
  int i;
  
  for (i = 0; i < soundn; i++) {
    if (strcmp(*(soundlist+i), name) == 0)
    {
      debug_printf("<SL:%d>\n", i);
      return i;
    }     
  }
  for (i = 0; i < soundn; i++) {
    if (strcmp_dos_filename(*(soundlist+i), name) == 0) {
      if (warncase) {
	msg("W use sound file ``%s'' instead of ``%s''\n",
	    *(soundlist+i), name);
      }
      debug_printf("<SF:%s,%s>\n", *(soundlist+i),name);
      return i;
    }
  }
  return -1;			/* not found */
}

int get_named_cell(name)
     char *name;
{
  int i;
  
  for (i = 0; i < celcnt; i++) {
    if (strcmp((cell+i)->filename, name) == 0)
      return i;
  }
  for (i = 0; i < celcnt; i++) {
    if (strcmp_dos_filename((cell+i)->filename, name) == 0) {
      if (warncase) {
        msg("W use cel file ``%s'' instead of ``%s''\n",
	    (cell+i)->filename, name);
      }
      return i;
    }
  }
  return -1;			/* not found */
}

/* return registrated objno */
int regist_object(type, str, errorcode)
     int type;			/* object type */
     char *str;
     int *errorcode;		/* return error code */
{
  int r;

  r = strtol(str, NULL, 0);
  switch (type) {
  case OT_SND:
    if (soundn >= WARN_SOUNDFILE) {
      msg("W sound files over %d!\n", WARN_SOUNDFILE);
      *errorcode = 1;
    }
    if (soundn >= MAXSOUNDFILE) {
      *errorcode = -1;
      return -1;		/* sound file over error */
    }
    *(soundlist+soundn++) = ks_strdup(str);
    return soundn-1;
  case OT_TCH:
#if 0
    if (r < 0 || r >= MAXTIMER) {
      msg("W timer channel must be 0 to %d, ignoring timer channel %d !\n",
          MAXTIMER, r);
      *errorcode = r = -1;
    }
#endif
    if (r < 0 || r >= WARN_TIMER) {
      msg("W timer channels over %d!\n", WARN_TIMER);
      *errorcode = 1;
    }
    break;
  case OT_SET:
    if (r < 0 || r >= 10) {
      msg("W set number must be 0 to %d!\n", setcnt-1);
      msg("W ignore set number %d.\n", r);
      *errorcode = r = -1;
    }
    break;
  case OT_COL:
    if (r < 0 || r >= 10) {
      msg("W col number must be 0 to %d!\n", palcnt-1);
      msg("W ignore col number %d.\n", r);
      *errorcode = r = -1;
    }
    break;
  case OT_NUM:
  case OT_STR:
    break;
  default:
    *errorcode = r = -1;	/* error */
  }
  return r;
}

/* return error code
 *   == 0 : no error
 *   >  0 : warning
 *   <  0 : error
 */
int parse_argument(p, str, rtype)
     EVOBJ *p;			/* p->type, p->no update */
     char *str;
     int rtype;			/* default type */
{
  int r;

  r = 0;
  if (rtype != OT_STR) {
    switch(*str) {
    case '#':
      p->type = OT_OBJ;
      p->no = strtol(str+1, NULL, 10);
      break;
    default:
      p->type = OT_CEL;
      p->no = get_named_cell(str);
      if (p->no < 0) {
	p->type = OT_SND;
	p->no = get_named_sound(str);
      }
      break;
    }
  }
  if (p->no < 0) {
    p->type = rtype;
    p->no = regist_object(rtype, str, &r);
    sprintf(G_ERRbuf,"''%s'' is not part of any object", str);
    debug_printf(" obj(%d,%d)=[%s]", p->type, p->no, str);
    if (p->no < 0 && rtype != OT_NUM && rtype != OT_STR)
      p->type = -1;
  } else {
    debug_printf(" obj(%d,%d)", p->type, p->no);
  }
  return r;
}

/* return : line number error detected (0 no error) */
int compile_event(n)
     int n;
{
  int j, k;
  int r, errline;
  EVT *ep;
  ACTION *ap;
  
  if (!n) {
    /* first line allocate work area */
    soundlist = (char **)ks_malloc(sizeof(char *)*MAXSOUNDFILE);
    timertbl = (TIMER *)ks_malloc(sizeof(TIMER)*MAXTIMER);
    timertbln = MAXTIMER;
    active_timer = 0;
    /* reset all timers */
    bzero((char *)timertbl, sizeof(TIMER)*MAXTIMER);
  }
  ep = evtbl + n;
  debug_printf("%6d,%6d:\tevent %d: %s(",
	       ep->elineno, ep->alineno, n, get_syntax(ep->evtype)->str);
  errline = 0;			/* reset error line */
  for (j = 0; get_syntax(ep->evtype)->argt[j]; j++) {
    debug_printf("%s%s", !j?"":",", ep->eobj[j].name);
    r = parse_argument(&ep->eobj[j], ep->eobj[j].name,
		       get_syntax(ep->evtype)->argt[j]);
    if (r && ep->eobj[j].type != OT_NUM && ep->eobj[j].type != OT_STR) {
      errline = ep->elineno;
      if (r < 0) {
	ep->evtype = 0;		/* ignore this event */
	return errline;		/* abort compile */
      }
    }
  }
  debug_printf(").\n");
  
  for (ap = ep->act, j = 0; j < ep->actn; ap++, j++) {
    debug_printf("%6d,%6d:\t  action %d: %s(",
		 ep->elineno, ep->alineno, j, get_syntax(ap->n)->str);
    for (k = 0; get_syntax(ap->n)->argt[k]; k++) {
      debug_printf("%s%s", !k?"":",", ap->aobj[k].name);
      r = parse_argument(&ap->aobj[k], ap->aobj[k].name,
			 get_syntax(ap->n)->argt[k]);
      if (r < 0 && ! debug_mode)
        msg("W (somewhere between line%6d and line%6d)\n\t\t%s!\n", 
            ep->elineno, ep->alineno, G_ERRbuf);
      if (r && ap->aobj[k].type != OT_NUM && ap->aobj[k].type != OT_STR) {
	errline = ep->alineno;
	if (r < 0)
	  ap->n = ACT_NOP;	/* ignore this action */
      }
    }
    debug_printf(").\n");
  }
  return errline;
}

void init_redraw_area(evw)
     EVW *evw;
{
  evw->redraw_xtop = imgw;
  evw->redraw_ytop = imgh;
  evw->redraw_xend = evw->redraw_yend = 0;
}

void add_redraw_area(evw, x, y, w, h)
     EVW *evw;
     int x;
     int y;
     int w;
     int h;
{
  if (x < evw->redraw_xtop)
    evw->redraw_xtop = x;
  if (y < evw->redraw_ytop)
    evw->redraw_ytop = y;
  if (x + w > evw->redraw_xend)
    evw->redraw_xend = x + w;
  if (y + h > evw->redraw_yend)
    evw->redraw_yend = y + h;
}

void update_redraw_area(evw)
     EVW *evw;
{
  int w, h;
  
  w = evw->redraw_xend - evw->redraw_xtop;
  h = evw->redraw_yend - evw->redraw_ytop;
  if (w > 0 && h > 0)
    redraw_cells(evw->redraw_xtop, evw->redraw_ytop, w, h);
}

void delete_timer(ch)
     int ch;
{
  int i, n;
  TIMER *p;
  
  for (p = timertbl, i = 0; i < active_timer; p++, i++) {
    if (p->channel == ch) {
      n = active_timer - i - 1;
      if (n > 0) {
	bcopy(p+1, p, sizeof(*p)*n);
      }
      --active_timer;
      break;
    }
  }
}

/* set timer
 * starttime = tm0 - event_delay
 */
void set_timer(evw, ch, n)
     EVW *evw;
     int ch;
     int n;
{
  int i;
  TIMER *p;
  TIMER tm;

  delete_timer(ch);
  if (n == 0 && !wkiss_bug_emulation)
    return;

  bcopy(&evw->tm0, &tm.starttime, sizeof(struct TMV));
  add_time(&tm.starttime, -evw->event_delay);
  bcopy(&tm.starttime, &tm.alarmtime, sizeof(struct TMV));
  add_time(&tm.alarmtime, n);

  if (active_timer >= timertbln) {
    timertbln++;
    timertbl = (TIMER *)ks_realloc(timertbl, sizeof(TIMER)*timertbln);
  }
  for (p = timertbl, i = 0; i < active_timer; p++, i++) {
    if (diff_time(&p->alarmtime, &tm.alarmtime) > 0)
      break;
  }
  i = active_timer - i;
  if (i > 0) {
    bcopy(p, p+1, sizeof(TIMER)*i);
  }
  bcopy(&tm, p, sizeof(TIMER));
  p->channel = ch;
  active_timer++;
}

/* change cell mapping status
 * return  0: No need to update image
 */
int change_cel_mapping(evw, p, status)
     EVW *evw;
     CELL *p;
     int status;
{
  int n;
  
  switch (status) {
  case ACT_UNMAP:		/* unmap */
    if (p->unmap)
      return 0;			/* already unmapped */
    p->unmap = 1;
    break;
  case ACT_MAP:			/* map */
    if (!p->unmap)
      return 0;			/* already mapped */
    p->unmap = 0;
    break;
  case ACT_ALTMAP:		/* altmap */
    p->unmap ^= 1;
    break;
  default:			/* ??? unknown mode ??? */
    return 0;
  }
  debug_printf("! %s [%s] !\n", p->unmap ? "unmap" : "map", p->filename);
  if (!p->setflag[cset])
    return 0;			/* no need to update image */
  n = p->obj;
  add_redraw_area(evw,
		  (kset[cset].obj+n)->x + p->ofsx,
		  (kset[cset].obj+n)->y + p->ofsy,
		  p->width, p->height);
  return 1;			/* cel mapping status is changed! */
}

int change_aobj_mapping(evw, p, status)
     EVW *evw;
     EVOBJ *p;
     int status;
{
  int i, r;
  
  r = 0;
  switch(p->type) {
  case OT_CEL:
    r = change_cel_mapping(evw, cell+p->no, status);
    break;
  case OT_OBJ:
    for (i = 0; i < celcnt; i++)
      if ((cell+i)->obj == p->no)
	r |= change_cel_mapping(evw, cell+i, status);
    break;
  default:
    msg("W change_aobj_mapping: type %d cannot to change mapping\n", p->type);
    break;
  }
  return r;
}

/* change cell transparency level
 * return  0: No need to update image
 */
int change_cel_transparency(evw, p, d)
     EVW *evw;
     CELL *p;
     int d;			/* transparency add value */
{
  int n;
  
  n = p->transparency + d;
  if (n < 0)
    n = 0;
  else if (n > 256)
    n = 256;
  if (n == p->transparency)
    return 0;			/* transparency level is not changed! */
  debug_printf("! transparency [%s] %d -> %d !\n",
	       p->filename, p->transparency, n);
  if (p->clip == 0) {
    p->transparency = n;
    return 0;                   /* just set transparency.  transclip */
  }                             /* will be set after we load clip */
  set_transparency(p, n);
  if (!p->setflag[cset] || p->unmap)
    return 0;			/* no need to update image */
  add_redraw_area(evw,
		  (kset[cset].obj+p->obj)->x + p->ofsx,
		  (kset[cset].obj+p->obj)->y + p->ofsy,
		  p->width, p->height);
  return 1;			/* cel mapping status is changed! */
}

int change_aobj_transparency(evw, p, n)
     EVW *evw;
     EVOBJ *p;
     int n;
{
  int i, r;
  
  r = 0;
  switch(p->type) {
  case OT_CEL:
    r = change_cel_transparency(evw, cell+p->no, n);
    break;
  case OT_OBJ:
    for (i = 0; i < celcnt; i++)
      if ((cell+i)->obj == p->no)
	r |= change_cel_transparency(evw, cell+i, n);
    break;
  default:
    msg("W change_aobj_transparency: type %d cannot to change transparency\n", p->type);
    break;
  }
  return r;
}

void cond_set_timer(evw, ap)
     EVW *evw;
     ACTION *ap;
{
  int f;
  
  f = 0;
  switch (ap->n) {
  case ACT_IFMOVED:
    f = ((kset[cset].obj+ap->aobj[0].no)->x !=
	 (kset[cset].obj+ap->aobj[0].no)->ox ||
	 (kset[cset].obj+ap->aobj[0].no)->y !=
	 (kset[cset].obj+ap->aobj[0].no)->oy);
    break;
  case ACT_IFNOTMOVED:
    f = ((kset[cset].obj+ap->aobj[0].no)->x ==
	 (kset[cset].obj+ap->aobj[0].no)->ox &&
	 (kset[cset].obj+ap->aobj[0].no)->y ==
	 (kset[cset].obj+ap->aobj[0].no)->oy);
    break;
  case ACT_IFFIXED:
    f = ((object + ap->aobj[0].no)->pesi >= (object + ap->aobj[0].no)->fix);
    break;
  case ACT_IFNOTFIXED:
    f = ((object + ap->aobj[0].no)->pesi < (object + ap->aobj[0].no)->fix);
    break;
  case ACT_IFMAPPED:
    f = !(cell + ap->aobj[0].no)->unmap;
    break;
  case ACT_IFNOTMAPPED:
    f = (cell + ap->aobj[0].no)->unmap;
    break;
  }
  if (!f)
    return;

  set_timer(evw, ap->aobj[1].no, ap->aobj[2].no);
  debug_printf("! %s(%d,%d,%d) ",
	       get_syntax(ap->n)->str,
	       ap->aobj[0].no, ap->aobj[1].no, ap->aobj[2].no);
  if (ap->aobj[2].no)
    debug_printf("%.19s.%06ld ",
		 ctime(&(timertbl+ap->aobj[1].no)->starttime.tv_sec),
		 (timertbl+ap->aobj[1].no)->starttime.tv_usec);
  debug_printf(" !\n");
}

int act_move(evw, ap)
     EVW *evw;
     ACTION *ap;
{
  int x, y;
  int n, r;
  int i;
  EVHITWK hit;
  AREA ar;
  extern EVHITWK mouse_move_hit; /* fkiss.c */
  extern int moving_object;	/* fkiss.c */
  int mo;
  
  r = 0;
  n = ap->aobj[0].no;
  if (ap->aobj[0].type == OT_CEL)
    n = (cell+n)->obj;
  mo = moving_object;
  if (mo >= 0) {
    moving_object = -1;
    move_object_end(&mouse_move_hit);
  }
  move_object_start(&hit, n);
  x = (kset[cset].obj+n)->x;
  y = (kset[cset].obj+n)->y;
  switch (ap->n) {
  case ACT_MOVE:
    x += ap->aobj[1].no;
    y += ap->aobj[2].no;
    break;
  case ACT_MOVEBYX:
    x = (kset[cset].obj+ap->aobj[1].no)->x + ap->aobj[2].no;
    break;
  case ACT_MOVEBYY:
    y = (kset[cset].obj+ap->aobj[1].no)->y + ap->aobj[2].no;
    break;
  case ACT_MOVETO:
    x = ap->aobj[1].no;
    y = ap->aobj[2].no;
    break;
  case ACT_MOVERANDX:
    i = ap->aobj[2].no - ap->aobj[1].no ;
    if (i > 0)
      x += ap->aobj[1].no + ks_rand() % (i+1);
    break;
  case ACT_MOVERANDY:
    i = ap->aobj[2].no - ap->aobj[1].no;
    if (i > 0)
      y += ap->aobj[1].no + ks_rand() % (i+1);
    break;
  case ACT_MOVETORAND:
    i = imgw - (object+n)->width;
    if (i > 0)
      x = ks_rand() % (i+1);
    i = imgh - (object+n)->height;
    if (i > 0)
      y = ks_rand() % (i+1);
    break;
  }
  if (move_object2(n, x, y,&ar)) {
    add_redraw_area(evw, ar.x, ar.y, ar.w, ar.h);
    r |= ACTBIT_MAP;
    debug_printf("! %s(%d,%d,%d) !\n", get_syntax(ap->n)->str, n, x, y);
  }
  move_object_end(&hit);
  if (mo >= 0) {
    move_object_start(&mouse_move_hit, mo);
    moving_object = mo;
  }
  return r;
}

/*
 * return changed status infrmation bits
 * ACTBIT_SOUND:on sound played
 * ACTBIT_MAP:on cell mapping status changed, need to update image
 */
int event_action(evw, p, r)
     EVW *evw;
     EVT *p;
     int r;
{
  int i, n;
  int mapping_action;
  int newset, newcol;
  int w, h;
  ACTION *ap;
  
  newset = newcol = -1;
  for (ap = p->act, i = 0; i < p->actn; ap++, i++) {
    n = mapping_action = 0;
    switch(ap->n) {
    case ACT_MUSIC:
    case ACT_SOUND:
      if (!(r & ACTBIT_SOUND)) {
	debug_printf("! sound(%s) !\n", *(soundlist+ap->aobj[0].no));
	bg_play(*(soundlist+ap->aobj[0].no));
	r |= ACTBIT_SOUND;
      }
      break;
    case ACT_MAP:
    case ACT_UNMAP:
    case ACT_ALTMAP:
      mapping_action = ap->n;
      break;
    case ACT_CHANGESET:
      newset = ap->aobj[0].no;
      break;
    case ACT_CHANGECOL:
      newcol = ap->aobj[0].no;
      break;
    case ACT_RANDOMTIMER:
      if (ap->aobj[1].no && ap->aobj[2].no)
	n = ks_rand() % ap->aobj[2].no;
      /* FALL THROUGH */
    case ACT_TIMER:
      n += ap->aobj[1].no;
      set_timer(evw, ap->aobj[0].no, n);
      debug_printf("! timer(%d,%d) ", ap->aobj[0].no, n);
      if (n)
	debug_printf("%.19s.%06ld ",
		     ctime(&(timertbl+ap->aobj[0].no)->starttime.tv_sec),
		     (timertbl+ap->aobj[0].no)->starttime.tv_usec);
      debug_printf(" !\n");
      break;
    case ACT_IFMOVED:
    case ACT_IFNOTMOVED:
    case ACT_IFFIXED:
    case ACT_IFNOTFIXED:
    case ACT_IFMAPPED:
    case ACT_IFNOTMAPPED:
      cond_set_timer(evw, ap);
      break;
    case ACT_SETFIX:
      debug_printf("! setfix(%d,%d) !\n", ap->aobj[0].no, ap->aobj[1].no);
      (object + ap->aobj[0].no)->fix = ap->aobj[1].no;
      /* (object + ap->aobj[0].no)->pesi = 0; */
      if (!ap->aobj[1].no) {
	kissevent_handler2(EVE_UNFIX, ap->aobj[0].no, 1);
      }
      break;
    case ACT_MOVE:
    case ACT_MOVEBYX:
    case ACT_MOVEBYY:
    case ACT_MOVETO:
    case ACT_MOVERANDX:
    case ACT_MOVERANDY:
    case ACT_MOVETORAND:
      r |= act_move(evw, ap);
      break;
    case ACT_TRANSPARENT:
      debug_printf("! transparent(%d,%d) !\n", ap->aobj[0].no, ap->aobj[1].no);
      if (change_aobj_transparency(evw, &ap->aobj[0], ap->aobj[1].no))
	r |= ACTBIT_MAP;
      break;
    case ACT_WINDOWSIZE:
      debug_printf("! windowsize(%d,%d) !\n", ap->aobj[0].no, ap->aobj[1].no);
      w = topw + ap->aobj[0].no;
      if (w < 1)
	w = 1;
      h = toph + ap->aobj[1].no;
      if (h < 1)
	h = 1;
      XResizeWindow(dsp, topwin, w, h);
      break;
    case ACT_VIEWPORT:
      debug_printf("! viewport(%d,%d) !\n", ap->aobj[0].no, ap->aobj[1].no);
      scrdx = -ap->aobj[0].no;
      scrdy = -ap->aobj[1].no;
      break;
    case ACT_SHELL:
      debug_printf("! shell(%s) !\n", ap->aobj[0].name);
      if (enable_event_shell)
	bg_shell(ap->aobj[0].name);
      break;
    case ACT_NOTIFY:
      debug_printf("! notify(%s) !\n", ap->aobj[0].name);
      fputs(ap->aobj[0].name, stderr);
      break;
    case ACT_DEBUG:
      debug_printf("! debug(%s) !\n", ap->aobj[0].name);
      fputs(ap->aobj[0].name, stderr);
      break;
    case ACT_QUIT:
      debug_printf("! quit !\n");
      change_menu_func(1);	/* Quit */
      break;
    default:
      break;
    }
    if (mapping_action) {
      /* EVHITWK hit; */
      
      n = ap->aobj[0].no;
      if (ap->aobj[0].type == OT_CEL)
	n = (cell + n)->obj;
      /* move_object_start(&hit, n); */
      if (change_aobj_mapping(evw, &ap->aobj[0], mapping_action)) {
	r |= ACTBIT_MAP;
      }
      /* move_object_end(&hit); */
    }
  }
  if (newset != -1 || newcol != -1)
    change_setpal(newset, newcol);
  return r;
}


int handler_sub(evw, type, arg, arg2)
     EVW *evw;
     int type;
     int arg;
     int arg2;
{
  int i, r, n;
  int f, noredraw;
  EVT *ep;

  debug_printf("event: %s, arg: %d,%d at %.19s.%06ld\n",
	       get_syntax(type)->str, arg, arg2,
	       ctime(&evw->tm0.tv_sec), evw->tm0.tv_usec);
  init_redraw_area(evw);
  r = noredraw = 0;
  for (ep = evtbl, i = 0; i < evn; ep++, i++) {
    if (ep->evtype != type)
      continue;			/* no match, check next */
    n = arg;
#if 0
    /* EMK's changes */
    if (type == EVE_SET || type == EVE_COL)
      noredraw = 1;
#endif
    switch (type) {
    case EVE_INITIALIZE:
      noredraw = 1;
      /* FALL THROUGH */
    case EVE_BEGIN:
    case EVE_END:
      f = 1;
      break;
    case EVE_UNFIX:
      if (arg2) {
	f = (ep->eobj[0].type == OT_OBJ && ep->eobj[0].no == n);
	break;
      }
      /* FALL THROUGH */
    case EVE_PRESS:
    case EVE_RELEASE:
    case EVE_CATCH:
    case EVE_DROP:
    case EVE_FIXCATCH:
    case EVE_FIXDROP:
      if (ep->eobj[0].type == OT_OBJ && n >= 0)
	n = (cell+n)->obj;
      /* FALL THROUGH */
    case EVE_ALARM:
    case EVE_SET:
    case EVE_COL:
      f = (n == ep->eobj[0].no);
      break;
    case EVE_VERSION:
      f = (n >= ep->eobj[0].no);
      break;
    case EVE_COLLIDE:
    case EVE_APART:
    case EVE_IN:
    case EVE_STILLIN:
    case EVE_OUT:
    case EVE_STILLOUT:
      f = (n == ep->eobj[0].no && arg2 == ep->eobj[1].no)
	|| (n == ep->eobj[1].no && arg2 == ep->eobj[0].no);
      break;
    default:			/* others, Not implemented */
      f = 0;
      break;
    }
    if (f)
      r |= event_action(evw, ep, r);
  }
  if (r & ACTBIT_MAP && !noredraw) /* cell mapping status changed? */
    update_redraw_area(evw);
  return r;
}

int kissevent_handler2(type, arg, arg2)
     int type;
     int arg;
     int arg2;
{
  EVW evw;
  
  if (!event_ok)
    return 0;
  current_time(&evw.tm0);
  evw.event_delay = 0;
  return handler_sub(&evw, type, arg, arg2);
}

int kissevent_handler(type, arg)
     int type;
     int arg;
{
  return kissevent_handler2(type, arg, 0);
}

/* initialise random seed */
void init_rand()
{
  int i;
  struct TMV tm0;
  
  i = randseed;
  if (!i) {
    current_time(&tm0);
    i = tm0.tv_sec;
  }
  ks_srand(i);
}

typedef struct {
  long filesize;
  char *pathname;
} SOUND_SORT_TABLE;

int sound_cache_prio(p0, p1)
     SOUND_SORT_TABLE *p0;
     SOUND_SORT_TABLE *p1;
{
  return p0->filesize - p1->filesize;
}

/* preload sound data to cache buffer
 * from small to big size sound file
 */
void preload_sound_cache()
{
  int i;
  SOUND_SORT_TABLE *sstbl, *p;
  long total;
  char *buf;
  
  if (!sound_mode)
    return;
  /* check True sound file name */
  for (i = 0; i < soundn; i++) {
    buf = ks_filename(*(soundlist+i));
    if (buf) {
      free(*(soundlist+i));
      *(soundlist+i) = buf;
    }
  }
  sstbl = (SOUND_SORT_TABLE *)malloc(sizeof(SOUND_SORT_TABLE) * soundn);
  if (sstbl == NULL)
    return;
  for (p = sstbl, i = 0; i < soundn; p++, i++) {
    p->pathname = *(soundlist+i);
    p->filesize = sound_filesize(*(soundlist+i));
  }
  qsort(sstbl, soundn, sizeof(SOUND_SORT_TABLE), sound_cache_prio);
  total = 0;
  for (p = sstbl, i = 0; i < soundn; p++, i++) {
    if (p->filesize < 0)
      continue;			/* unknown size, ignore */
    if (total + p->filesize > sound_cache_limit)
      break;			/* total size over limit! */
    if (sound_cache(p->pathname) >= 0) {
      debug_printf("preload sound file ``%s''\t(%8ld bytes).\n",
		   p->pathname, p->filesize);
      total += p->filesize;
    }
  }
  debug_printf("preloaded sound total %8ld bytes (limit %8ld bytes).\n",
	       total, sound_cache_limit);
  free(sstbl);
}

int kissevent_initialize()
{
  init_rand();
  preload_sound_cache();
  event_ok = True;
  kissevent_handler(EVE_INITIALIZE, 0);
  return 0;
}

void kissevent_timer()
{
  int i, ch;
  EVW evw;
  
  if (!event_ok || !active_timer)
    return;			/* active timer channel is not exist */
  current_time(&evw.tm0);
  for (i = 0; i < active_timer; i++) {
    evw.event_delay = diff_time(&evw.tm0, &(timertbl+i)->alarmtime);
    if (evw.event_delay >= 0) {
      debug_printf("event_delay = %ld\n", evw.event_delay);
      ch = (timertbl+i)->channel;
      /* reset timer */
      delete_timer(ch);
      handler_sub(&evw, EVE_ALARM, ch, 0);
      break;
    }
  }
}

int get_sleep_time()
{
  int i, r;
  long lefttime;
  TIMER *p;
  struct TMV tm0;
  
  r = sleep_tick;
  if (!event_ok || !active_timer)
    return r;			/* active timer channel is not exist */
  current_time(&tm0);
  for (p = timertbl, i = 0; i < active_timer; p++, i++) {
    lefttime = diff_time(&p->alarmtime, &tm0);
    if (lefttime < 0)
      return 0;			/* time over! Don't sleep */
    if (r > lefttime)
      r = lefttime;
  }
  return r;
}

/* End of file */
