/* $Header: /home/yav/catty/fkiss/RCS/menu.c,v 1.28 2000/09/28 07:53:23 yav Exp $
 * fkiss menu bar
 * written by yav <yav@bigfoot.com>
 */

char id_menu[] = "$Id: menu.c,v 1.28 2000/09/28 07:53:23 yav Exp $";

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <stdio.h>
#include "config.h"
#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_MENU_C
#include "extern.h"

#if USE_UNAME
#include <sys/utsname.h>
#endif

#define BASE_XMARGIN 3
#define BASE_YMARGIN 1

#define MNFNC_MAX 3

Window aboutwin;
Window aboutokwin;
static int aboutokw = 32;
static int aboutokh;
static int aboutokstat;
static char str_ok[] = "OK";
static char str_setbase[] = "Set";
static char str_palbase[] = "Col";
static MW *mwfnc;
static int fnccnt;
static MW *mwset;
static MW *mwpal;
static char *fncstr[MNFNC_MAX+1] = {"?", "Quit", "Doc", NULL};
static Window setbasewin;
static Window palbasewin;
#define DEFAULT_MNFNCW 48	/* function menu width default */
static int mnfnch;		/* function menu height */
#define MNFNCBW 1		/* function menu border width */
static int mnbsetw0 = 32;
static int mnbsetw, mnbseth;
#define MNBSETBW 1		/* set menu base border width */
static int mnbpalw0 = 32;
static int mnbpalw, mnbpalh;
#define MNBPALBW 1		/* pal menu base border width */
static int mnsetw = 13;		/* set menu width */
static int mnseth;
#define MNSETBW 0		/* set menu border width */
static int mnpalw = 13;		/* pal menu width */
static int mnpalh;
#define MNPALBW 0		/* pal menu border width */
int infow, infoh;
#define INFOBW 0
static int about_mode = 0;

static char *font_defaults[] = {
  "-adobe-new century schoolbook-medium-r-normal--*-140-*-*-p-*-iso8859-1",
  "-adobe-times-medium-r-normal--*-140-*-*-p-*-iso8859-1",
  "8x16",
  "8x13",
  NULL};
static char *font8_defaults[] = {
  "rk16",			/* 8x16 Alphabet and Kana */
  "8x16",			/* 8x16 Alphabet */
  NULL};
static char *font16_defaults[] = {
  "kanji16",			/* 16x16 Kanji */
  "neckg16",			/* for NEC EWS4800 */
  "k14",			/* 14x14 Kanji */
  NULL};

int calc_text_size(str)
     char *str;
{
  XCharStruct overall;
  int direction_hint;
  
  XTextExtents(fsp, str, strlen(str), &direction_hint,
	       &font_ascent, &font_descent, &overall);
  return overall.rbearing - overall.lbearing;
}

XFontStruct *load_fs(name, list)
     char **name;
     char **list;
{
  XFontStruct *p;
  
  do {
    if (*name != NULL) {
      p = XLoadQueryFont(dsp, *name);
      if (p != NULL)
	return p;
      msg("W font ``%s'' not found.\n", *name);
    }
    *name = *list++;
  } while (*name != NULL);
  return NULL;
}

void load_font_sub(p, name, list, fromgc, ngc)
     XFontStruct **p;
     char **name;
     char **list;
     int fromgc;
     int ngc;
{
  int i;
  
  *p = load_fs(name, list);
  if (*p == NULL) {
    msg("W use CG default font.\n");
  } else {
    for (i = 0; i < ngc; i++)
      XSetFont(dsp, sysgc[fromgc+i], (*p)->fid);
  }
}

void load_font()
{
  load_font_sub(&fsp, &str_font, font_defaults, 0, SGC_MAX);
  if (fsp != NULL)
    calc_text_size("Sample string");
  mnh = font_ascent + font_descent + MNFNCBW*2 + 2 + BASE_YMARGIN*2;
  load_font_sub(&fsp8, &str_font8, font8_defaults, SGC_T8, 1);
  load_font_sub(&fsp16, &str_font16, font16_defaults, SGC_T16, 1);
}

void change_menu_status(win, mode)
     Window win;
     int mode;
{
  XSetWindowBackground(dsp, win, (mode & 2) ? spx[SPX_FG] : spx[SPX_BT]);
  XClearArea(dsp, win, 0, 0, 0, 0, True);
}

void set_menu_window_attributes()
{
  XSetWindowAttributes atr;
  
  XSetWindowBorder(dsp, mnwin, spx[SPX_FG]);
  XSetWindowBackground(dsp, mnwin, spx[SPX_MN]);
  if (spx[SPX_MN] == spx[SPX_BG]) {
    atr.background_pixmap = 
      XCreatePixmapFromBitmapData(dsp, topwin, (char *)hatch_ptrn, 8, 8,
				  spx[SPX_FG], spx[SPX_BG],
				  screen_depth);
    XChangeWindowAttributes(dsp, mnwin, CWBackPixmap, &atr);
    XFreePixmap(dsp, atr.background_pixmap);
  }
  XSetWindowBorder(dsp, aboutwin, spx[SPX_FG]);
  if (iconp != None) {
    atr.background_pixmap =
      XCreatePixmap(dsp, aboutwin, iconw*2, iconh*2, screen_depth);
    XFillRectangle(dsp, atr.background_pixmap, sysgc[SGC_IN1],
		   0, 0, iconw*2, iconh*2);
    XCopyPlane(dsp, iconp, atr.background_pixmap, sysgc[SGC_IN0],
	       0, 0, iconw, iconh, 0, 0, 1);
    XCopyPlane(dsp, iconp, atr.background_pixmap, sysgc[SGC_IN0],
	       0, 0, iconh, iconh, iconw, iconh, 1);
    XChangeWindowAttributes(dsp, aboutwin, CWBackPixmap, &atr);
    XFreePixmap(dsp, atr.background_pixmap);
  }
}

Window create_menuwins(x, y, w, h, b, mask)
     int x;
     int y;
     int w;
     int h;
     int b;
     long mask;
{
  Window win;
  
  win = XCreateSimpleWindow(dsp, mnwin, x, y, w, h, b, spx[SPX_FG], spx[SPX_BT]);
  XSelectInput(dsp, win, mask);
  return win;
}

Window create_button_window(x, y, w, h, b)
     int x;
     int y;
     int w;
     int h;
     int b;
{
  return create_menuwins(x, y, w, h, b,
			 OwnerGrabButtonMask|
			 ExposureMask|ButtonPressMask|ButtonReleaseMask|
			 EnterWindowMask|LeaveWindowMask);
}

int calc_menu_width(str)
     char *str;
{
  int i;
  
  i = calc_text_size(str);
  return i + i/3 + 2;
}

void calc_menu_geometry()
{
  int i, x;
  
  mnfnch = mnh - MNFNCBW*2 - BASE_YMARGIN*2;
  for (i = 0; i < fnccnt; i++) {
    if (fsp != NULL)
      (mwfnc+i)->w = calc_menu_width(fncstr[i]);
    else
      (mwfnc+i)->w = DEFAULT_MNFNCW;
    if ((mwfnc+i)->w < mnfnch)
      (mwfnc+i)->w = mnfnch;
  }
  if (fsp != NULL) {
    aboutokw = calc_menu_width(str_ok);
    mnbsetw0 = calc_menu_width(str_setbase);
    mnbpalw0 = calc_menu_width(str_palbase);
  }
  mnbsetw = mnbsetw0 + (mnsetw + MNSETBW*2)*setcnt;
  mnbseth = mnh - MNBSETBW*2 - BASE_YMARGIN*2;
  mnbpalw = mnbpalw0 + (mnpalw + MNPALBW*2)*palcnt;
  mnbpalh = mnh - MNBPALBW*2 - BASE_YMARGIN*2;
  mnseth = mnbseth - MNSETBW*2;
  mnpalh = mnbseth - MNPALBW*2;
  infoh = mnh - INFOBW*2 - BASE_YMARGIN*2;
  x = BASE_XMARGIN;
  for (i = 0; i < fnccnt; i++)
    x += (mwfnc+i)->w + MNFNCBW*2 + BASE_XMARGIN;
  x += mnbsetw + MNBSETBW*2 + BASE_XMARGIN;
  x += mnbpalw + MNBPALBW*2 + BASE_XMARGIN;
  infow = mnw - (x + INFOBW*2 + BASE_XMARGIN);
  if (infow < 1)
    infow = 1;
}

void menu_resize()
{
  calc_menu_geometry();
  XResizeWindow(dsp, infowin, infow, infoh);
}

MW *alloc_mw(n)
     int n;
{
  int i;
  MW *p;
  
  p = (MW *)ks_malloc(sizeof(MW)*(n+1));
  bzero((char *)p, sizeof(MW)*(n+1));
  for (i = 0; i < n; i++)
    (p+i)->n = i;
  (p+i)->n = -1;		/* End mark */
  return p;
}

void create_set_menu()
{
  int i, x, y;
  XSetWindowAttributes atr;
  
  for (fnccnt = 0; fncstr[fnccnt] != NULL; fnccnt++)
    ;
  mwfnc = alloc_mw(fnccnt);
  calc_menu_geometry();
  x = BASE_XMARGIN;
  y = BASE_YMARGIN;
  for (i = 0; i < fnccnt; i++) {
    (mwfnc+i)->win = create_button_window(x, y, (mwfnc+i)->w, mnfnch, MNFNCBW);
    x += (mwfnc+i)->w + MNFNCBW*2 + BASE_XMARGIN;
  }
  setbasewin = create_menuwins(x, y, mnbsetw, mnbseth, MNBSETBW, ExposureMask);
  mwset = alloc_mw(setcnt);
  for (i = 0; i < setcnt; i++)
    if (active_set[i])
      (mwset+i)->win =
	create_button_window(x + MNBSETBW + mnbsetw0 + (mnsetw+MNSETBW*2)*i,
			     MNBSETBW + y,
			     mnsetw, mnseth, MNSETBW);
  x += mnbsetw + MNBSETBW*2 + BASE_XMARGIN;
  palbasewin = create_menuwins(x, y, mnbpalw, mnbpalh, MNBPALBW, ExposureMask);
  mwpal = alloc_mw(palcnt);
  for (i = 0; i < palcnt; i++)
    (mwpal+i)->win =
      create_button_window(x + MNBPALBW + mnbpalw0 + (mnpalw+MNPALBW*2)*i,
			   MNBPALBW + y,
			   mnpalw, mnpalh, MNPALBW);
  x += mnbpalw + MNBPALBW*2 + BASE_XMARGIN;
  XMapRaised(dsp, mnwin);
  XMapSubwindows(dsp, mnwin);
  infowin = XCreateSimpleWindow(dsp, mnwin, x, y,
				infow, infoh, INFOBW,
				spx[SPX_FG], spx[SPX_MN]);
  XSelectInput(dsp, infowin, ExposureMask);
  /* About ok menu open */
  aboutokh = font_ascent + font_descent + 2;
  aboutokstat = 0;
  aboutokwin = XCreateSimpleWindow(dsp, aboutwin,
				   vieww-(aboutokw+MNFNCBW*2+1),
				   viewh-(aboutokh+MNFNCBW*2+1),
				   aboutokw, aboutokh, MNFNCBW,
				   spx[SPX_FG], spx[SPX_BT]);
  XSelectInput(dsp, aboutokwin,
	       OwnerGrabButtonMask|
	       ExposureMask|ButtonPressMask|ButtonReleaseMask|
	       EnterWindowMask|LeaveWindowMask);
  atr.win_gravity = SouthEastGravity;
  XChangeWindowAttributes(dsp, aboutokwin, CWWinGravity, &atr);
  XMapSubwindows(dsp, aboutwin);
}

int which_winlist(win, p)
     Window win;
     MW *p;
{
  while (p->n >= 0) {
    if (win == p->win)
      break;
    p++;
  }
  return p->n;
}

void draw_menu_string(win, mode, w, h, leftm, topm, str)
     Window win;
     int mode;
     int w;
     int h;
     int leftm;
     int topm;
     char *str;
{
  GC gc;
  
  gc = ((mode & 2) ? sysgc[SGC_BT1] : sysgc[SGC_BT0]);
  XDrawString(dsp, win, gc, leftm, topm + font_ascent, str, strlen(str));
  if (mode & 1)
    XDrawRectangle(dsp, win, gc, 0, 0, w-1, h-1);
}

void draw_button(win, mode, w, h, str)
     Window win;
     int mode;
     int w;
     int h;
     char *str;
{
  int strwidth;
  
  strwidth = calc_text_size(str);
  draw_menu_string(win, mode, w, h,
		   (w - strwidth)/2, (h - (font_ascent+font_descent))/2, str);
}

#define TAB_STOP_WIDTH	8

/* convert tab to spaces */
void expand(dst, src, len)
     unsigned char *dst;	/* destination buffer to store */
     unsigned char *src;	/* source string */
     int len;			/* dst size */
{
  int i, pos;
  
  pos = 0;			/* initial column 0 */
  while (*src) {
    if (len <= 1)
      break;			/* no space to store, abort */
    switch(*src) {
    case '\t':
      i = TAB_STOP_WIDTH - (pos % TAB_STOP_WIDTH);
      while (i--) {
	*dst++ = ' ';
	pos++;
	if (--len <= 1)
	  break;		/* no space to store, abort */
      }
      break;
    case '\033':
      pos -= 3;
      /* FALL THROUGH */
    default:
      *dst++ = *src;
      pos++;
      --len;
      break;
    }      
    src++;
  }
  *dst = '\0';
}

#define FONT8_WIDTH 8
#define FONT16_WIDTH 16

void dup_char2b(dst, src, len)
     XChar2b *dst;
     unsigned char *src;
     int len;
{
  while (len--) {
    dst->byte1 = *src++;
    dst->byte2 = *src++;
    dst++;
  }
}

#define DRAWSTR_MAX 1024

int draw_str16(d, x, y, str, len, kanji)
     Drawable d;		/* target window or pixmap (None:NOT draw) */
     int x, y;			/* position */
     unsigned char *str;	/* drawing string */
     int len;			/* byte count */
     int kanji;			/* kanji flag */
{
  XChar2b buf[DRAWSTR_MAX];
  
  if (kanji) {
    len /= 2;
    if (len > DRAWSTR_MAX)
      len = DRAWSTR_MAX;
    dup_char2b(buf, str, len);
    if (d != None) {
      if (spx[SPX_BG2] == spx[SPX_FG])
	XDrawImageString16(dsp, d, sysgc[SGC_T16], x, y, buf, len);
      else
	XDrawString16(dsp, d, sysgc[SGC_T16], x, y, buf, len);
    }
    len *= FONT16_WIDTH;
  } else {
    if (d != None) {
      if (spx[SPX_BG2] == spx[SPX_FG])
	XDrawImageString(dsp, d, sysgc[SGC_T8], x, y, (char *)str, len);
      else
	XDrawString(dsp, d, sysgc[SGC_T8], x, y, (char *)str, len);
    }
    len *= FONT8_WIDTH;
  }
  return len;			/* string width (pixel) */
}

/* draw ASCII English and Shift-JIS coed Japanese text
 * output to specified drawable
 * but, if None drawable is specified, strings is NOT draw.
 */
int draw_string(d, x, y, str)
     Drawable d;		/* target drawable (None: NOT draw) */
     int x, y;			/* position */
     char *str;			/* drawing string */
{
  unsigned char c, c2;
  unsigned short code;
  Bool inkanji;
  int buffered_count;
  int i, w;
  unsigned char *p;
  unsigned char buf[DRAWSTR_MAX];
  unsigned char buf2[DRAWSTR_MAX];
  
  expand(buf, (unsigned char *)str, sizeof(buf));
  buffered_count = w = 0;
  inkanji = False;
  p = buf;
  while ((c = *p++) != '\0') {
    c2 = *p;
    if (is_sjis_1st(c) && is_sjis_2nd(c2)) {
      if (!inkanji) {
	/* flush ASCII text */
	i = draw_str16(d, x, y, buf2, buffered_count, 0);
	w += i;
	x += i;
	buffered_count = 0;
      }
      code = (c << 8) + c2;
      code = ysjis2jis(code);
      buf2[buffered_count++] = code >> 8;
      buf2[buffered_count++] = code;
      p++;
      inkanji = True;
    } else {
      if (inkanji) {
	/* flush Japanese KANJI text */
	i = draw_str16(d, x, y, buf2, buffered_count, 1);
	w += i;
	x += i;
	buffered_count = 0;
      }
      buf2[buffered_count++] = c;
      inkanji = False;
    }
  }
  if (buffered_count) {
    i = draw_str16(d, x, y, buf2, buffered_count, inkanji);
    w += i;
  }
  return w;			/* string width (pixel) */
}

void draw_data_comment()
{
  int i, y;
  
  y = 0;
  for (i = 0; i < cnf_comment_cnt; i++) {
    y += 16;			/* add font ascent */
    draw_string(aboutwin, 0, y, *(cnf_comment+i));
    y += 0;			/* font descent + line margin */
  }
}

#define ABOUT_LINE_MARGIN 2

void draw_about_line(y, str)
     int *y;
     char *str;
{
  int i, x;
  
  x = (vieww - calc_text_size(str))/2;
  i = strlen(str);
  *y += font_ascent;
  if (spx[SPX_BG2] == spx[SPX_FG])
    XDrawImageString(dsp, aboutwin, sysgc[SGC_GEN], x, *y, str, i);
  else
    XDrawString(dsp, aboutwin, sysgc[SGC_GEN], x, *y, str, i);
  *y += font_descent+ABOUT_LINE_MARGIN;
}

#if USE_UNAME
char *get_client_info()
{
  char buf[1024];
  static char *r = NULL;
  struct utsname kernel_name;
  
  if (r == NULL) {
    uname(&kernel_name);
    sprintf(buf, "Client: %s (%s %s %s)", 
	    kernel_name.nodename,
	    kernel_name.sysname,
	    kernel_name.release,
	    kernel_name.machine);
    r = ks_strdup(buf);
  }
  return r;
}
#else  /* USE_UNAME */
char *pipe_exec(cmd, buf, len)
     char *cmd;
     char *buf;
     int len;
{
  char *p;
  FILE *fp;
  
  p = NULL;
  fp = popen(cmd, "r");
  if (fp != NULL) {
    if (fgets(buf, len, fp) != NULL) {
      cut_crlf(buf);
      p = buf;
    }
    pclose(fp);
  }
  return p;
}

char *get_client_info()
{
  char *p;
  char *s;
  char buf[1024];
  char buf1[256];
  char buf2[256];
  static char *r = NULL;
  static char unknown_name[] = "(unknown)";
  
  if (r == NULL) {
    p = pipe_exec("uname -n", buf1, sizeof(buf1));
    if (p == NULL)
      p = getenv("HOSTNAME");
    if (p == NULL)
      p = getenv("HOST");
    if (p == NULL)
      p = unknown_name;
    s = pipe_exec("uname -smr", buf2, sizeof(buf2));
    if (s == NULL)
      s = getenv("HOSTTYPE");
    if (s == NULL)
      s = unknown_name;
    sprintf(buf, "Client: %s (%s)", p, s);
    r = ks_strdup(buf);
  }
  return r;
}
#endif  /* USE_UNAME */

/* call after display connection is opened! */
char *get_server_info()
{
  char buf[1024];
  static char *r = NULL;
  
  if (r == NULL) {
    sprintf(buf, "Server: %s (%s)", DisplayString(dsp), ServerVendor(dsp));
    r = ks_strdup(buf);
  }
  return r;
}

char *get_visual_info()
{
  int i;
  char *p;
  char buf[1024];
  static char *r = NULL;
  static struct {
    int class;
    char *name;
  } vistbl[] = {
    {StaticGray,	"StaticGray"},
    {GrayScale,		"GrayScale"},
    {StaticColor,	"StaticColor"},
    {PseudoColor,	"PseudoColor"},
    {TrueColor,		"TrueColor"},
    {DirectColor,	"DirectColor"},
    {-1,		NULL}
  };
  
  if (r == NULL) {
    p = "(unknown)";
    for (i = 0; vistbl[i].name != NULL; i++) {
      if (vis->class == vistbl[i].class) {
	p = vistbl[i].name;
	break;
      }
    }
    if (vis->class == TrueColor || vis->class == DirectColor) {
      sprintf(buf, "Visual: %s (depth %d, R:%08lx, G:%08lx, B:%08lx)",
	      p, screen_depth,
	      vis->red_mask, vis->green_mask, vis->blue_mask);
    } else {
      sprintf(buf, "Visual: %s (depth %d)", p, screen_depth);
    }
    r = ks_strdup(buf);
  }
  return r;
}

/* call after read_cells */
char *get_cell_info()
{
  char buf[1024];
  static char *r = NULL;
  
  if (r == NULL) {
    sprintf(buf, "Total %d cells, %d objects, %d marks",
	    celcnt, objcnt2, objcnt);
    r = ks_strdup(buf);
  }
  return r;
}

void draw_aboutwin()
{
  int i, y;
  char buf[1024];
  
  if (about_mode == 1) {
    draw_data_comment();
    return;
  }
  y = (viewh - ((font_ascent + font_descent + ABOUT_LINE_MARGIN) * (12+arcfilecnt)))/3;
  draw_about_line(&y, str_fullname);
  sprintf(buf, "Version %s", str_version);
  draw_about_line(&y, buf);
  sprintf(buf, "written by %s", str_author);
  draw_about_line(&y, buf);
  draw_about_line(&y, get_client_info());
  draw_about_line(&y, get_server_info());
  draw_about_line(&y, get_visual_info());
  draw_about_line(&y, "");
  for (i = 0; i < arcfilecnt; i++) {
    sprintf(buf, "Archive %d: %s", i+1, *(arcfilelist+i));
    draw_about_line(&y, buf);
  }
  sprintf(buf, "Configuration file: %s", conf_file);
  draw_about_line(&y, buf);
  sprintf(buf, "Size: %dx%d (%dx%d)", imgw, imgh, imgw0, imgh0);
  draw_about_line(&y, buf);
  sprintf(buf, "View port: %dx%d%+d%+d",
	  vieww, viewh, -imgx-imgbw, -imgy-imgbw);
  draw_about_line(&y, buf);
  draw_about_line(&y, get_cell_info());
  sprintf(buf, "Motion compress: %d", motion_compress);
  draw_about_line(&y, buf);
  sprintf(buf, "%s%s", infostr0, infostr);
  draw_about_line(&y, buf);
}

void change_menu_func(i)
     int i;
{
  int s;
  
  s = (mwfnc+i)->st;
  switch(i) {
  case 0:			/* About */
    if (++about_mode > 2)
      about_mode = 0;
    if (about_mode) {
      XMapRaised(dsp, aboutwin);
      XClearArea(dsp, aboutwin, 0, 0, 0, 0, True);
      s |= 2;
    } else {
      XUnmapWindow(dsp, aboutwin);
      s &= ~2;
    }
    break;
  case 1:			/* Quit */
    s ^= 2;
    quit_flag = !quit_flag;
    break;
  case 2:			/* Doc */
    /* Quick and darty hack! Not smart, Sorry */
    s |= 2;
    change_menu_status((mwfnc+i)->win, (mwfnc+i)->st = s);
    browse_document();
    s = 0;
    break;
  }
  change_menu_status((mwfnc+i)->win, (mwfnc+i)->st = s);
}

void expose_menu(p)
     XExposeEvent *p;
{
  int i;
  Window win;
  char buf[16];
  
  if (p->count)
    return;
  win = p->window;
  if (win == aboutwin) {
    draw_aboutwin();
  } else if (win == aboutokwin) {
    draw_button(win, aboutokstat, aboutokw, aboutokh, str_ok);
  } else if (win == infowin) {
    draw_button(win, 0, infow, infoh, infostr);
  } else if (win == setbasewin) {
    draw_button(win, 0, mnbsetw0, mnbseth, str_setbase);
  } else if (win == palbasewin) {
    draw_button(win, 0, mnbpalw0, mnbpalh, str_palbase);
  } else {
    i = which_winlist(win, mwfnc);
    if (i >= 0)
      draw_button((mwfnc+i)->win, (mwfnc+i)->st, (mwfnc+i)->w, mnfnch, fncstr[i]);
    i = which_winlist(win, mwset);
    if (i >= 0) {
      sprintf(buf, "%d", i);
      draw_button(win, (mwset+i)->st | (i == cset ? 2 : 0),
		  mnsetw, mnseth, buf);
    }
    i = which_winlist(win, mwpal);
    if (i >= 0) {
      sprintf(buf, "%d", i);
      draw_button(win, (mwpal+i)->st | (i == cpal ? 2 : 0),
		  mnpalw, mnpalh, buf);
    }
  }
}

/* Press or Release mouse buttons */
void press_menu(p)
     XButtonEvent *p;
{
  int i;
  Window win;
  
  win = p->window;
  if (win == aboutokwin) {
    if (p->type == ButtonRelease && (aboutokstat & 1)) {
      change_menu_func(0);
    }
  }
  i = which_winlist(win, mwfnc);
  switch (i) {
  case 0:
  case 1:
    if (p->type == ButtonRelease)
      change_menu_func(i);
    break;
  case 2:
    if (p->type == ButtonPress)
      change_menu_func(i);
    break;
  }
  if (p->type == ButtonRelease) {
    i = which_winlist(win, mwset);
    if (i >= 0)
      change_setpal(i, -1);
    i = which_winlist(win, mwpal);
    if (i >= 0)
      change_setpal(-1, i);
  }
}

int enter_mw(win, p)
     Window win;
     MW *p;
{
  int i;
  
  i = which_winlist(win, p);
  if (i >= 0)
    change_menu_status(win, (p+i)->st |= 1);
  return i;
}

void enter_menu(p)
     XCrossingEvent *p;
{
  Window win;
  
  win = p->window;
  if (win == aboutokwin)
    change_menu_status(win, aboutokstat |= 1);
  enter_mw(win, mwfnc);
  enter_mw(win, mwset);
  enter_mw(win, mwpal);
}

int leave_mw(win, p)
     Window win;
     MW *p;
{
  int i;
  
  i = which_winlist(win, p);
  if (i >= 0)
    change_menu_status(win, (p+i)->st &= ~1);
  return i;
}

void leave_menu(p)
     XCrossingEvent *p;
{
  Window win;
  
  win = p->window;
  if (win == aboutokwin)
    change_menu_status(win, aboutokstat &= ~1);
  leave_mw(win, mwfnc);
  leave_mw(win, mwset);
  leave_mw(win, mwpal);
}

void menu_setpal_change()
{
  int i;
  
  for (i = 0; i < setcnt; i++) {
    if (active_set[i]) {
      if (i == cset) {
	change_menu_status((mwset+i)->win, (mwset+i)->st |= 2);
      } else {
	if ((mwset+i)->st & 2)
	  change_menu_status((mwset+i)->win, (mwset+i)->st &= ~2);
      }
    }
  }
  for (i = 0; i < palcnt; i++) {
    if (i == cpal) {
      change_menu_status((mwpal+i)->win, (mwpal+i)->st |= 2);
    } else {
      if ((mwpal+i)->st & 2)
	change_menu_status((mwpal+i)->win, (mwpal+i)->st &= ~2);
    }
  }
}

/* End of file */
