/* $Header: /home/yav/catty/fkiss/RCS/message.c,v 1.4 2000/09/02 07:57:33 yav Exp $
 * fkiss message
 * written by yav <yav@bigfoot.com>
 */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_MESSAGE_C
#include "extern.h"

char id_message[] = "$Id: message.c,v 1.4 2000/09/02 07:57:33 yav Exp $";
static char *msgbuf;
static char *msgp;

#define CLEAR_MESSAGE() (*(msgp = msgbuf) = '\0')

void msg_init(p)
     char *p;
{
  msgbuf = p;
  CLEAR_MESSAGE();
}

int msg_queued()
{
  return msgp - msgbuf;
}

void prmsg()
{
  Bool f;
  char *p;
  char *prompt;
  
  f = False;
  p = NULL;
  prompt = *oargv;
  switch(*msgbuf) {
  case '\0':
    break;
  case 'V':
    if (verbose_mode & 2) {
      prompt = NULL;
      p = "";
    }
    break;
  case 'W':
    if (verbose_mode)
      p = " warning:";
    break;
  case 'E':
    f = True;
    p = " error:";
    break;
  default:
    p = "";
    break;
  }
  if (p != NULL) {
    if (prompt != NULL)
      fprintf(stderr, "%s:", prompt);
    fprintf(stderr, "%s%s", p, msgbuf+1);
  }
  CLEAR_MESSAGE();
  if (f)
    kiss_exit(1);
}

#if USE_STDARG
void msgset(const char *format, ...)
{
  va_list ap;
  
  va_start(ap, format);
  vsprintf(msgp, format, ap);
  msgp += strlen(msgp);
  va_end(ap);
}
#else /* USE_STDARG */
# if USE_VARARGS
void msgset(va_alist)
     va_dcl
{
  va_list ap;
  char *format;
  
  va_start(ap);
  format = va_arg(ap, char *);
  vsprintf(msgp, format, ap);
  msgp += strlen(msgp);
  va_end(ap);
}
# else /* USE_VARARGS */
void msgset(format)
     char *format;
{
  char *ap;
  
  ap = (char *)&format + sizeof(char *);
  vsprintf(msgp, format, ap);
}
# endif /* USE_VARARGS */
#endif /* USE_STDARG */

#if USE_STDARG
void msg(const char *format, ...)
{
  va_list ap;
  
  va_start(ap, format);
  vsprintf(msgp, format, ap);
  prmsg();
  va_end(ap);
}
#else /* USE_STDARG */
# if USE_VARARGS
void msg(va_alist)
     va_dcl
{
  va_list ap;
  char *format;
  
  va_start(ap);
  format = va_arg(ap, char *);
  vsprintf(msgp, format, ap);
  prmsg();
  va_end(ap);
}
# else /* USE_VARARGS */
void msg(format)
     char *format;
{
  char *ap;
  
  ap = (char *)&format + sizeof(char *);
  vsprintf(msgp, format, ap);
  prmsg();
}
# endif /* USE_VARARGS */
#endif /* USE_STDARG */


#if USE_STDARG
void debug_printf(const char *format, ...)
{
  va_list ap;
  
  if (debug_mode) {
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
}
#else /* USE_STDARG */
# if USE_VARARGS
void debug_printf(va_alist)
     va_dcl
{
  va_list ap;
  char *format;
  
  if (debug_mode) {
    va_start(ap);
    format = va_arg(ap, char *);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
}
# else /* USE_VARARGS */
void debug_printf(format)
     char *format;
{
  char *ap;
  
  if (debug_mode) {
    ap = (char *)&format + sizeof(char *);
    vfprintf(stderr, format, ap);
  }
}
# endif /* USE_VARARGS */
#endif /* USE_STDARG */

/* End of file */
