/* $Header: /home/yav/catty/fkiss/RCS/sub.c,v 1.13 2000/09/02 03:26:22 yav Exp $
 * fkiss subroutines
 * written by yav <yav@bigfoot.com>
 */

char id_sub[] = "$Id: sub.c,v 1.13 2000/09/02 03:26:22 yav Exp $";

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_SUB_C
#include "extern.h"

int ks_system2(str)
     char *str;
{
  if (debug_mode)
    fprintf(stderr, "system(%s)\n", str);
  return system(str);
}

void kiss_exit(code)
     int code;
{
  char *buf;
  
  /* clean up extracted files */
  if (extract_dir != NULL) {
    buf = ks_malloc(strlen(extract_dir) + 16);
    sprintf(buf, "rm -rf %s &", extract_dir);
    ks_system2(buf);
    free(buf);
  }
  if (dsp != NULL)
    XCloseDisplay(dsp);
  exit(code);
}

void ks_system(str)
     char *str;
{
  if (ks_system2(str))
    msg("E cannot exec ``%s''\n", str);
}

void memory_error()
{
  msg("E More core!\n");
  /* NOT REACHED */
}

char *ks_malloc(n)
     int n;
{
  char *p;
  
  p = malloc(n);
  if (p == NULL)
    memory_error();
  return p;
}

char *ks_realloc(p, n)
     char *p;
     int n;
{
  p = realloc(p, n);
  if (p == NULL)
    memory_error();
  return p;
}

char *ks_strdup(str)
     char *str;
{
  char *p;
  
#if HAVE_STRDUP
  p = strdup(str);
  if (p == NULL)
    memory_error();
#else
  int len;
  
  len = strlen(str) + 1;	/* +1 for terminator '\0' */
  p = ks_malloc(len);
  bcopy(str, p, len);
#endif
  return p;
}

char *get_directory(path)
     char *path;
{
  char *p;
  char *buf;
  
  buf = ks_strdup(path);
  p = rindex(buf, '/');
  if (p == NULL)
    p = buf;
  *p = '\0';
  return buf;
}

char *get_filename(path)
     char *path;
{
  char *p;
  
  p = rindex(path, '/');
  return (p != NULL) ? p + 1 : path;
}

/* for ASCII character set only */
void strlower(str)
     char *str;
{
  int c;
  
  while ((c = *str) != '\0')
    *str++ = to_lower(c);
}

char *dos_filename(src)
     char *src;
{
  char *p;
  char *dst;

  src = get_filename(src);
  /* cut DOS 8+3 style file name */
  dst = ks_strdup(src);
  p = rindex(dst, '.');
  if (p == NULL) {
    if (strlen(dst) > 8)
      *(dst+8) = '\0';
  } else {
    if (strlen(p) > 4)
      *(p+4) = '\0';
    if (p - dst > 8)
      strcpy(dst+8, p);
  }
  strlower(dst);
  return dst;
}

char *dos_pathname(src)
     char *src;
{
  char *p, *p1;
  char *dst;

  dst = ks_strdup(src);
  p = get_filename(dst);
  p1 = dos_filename(p);
  strcpy(p, p1);
  free(p1);
  return dst;
}

int strcmp_dos_filename(dst, src)
     char *dst;
     char *src;
{
  int r;
  char *buf1;
  char *buf2;
  
  buf1 = dos_filename(dst);
  buf2 = dos_filename(src);
  r = strcmp(buf1, buf2);
  free(buf1);
  free(buf2);
  return r;
}

int is_suffix(name, suffix)
     char *name;
     char *suffix;
{
  int i;
  char *buf;
  
  i = strlen(name) - strlen(suffix);
  if (i < 0)
    return 0;
  buf = ks_strdup(name+i);
  strlower(buf);
  i = (strcmp(buf, suffix) == 0);
  free(buf);
  return i;
}

void cut_crlf(p)
     char *p;
{
  int i;
  
  i = strlen(p);
  if (i && *(p+i-1) == '\n') {
    --i;
    if (i && *(p+i-1) == '\r') /* MS-DOS CR */
      --i;
    *(p+i) = '\0';
  }
}

void ks_srand(seed)
     unsigned seed;
{
  srand(seed);
}

int ks_rand()
{
  return rand();
}

#define STREXTSIZE 64
void lstr_init(p)
     LSTR *p;
{
  p->len = STREXTSIZE;
  p->buf = ks_malloc(p->len);
  p->n = 0;
  p->buf[0] = '\0';
}

void lstr_ch(p, c)
     LSTR *p;
     int c;
{
  p->buf[p->n++] = c;
  if (p->n >= p->len) {
    p->len += STREXTSIZE;
    p->buf = ks_realloc(p->buf, p->len);
  }
  p->buf[p->n] = '\0';
}

void lstr_bs(p)
     LSTR *p;
{
  if (p->n)
    p->buf[--(p->n)] = '\0';
}

void lstr_cat(p, str)
     LSTR *p;
     char *str;			/* must be longer than or equal 1 character */
{
  int c;
  
  while ((c = *str++) != '\0')
    lstr_ch(p, c);
}

/* End of file */
