// =============================================================================
//	L
// =============================================================================

#include "extern.h"

// RXgN^
Charct::Charct()
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		CharctArray[i] = NULL;
	}
}

// fXgN^
Charct::~Charct()
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		Release(i);
	}
}

// 
void	Charct::Init( void )
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		Release(i);
	}
}

// 쐬
void	Charct::Create( int x, int y, int num, int eff )
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		if( CharctArray[i] == NULL )
		{
			CharctArray[i] = (CharctPtr)malloc( sizeof(CharctRec) );
			ZeroMemory( CharctArray[i], sizeof(CharctRec) );

			CharctArray[i]->pos.x = x;
			CharctArray[i]->pos.y = y;
			CharctArray[i]->eff   = eff;
			CharctArray[i]->cnt   = 0;
			CharctArray[i]->wait  = 0.0f;

			switch( num ){
			case 1:
				CharctArray[i]->num = num;
				strcpy( CharctArray[i]->fname, "bmp\\ch01.bmp" );
				CharctArray[i]->srf.lpSrf = DD_ColKeyLoadBitmap( "bmp\\ch01.bmp", RGB(255, 0, 255) );
				break;
			default:
				break;
			}
			break;
		}
	}
}

// T[tFXč쐬
void	Charct::Restore()
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		if( CharctArray[i] != NULL )
		{
			RELEASE( CharctArray[i]->srf.lpSrf );
			CharctArray[i]->srf.lpSrf = DD_ColKeyLoadBitmap( CharctArray[i]->fname, RGB(255, 0, 255) );
		}
	}
}

// 폜
void	Charct::Release( int idx )
{
	if( CharctArray[idx] == NULL )	return;

	RELEASE( CharctArray[idx]->srf.lpSrf );
	free( CharctArray[idx] );
	CharctArray[idx] = NULL;
}

// `
void	Charct::Draw( void )
{
	for( i = 0; i < CHARCT_MAX; i++ )
	{
		if( CharctArray[i] == NULL )	continue;

		switch( CharctArray[i]->eff ){
		case  0:	// ʂɕ\
			DD_DrawBitmap(	CharctArray[i]->pos.x,
							CharctArray[i]->pos.y,
							CharctArray[i]->srf.lpSrf,
							0,
							0,
							CHARCT_WIDTH,
							CHARCT_HEIGHT );
			break;

		case  1:	// GtFNg\i؂\EEj
			for( j = 0; j < 32; j++ )
			{
				DD_DrawBitmap(	CharctArray[i]->pos.x + j * 10,
								CharctArray[i]->pos.y,
								CharctArray[i]->srf.lpSrf,
								j * 10,
								0,
								j * 10 + CharctArray[i]->cnt,
								CHARCT_HEIGHT );
			}
			CharctArray[i]->wait += FrameTime;
			if( CharctArray[i]->wait > 0.005f )	// \EGCg
			{
				CharctArray[i]->wait = 0.0f;
				if( ++CharctArray[i]->cnt >= 10 )
				{	// GtFNg\I
					CharctArray[i]->eff = 0;
				}
			}
			break;

		case  2:	// GtFNg\i؂\Eとj
			for( j = 0; j < 48; j++ )
			{
				DD_DrawBitmap(	CharctArray[i]->pos.x,
								CharctArray[i]->pos.y + j * 10,
								CharctArray[i]->srf.lpSrf,
								0,
								j * 10,
								CHARCT_WIDTH,
								j * 10 + CharctArray[i]->cnt );
			}
			CharctArray[i]->wait += FrameTime;
			if( CharctArray[i]->wait > 0.005f )	// \EGCg
			{
				CharctArray[i]->wait = 0.0f;
				if( ++CharctArray[i]->cnt >= 10 )
				{	// GtFNg\I
					CharctArray[i]->eff = 0;
				}
			}
			break;

		default:
			break;
		}
	}
}


