/*----------------------------------------------------------

	DirectX 7
		Direct3DX Sample

--------------------------------------------------------------*/

#include "extern.h"


/*-------------------------------------------
	G[óifobÔ݁j
--------------------------------------------*/
#if _DEBUG
void	InterpretError(HRESULT hr)
{
	char errStr[100];
	D3DXGetErrorString(hr, 100, errStr );
	OutputDebugString(errStr);
	OutputDebugString("\r\n");
}
#else
void	InterpretError(HRESULT /*hr*/)
{
}
#endif

/*-------------------------------------------
	AvP[ViŏɈxĂ΂j
--------------------------------------------*/
bool	InitApp( HINSTANCE hInst,int nCmdShow )
{
	char		szAppName[] = "DirectD3DX Sample";
	WNDCLASS	wndclass;

	hInstApp = hInst;

	// EBhENX̓o^
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= NULL;
//	wndclass.hIcon			= (HICON)MAKEINTRESOURCE(IDI_MAIN);
	wndclass.lpszMenuName	= NULL;
//	wndclass.lpszMenuName   = MAKEINTRESOURCE(IDR_MAINMENU);
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if( !RegisterClass(&wndclass) )	return false;

	if( WindouMode == FULLSCR_MODE )
	{

		// tXN[
		hwndApp = CreateWindowEx( 0, szAppName, szAppName,
								WS_POPUP,
//								WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,
								0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
								(HWND)NULL, (HMENU)NULL,
								hInst, (LPSTR)NULL );

		ShowCursor( FALSE );

	}else{

		// EChE
		hwndApp = CreateWindowEx( 0, szAppName, szAppName,
								WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,
								CW_USEDEFAULT, CW_USEDEFAULT, SCREEN_WIDTH, SCREEN_HEIGHT,
								(HWND)NULL, (HMENU)NULL,
								hInst, (LPSTR)NULL );

		ShowCursor( TRUE );
	}

	ShowWindow( hwndApp, nCmdShow );
	UpdateWindow( hwndApp );

	// Direct3DX̏
	HRESULT	hr = D3DXInitialize();

	if( FAILED(hr) ){
		// Ɏs
		InterpretError(hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	Direct3DX ifoCX𑜓xύXƂĂ΂j
--------------------------------------------*/
bool	InitD3DX( void )
{
	HRESULT hr;

	hr = D3DXCreateContextEx( D3DX_DEFAULT, // D3DX Device܂̓n[hEFAx
							WindouMode == FULLSCR_MODE ? D3DX_CONTEXT_FULLSCREEN : 0,	// XN[[h
							hwndApp,		// EChE
							WindouMode == FULLSCR_MODE ? hwndApp : NULL,				// EChE
							D3DX_DEFAULT,	// rbg[xiFj
							D3DX_DEFAULT,	// rbg[xiAt@E`lj
							D3DX_DEFAULT,	// rbg[xi[xobt@j
							D3DX_DEFAULT,	// rbg[xiXeVEobt@j
							D3DX_DEFAULT,	// obNobt@
							SCREEN_WIDTH,	// 
							SCREEN_HEIGHT,	// 
							D3DX_DEFAULT,	// tbV[g
							&m_pD3DX );

	if( FAILED(hr) ){	// Ɏs
		InterpretError(hr);
		return false;
	}

	// DirectDraw,Direct3DIuWFNg擾
	if( ( m_pD3DDev = m_pD3DX->GetD3DDevice()  ) == NULL )	return false;
	if( ( m_pDD     = m_pD3DX->GetDD()         ) == NULL )	return false;
	if( ( m_pDDBack = m_pD3DX->GetBackBuffer(0)) == NULL )	return false;
	if( ( m_pDDPrim = m_pD3DX->GetPrimary()    ) == NULL )	return false;

	// ̎_ŁCDirectDraw,Direct3DIuWFNg͂Ɏg܂

	// fBUOL
	hr = m_pD3DDev->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );

	// |S\Ƃ`悷
	hr = m_pD3DDev->SetRenderState( D3DRENDERSTATE_CULLMODE, D3DCULL_NONE );

	// CeBO
	hr = m_pD3DDev->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );

	// `ʂNAƂ̐Fݒ
	hr = m_pD3DX->SetClearColor( D3DRGBA( 0, 0, 0, 0 ) );


	return true;
}

/*-------------------------------------------
	T[tFCXie𕜌ƂĂ΂j
--------------------------------------------*/
bool	InitSurface(void)
{
	InitGameSurface();

	return true;
}

/*-------------------------------------------
	AvP[V̓ꎞ~
--------------------------------------------*/
void	PauseDrawing()
{
	// AvP[V̓tOfalseɂ
	m_bActive = false;

	// GDIT[tFCX\
	if( m_pDD )		m_pDD->FlipToGDISurface();

	// EChẼj[o[`悷
	DrawMenuBar(hwndApp);

	// EChẼt[`悷
	RedrawWindow(hwndApp, NULL, NULL, RDW_FRAME);

	// }EXJ[\\
//	while (ShowCursor(TRUE)<0) {};
}

/*-------------------------------------------
	~ĂAvP[V̓ĊJ
--------------------------------------------*/
void	RestartDrawing()
{
	// AvP[V̓tOtrueɂ
	m_bActive = true;

	// }EXJ[\
//	while (ShowCursor(FALSE)>=0) {};
}

/*-------------------------------------------
	T[tFCX̊JiT[tFCX쐬ɎsĂꍇĂ΂j
--------------------------------------------*/
bool	ReleaseSurface(void)
{
	ReleaseGameSurface();

	return true;
}

/*-------------------------------------------
	Direct3DX̏IiDirect3DX̏ɎsĂꍇĂ΂j
--------------------------------------------*/
bool	ReleaseD3DX(void)
{
	// 擾IuWFNg̊J
	RELEASE( m_pDDPrim );
	RELEASE( m_pDDBack );
	RELEASE( m_pDD     );
	RELEASE( m_pD3DDev );
	RELEASE( m_pD3DX   );

	return true;
}

/*-------------------------------------------
	AvP[V̏IiŌɈxĂ΂j
--------------------------------------------*/
bool	EndApp(void)
{
	HRESULT hr;

	hr = D3DXUninitialize();	// Direct3DX̏I

	if( FAILED(hr) ){
		// IɎs
		InterpretError(hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	XN[[hωƂ̏
--------------------------------------------*/
bool	RestoreSurface()
{
	HRESULT hr;

	// fBXvC̋x𒲍
	hr = m_pDD->TestCooperativeLevel();

	// AvP[V͔r[hɐݒ肳Ă邪Cۂɂ͔r[hĂȂꍇ
	if( hr == DDERR_NOEXCLUSIVEMODE )
	{
		// r[h߂܂ŁiőUbj[vD
		int count=0;
		do{
			Sleep(500);	// 0.5b҂
			count += 500;
			hr = m_pDD->TestCooperativeLevel();
		} while (DDERR_NOEXCLUSIVEMODE == hr && (count < 6000));
	}

	if( hr == DDERR_WRONGMODE )
	{
		// fBXvC[hύXĂ̂ŁC蒼Kv܂D
		if( !ReleaseSurface() )	return false;
		if( !ReleaseD3DX()    )	return false;
		if( !InitD3DX()       )	return false;
		hr = S_OK;
	}

	// xɖȂꍇ
	if( SUCCEEDED(hr) )
	{
		// ׂẴT[tFCXXgA
		hr = m_pDD->RestoreAllSurfaces();
		if( SUCCEEDED(hr) )
		{
			// ŁCT[tFCX̓e𕜌D
			if( InitSurface() )	// iAvP[VŒ`֐j
				return true;	// ɏI
		}
	}

	// G[
	InterpretError(hr);
	return false;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, UINT wParam, LONG lParam )
{
	switch( msg ){
	case WM_ACTIVATEAPP:
		// AvP[V̏Ԃɍ킹ē𐧌䂷
		if( (BOOL)wParam )	RestartDrawing();
		else				PauseDrawing();
		break;

	case WM_LBUTTONDOWN:	// }EXNbNCxg
	case WM_RBUTTONDOWN:
	case WM_MOUSEMOVE:		// }EXW擾
		Mouse_Proc( hWnd, msg, wParam, lParam );
		break;

	case WM_KEYDOWN:		// L[_ECxg
		KeyDown_Proc( hWnd, wParam );
		break;

//	case WM_ENTERMENULOOP:	// j[Iꂽ瓮~
//		PauseDrawing();
//		break;

	case WM_EXITMENULOOP:	// j[̑Iꂽ瓮ĊJ
		RestartDrawing();
		break;

	case WM_COMMAND:		// Iꂽj[s
		if( 0 == HIWORD(wParam) ){
			switch( LOWORD(wParam) ){
			case IDM_EXIT:
				DestroyWindow(hWnd);
				return 0;

			}
		}
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	default:
		return DefWindowProc(hWnd,msg,wParam,lParam);
	}
	return 0L;
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool	AppIdle(void)
{
	bool	flag;

	/*---------------------------------
		ɕ`̏܂D
	----------------------------------*/

	flag = DrawMainScreen();	// `揈

	return( flag );
}

/*--------------------------------------------
	C
---------------------------------------------*/
int		WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	bool	flag;

				flag = InitApp( hInst,nCmdShow );	// AvP[VɊւ鏉
	if( flag )	flag = InitD3DX();					// Direct3DXɊւ鏉
	if( flag )	flag = InitSurface();				// T[tFCXɊւ鏉

	Save_time = GetTickCount();	// t[^C̏

	////////////////////////// bZ[W[v //////////////////////////
	MSG		msg;
	msg.wParam = 0;

	static	float	FrameCount = 0.0f;

	while( flag ){

		if( PeekMessage(&msg,0,0,0,PM_REMOVE) ){	// bZ[Wꍇ

			if( msg.message == WM_QUIT )	break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);

		}else if( m_bActive ){

			// t[^C̍XV
			FrameTime = (float)( GetTickCount() - Save_time ) / 1000.0f;
			Save_time = GetTickCount();

			// t[^C̃JEg
			FrameCount += FrameTime;
			if( FrameCount > 0.016 ){	// 60FPSŒi1/60b==16mbj
				FrameCount = 0.0f;
				if( !AppIdle() ){		// AChiʕ`j
					// G[ꍇCAvP[VI
					PostQuitMessage(0);
				}
			}

		}else{

			WaitMessage();
		}
	}

	ReleaseSurface();	// T[tFCXJ
	ReleaseD3DX();		// Direct3DX̏I
	EndApp();			// AvP[V̏I

	return msg.wParam;
}


// EChE[h̐؂ւ
void	ChangeWindowMode( void )
{
	WindouMode = ( WindouMode == FULLSCR_MODE ? WINDOW_MODE: FULLSCR_MODE );

	ReleaseSurface();	// T[tFCXJ
	ReleaseD3DX();		// Direct3DX̏I

/***
	if (!m_bWindowed) {
		//tXN[֕ύX
		dwStyle = GetWindowLong( m_hwnd, GWL_STYLE );
		GetWindowRect( m_hwnd, &rcWindow );
		SetWindowLong( m_hwnd, GWL_STYLE, WS_POPUP|WS_SYSMENU|WS_VISIBLE );
	} else if (dwStyle != 0) {
		//EBhE𕜋A
		SetWindowLong( m_hwnd, GWL_STYLE, dwStyle );
		SetWindowPos( m_hwnd, HWND_NOTOPMOST, rcWindow.left, rcWindow.top,
					  ( rcWindow.right - rcWindow.left ), 
					  ( rcWindow.bottom - rcWindow.top ), SWP_SHOWWINDOW );
		//EBhEԂőČĂяoĂAEBhETCYύXȂ
		dwStyle = 0;
	}
***/

	if( WindouMode == FULLSCR_MODE )	// tXN[
	{
		ShowCursor( FALSE );
	}else{
		ShowCursor( TRUE );
	}

	InitD3DX();			// Direct3DXɊւ鏉
	RestoreSurface();
}
