// =============================================================================
//  JNX
// =============================================================================

#include "extern.h"
#include "rain.h"

// RXgN^
Rain::Rain()
{
	for( i = 0; i < RAIN_MAX; i++ )
	{
		RainArray[i] = NULL;
	}
	RainTex = NULL;
}

// fXgN^
Rain::~Rain()
{
	for( i = 0; i < RAIN_MAX; i++ )
	{
		Release(i);
	}
	RELEASE(RainTex);
}

// 
void	Rain::Init( void )
{
	if( RainTex != NULL )	RELEASE(RainTex);
	RainTex = DD_CreatTexture( "bmp\\rain.bmp", 20, 150  );

	for( i = 0; i < RAIN_MAX; i++ )
	{
		Release(i);
	}
}

// 쐬
void	Rain::Create( int num )
{
	for( i = 0; i < RAIN_MAX; i++ )
	{
		if( RainArray[i] == NULL )
		{
			RainArray[i] = (RainPtr)malloc( sizeof(RainRec) );
			ZeroMemory( RainArray[i], sizeof(RainRec) );

			RainArray[i]->pos.x = MyRand(  0, 640 );
			RainArray[i]->pos.y = 0;
			RainArray[i]->num   = MyRand(  0,   9 );
			RainArray[i]->speed = MyRand( 10, 100 );
			if( --num <= 0 )	break;
		}
	}
}

// T[tFXč쐬
void	Rain::Restore()
{
	if( RainTex != NULL )	RELEASE(RainTex);
	RainTex = DD_CreatTexture( "bmp\\rain.bmp", 20, 150  );
}

// 폜
void	Rain::Release( int idx )
{
	if( RainArray[idx] == NULL )	return;
	free( RainArray[idx] );
	RainArray[idx] = NULL;
}

// `
void	Rain::Draw( void )
{
	for( i = 0; i < RAIN_MAX; i++ )
	{
		if( RainArray[i] == NULL )	continue;

		RECT			srcRect = { 0, 0, 1, 150 };	// XvCg̃eNX`̗̈
		D3DXVECTOR3		pointDest;
		D3DVIEWPORT7	viewport;	// r[|[gɂĂ̏

		m_pD3DDev->GetViewport( &viewport );
		pointDest.x = (float)viewport.dwX + RainArray[i]->pos.x;
		pointDest.y = (float)viewport.dwY + RainArray[i]->pos.y;
		pointDest.z = 0.0f;

		D3DXDrawSpriteSimple(
			RainTex,
			m_pD3DDev,	// Direct3DDeviceIuWFNg
			&pointDest,	// XvCg̕\ʒu
			0.8f,		// At@l
			1.0f,		// XP[igkj
			0.0f,		// ]p
			NULL,		// ItZbgl
			&srcRect );	// \XvCg̃eNX`̗̈
	}
}

// ړʂ̌vZ
void	Rain::Move( void )
{
	for( i = 0; i < RAIN_MAX; i++ )
	{
		if( RainArray[i] == NULL )	continue;

		RainArray[i]->pos.y += RainArray[i]->speed;
		// ʊOɏo폜
		if( RainArray[i]->pos.y > SCREEN_HEIGHT )	Release(i);
	}
}

