using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Text;

namespace TimeStamper
{
	/// <summary>
	/// ViewForm ̊Tv̐łB
	/// </summary>
	public class ViewForm : System.Windows.Forms.Form
	{
		/// <summary>Ώۂ̃ACe</summary>
		private	ListViewItem	_CurItem;
		/// <summary>C[W</summary>
		private	Image			CurImage;
		/// <summary></summary>
		private	string			CurText;
		/// <summary>CtH[</summary>
		private	MainForm		MForm;

		private System.Windows.Forms.Panel PnlImage;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox TbxName;
		private System.Windows.Forms.DateTimePicker DtpCreation;
		private System.Windows.Forms.DateTimePicker DtpLastWrite;
		private System.Windows.Forms.CheckBox ChkHidden;
		private System.Windows.Forms.CheckBox ChkReadOnly;
		private System.Windows.Forms.TextBox TbxSize;
		private System.Windows.Forms.TextBox TbxPath;
		private System.Windows.Forms.Button BtnUpdate;
		private System.Windows.Forms.Button BtnPrev;
		private System.Windows.Forms.Button BtnNext;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public ViewForm( MainForm owner )
		{
			InitializeComponent();

			this.Owner = owner;
			this.MForm = owner;

			this.Top  = Owner.Top   + 150;
			this.Left = Owner.Right - 250;
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// tH[
		/// </summary>
		private void ViewForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			MForm.FormPrview = null;
			MForm.FormPrviewClosed();
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ViewForm));
			this.PnlImage = new System.Windows.Forms.Panel();
			this.DtpCreation = new System.Windows.Forms.DateTimePicker();
			this.DtpLastWrite = new System.Windows.Forms.DateTimePicker();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.TbxName = new System.Windows.Forms.TextBox();
			this.ChkReadOnly = new System.Windows.Forms.CheckBox();
			this.ChkHidden = new System.Windows.Forms.CheckBox();
			this.TbxSize = new System.Windows.Forms.TextBox();
			this.TbxPath = new System.Windows.Forms.TextBox();
			this.BtnUpdate = new System.Windows.Forms.Button();
			this.BtnPrev = new System.Windows.Forms.Button();
			this.BtnNext = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// PnlImage
			// 
			this.PnlImage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.PnlImage.BackColor = System.Drawing.SystemColors.AppWorkspace;
			this.PnlImage.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.PnlImage.Font = new System.Drawing.Font("lr SVbN", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.PnlImage.Location = new System.Drawing.Point(5, 130);
			this.PnlImage.Name = "PnlImage";
			this.PnlImage.Size = new System.Drawing.Size(330, 280);
			this.PnlImage.TabIndex = 0;
			this.PnlImage.Resize += new System.EventHandler(this.PnlImage_Resize);
			this.PnlImage.Paint += new System.Windows.Forms.PaintEventHandler(this.PnlImage_Paint);
			// 
			// DtpCreation
			// 
			this.DtpCreation.CustomFormat = "yyyyNMMdd HH:mm:ss";
			this.DtpCreation.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.DtpCreation.Location = new System.Drawing.Point(70, 65);
			this.DtpCreation.Name = "DtpCreation";
			this.DtpCreation.Size = new System.Drawing.Size(160, 19);
			this.DtpCreation.TabIndex = 2;
			// 
			// DtpLastWrite
			// 
			this.DtpLastWrite.CustomFormat = "yyyyNMMdd HH:mm:ss";
			this.DtpLastWrite.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.DtpLastWrite.Location = new System.Drawing.Point(70, 85);
			this.DtpLastWrite.Name = "DtpLastWrite";
			this.DtpLastWrite.Size = new System.Drawing.Size(160, 19);
			this.DtpLastWrite.TabIndex = 3;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(5, 5);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(60, 20);
			this.label1.TabIndex = 4;
			this.label1.Text = "O:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(5, 25);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(60, 20);
			this.label2.TabIndex = 5;
			this.label2.Text = "ꏊ:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(5, 45);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(60, 20);
			this.label3.TabIndex = 6;
			this.label3.Text = "TCY:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(5, 65);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(60, 20);
			this.label4.TabIndex = 7;
			this.label4.Text = "쐬:";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(5, 85);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(60, 20);
			this.label5.TabIndex = 8;
			this.label5.Text = "XV:";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(5, 105);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(60, 20);
			this.label6.TabIndex = 9;
			this.label6.Text = ":";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// TbxName
			// 
			this.TbxName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.TbxName.Location = new System.Drawing.Point(70, 5);
			this.TbxName.Name = "TbxName";
			this.TbxName.Size = new System.Drawing.Size(265, 19);
			this.TbxName.TabIndex = 10;
			this.TbxName.Text = "";
			// 
			// ChkReadOnly
			// 
			this.ChkReadOnly.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.ChkReadOnly.Location = new System.Drawing.Point(70, 105);
			this.ChkReadOnly.Name = "ChkReadOnly";
			this.ChkReadOnly.Size = new System.Drawing.Size(100, 20);
			this.ChkReadOnly.TabIndex = 13;
			this.ChkReadOnly.Text = "ǂݎp";
			// 
			// ChkHidden
			// 
			this.ChkHidden.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.ChkHidden.Location = new System.Drawing.Point(165, 105);
			this.ChkHidden.Name = "ChkHidden";
			this.ChkHidden.Size = new System.Drawing.Size(90, 20);
			this.ChkHidden.TabIndex = 14;
			this.ChkHidden.Text = "Bt@C";
			// 
			// TbxSize
			// 
			this.TbxSize.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.TbxSize.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.TbxSize.Location = new System.Drawing.Point(70, 49);
			this.TbxSize.Name = "TbxSize";
			this.TbxSize.ReadOnly = true;
			this.TbxSize.Size = new System.Drawing.Size(265, 12);
			this.TbxSize.TabIndex = 12;
			this.TbxSize.Text = "";
			// 
			// TbxPath
			// 
			this.TbxPath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.TbxPath.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.TbxPath.Location = new System.Drawing.Point(70, 29);
			this.TbxPath.Name = "TbxPath";
			this.TbxPath.ReadOnly = true;
			this.TbxPath.Size = new System.Drawing.Size(265, 12);
			this.TbxPath.TabIndex = 11;
			this.TbxPath.Text = "";
			// 
			// BtnUpdate
			// 
			this.BtnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.BtnUpdate.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnUpdate.Location = new System.Drawing.Point(270, 100);
			this.BtnUpdate.Name = "BtnUpdate";
			this.BtnUpdate.Size = new System.Drawing.Size(65, 25);
			this.BtnUpdate.TabIndex = 15;
			this.BtnUpdate.Text = "XV";
			this.BtnUpdate.Click += new System.EventHandler(this.BtnUpdate_Click);
			// 
			// BtnPrev
			// 
			this.BtnPrev.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.BtnPrev.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnPrev.Location = new System.Drawing.Point(270, 65);
			this.BtnPrev.Name = "BtnPrev";
			this.BtnPrev.Size = new System.Drawing.Size(30, 30);
			this.BtnPrev.TabIndex = 16;
			this.BtnPrev.Text = "<";
			this.BtnPrev.Click += new System.EventHandler(this.BtnPrev_Click);
			// 
			// BtnNext
			// 
			this.BtnNext.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.BtnNext.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnNext.Location = new System.Drawing.Point(305, 65);
			this.BtnNext.Name = "BtnNext";
			this.BtnNext.Size = new System.Drawing.Size(30, 30);
			this.BtnNext.TabIndex = 17;
			this.BtnNext.Text = ">";
			this.BtnNext.Click += new System.EventHandler(this.BtnNext_Click);
			// 
			// ViewForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(342, 416);
			this.Controls.Add(this.BtnNext);
			this.Controls.Add(this.BtnPrev);
			this.Controls.Add(this.BtnUpdate);
			this.Controls.Add(this.ChkHidden);
			this.Controls.Add(this.ChkReadOnly);
			this.Controls.Add(this.TbxSize);
			this.Controls.Add(this.TbxPath);
			this.Controls.Add(this.TbxName);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.DtpLastWrite);
			this.Controls.Add(this.DtpCreation);
			this.Controls.Add(this.PnlImage);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "ViewForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.ViewForm_Closing);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// C[W\
		/// </summary>
		private void PnlImage_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			try
			{
				if( CurImage != null )
				{
					if( CurImage.Width  <= PnlImage.Width  &&
						CurImage.Height <= PnlImage.Height )
					{
						e.Graphics.DrawImage( CurImage, 0, 0 );
					}
					else
					{
						Rectangle	rect = new Rectangle(0, 0, PnlImage.Width, PnlImage.Height);

						if( (CurImage.Width - rect.Width) > (CurImage.Height - rect.Height))
						{
							rect.Height = (CurImage.Height * rect.Width / CurImage.Width);
						}
						else
						{
							rect.Width = (CurImage.Width * rect.Height / CurImage.Height);
						}

						e.Graphics.DrawImage( CurImage, rect );
					}
				}
				else if( CurText != null )
				{
					e.Graphics.DrawString(
						CurText,
						PnlImage.Font,
						Brushes.White,
						new Rectangle( 0, 0, PnlImage.Width, PnlImage.Height ) );
				}
			}
			catch
			{
			}
		}
		private void PnlImage_Resize(object sender, System.EventArgs e)
		{
			PnlImage.Invalidate();
		}


		/// <summary>
		/// \
		/// </summary>
		private void DispInfo()
		{
			FileInfoEx	fix = new FileInfoEx( _CurItem.Tag.ToString() );

			try
			{	// ACRݒ
				System.Reflection.Assembly	asm = System.Reflection.Assembly.GetExecutingAssembly();
				this.Icon = new Icon( asm.GetManifestResourceStream( fix.IsFile ? "TimeStamper.res.file.ico" : "TimeStamper.res.folder.ico") );
			}
			catch
			{
			}

			if( fix.Exists == false )	return;

			this.Text = fix.Name;

			TbxName.Text = fix.Name;
			TbxPath.Text = fix.FullName;
			TbxSize.Text = fix.SizeStr;

			DtpCreation.Value   = fix.CreationTime;
			DtpLastWrite.Value  = fix.LastWriteTime;
			ChkHidden.Checked   = fix.Hidden;
			ChkReadOnly.Checked = fix.ReadOnly;

			if( fix.IsFile )
			{	// t@C̏ꍇ
				FileStream	fs = new System.IO.FileStream( fix.FullName, FileMode.Open, FileAccess.Read );

				try
				{	// C[W擾
					CurImage = Image.FromStream( fs );
				}
				catch
				{
					CurImage = null;
				}

				if( CurImage == null )
				{
					try
					{	// eLXg擾
						byte[]	bs = new byte[ (int)Math.Min( fs.Length, (1024 * 10) ) ];
						fs.Read( bs, 0, bs.Length );
						CurText = Encoding.Default.GetString( bs, 0, bs.Length );
					}
					catch
					{
						CurText = null;
					}
				}

				fs.Close();
			}

			PnlImage.Invalidate();
		}

		/// <summary>
		/// XV{^
		/// </summary>
		private void BtnUpdate_Click(object sender, System.EventArgs e)
		{
			if( _CurItem == null )	return;

			if( DialogResult.OK != MessageBox.Show( this, "t@CXV܂", "mF", MessageBoxButtons.OKCancel ) )	return;

			FileInfoEx	fix = new FileInfoEx( _CurItem.Tag.ToString() );

			if( fix.ReadOnly )
			{	// ǂݎp̏ꍇAύXł悤ꎞ
				fix.ReadOnly = false;
			}
			
			if( fix.CreationTime != DtpCreation.Value )
			{	// 쐬
				fix.CreationTime = DtpCreation.Value;
			}

			if( fix.LastWriteTime != DtpLastWrite.Value )
			{	// XV
				fix.LastWriteTime = DtpLastWrite.Value;
			}

			// ǂݎp
			fix.Hidden = ChkHidden.Checked;

			// [hI[
			fix.ReadOnly = ChkReadOnly.Checked;

			if( fix.Name != TbxName.Text )
			{	// l[
				fix.Rename( TbxName.Text );
			}

			// Xgɔf
			MForm.UpdateRow( _CurItem, fix );
		}

		/// <summary>
		/// Õt@C
		/// </summary>
		private void BtnPrev_Click(object sender, System.EventArgs e)
		{
			MForm.MoveRow( _CurItem, -1 );
		}

		/// <summary>
		/// ̃t@C
		/// </summary>
		private void BtnNext_Click(object sender, System.EventArgs e)
		{
			MForm.MoveRow( _CurItem, 1 );
		}

		/// <summary>t@CpX</summary>
		public ListViewItem CurItem
		{
			set
			{
				_CurItem = value;

				if( CurImage != null )
				{
					CurImage.Dispose();
					CurImage = null;
				}

				CurText = null;

				if( _CurItem == null )
				{
					BtnUpdate.Enabled = false;
					this.Text = "";
					TbxName.Text = "";
					TbxPath.Text = "";
					TbxSize.Text = "";
					DtpCreation.Value   = DateTime.Now;
					DtpLastWrite.Value  = DateTime.Now;
					ChkHidden.Checked   = false;
					ChkReadOnly.Checked = false;
				}
				else
				{
					BtnUpdate.Enabled = true;
					DispInfo();
				}
			}
			get{ return _CurItem; }
		}
	}
}
