using System;
using System.IO;
using System.Text;

namespace TimeStamper
{
	/// <summary>
	/// FileInfoEx ̊Tv̐łB
	/// </summary>
	public class FileInfoEx
	{
		public	bool			IsFile;
		public	FileSystemInfo	Fsi;

		/// <summary>
		/// RXgN^
		/// </summary>
		public FileInfoEx( string path )
		{
			Fsi = new FileInfo( path );
			IsFile = true;

			if( (Fsi.Attributes & FileAttributes.Directory) != 0 )
			{	// tH_̏ꍇ
				Fsi = new DirectoryInfo( path );
				IsFile = false;
			}
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		public FileInfoEx( FileSystemInfo fsi )
		{
			Fsi = fsi;
			IsFile = true;

			if( (Fsi.Attributes & FileAttributes.Directory) != 0 )
			{	// tH_̏ꍇ
				IsFile = false;
			}
		}

		/// <summary>
		/// l[
		/// </summary>
		public FileSystemInfo Rename( string rename )
		{
			if( rename == null ||
				rename.Length == 0 )	return Fsi;

			string	oldPath = Fsi.FullName;
			string	newPath = Path.Combine( Path.GetDirectoryName( Fsi.FullName ), rename );

			// l[FileSystemInfoXV
			if( IsFile )
			{
				File.Move( oldPath, newPath );
				Fsi = new FileInfo( newPath );
			}
			else
			{
				Directory.Move( oldPath, newPath );
				Fsi = new DirectoryInfo( newPath );
			}

			return Fsi;
		}

		/// <summary>
		/// t@C̏ꍇAt@CTCY
		/// </summary>
		public long Length
		{
			get
			{
				if( IsFile )
				{
					return ((FileInfo)Fsi).Length;
				}
				return 0;
			}
		}
		/// <summary>
		/// t@CTCY
		/// </summary>
		public string SizeStr
		{
			get
			{
				if( IsFile )
				{
					long	filesize = Length / 1024;	// B  KB

					if( filesize == 0 )	return "1 KB";

					return filesize.ToString( "N0" ) + " KB";
				}
				else
				{
					DirectoryInfo[]	dirs  = GetDirectories();
					FileInfo[]		files = GetFiles();

					return
						"tH_:" + (dirs  != null ? dirs.Length.ToString()  : "0") + ", " +
						"t@C:" + (files != null ? files.Length.ToString() : "0");
				}
			}
		}

		/// <summary>
		/// t@C
		/// </summary>
		public string AttrStr
		{
			get
			{
				StringBuilder	sb = new StringBuilder();

				sb.Append( ((Attributes & FileAttributes.Archive  ) != 0) ? "A" : "-" );
				sb.Append( ((Attributes & FileAttributes.ReadOnly ) != 0) ? "R" : "-" );
				sb.Append( ((Attributes & FileAttributes.Hidden   ) != 0) ? "H" : "-" );
				sb.Append( ((Attributes & FileAttributes.System   ) != 0) ? "S" : "-" );
				sb.Append( ((Attributes & FileAttributes.Directory) != 0) ? "D" : "-" );
	
				return sb.ToString();
			}
		}


		/// <summary>
		/// tH_̏ꍇAʂ̃tH_
		/// </summary>
		public DirectoryInfo[] GetDirectories()
		{
			if( IsFolder )
			{
				return ((DirectoryInfo)Fsi).GetDirectories();
			}
			return null;
		}
	
		/// <summary>
		/// tH_̏ꍇAʂ̃t@C
		/// </summary>
		public FileInfo[] GetFiles()
		{
			if( IsFolder )
			{
				return ((DirectoryInfo)Fsi).GetFiles();
			}
			return null;
		}
	
		/// <summary>
		/// tH_
		/// </summary>
		public bool IsFolder
		{
			get{ return (IsFile ? false : true); }
		}

		/// <summary>
		/// ǂݎp
		/// </summary>
		public bool Hidden
		{
			set
			{
				if( value )
				{	// ON
					Attributes |= FileAttributes.Hidden;
				}
				else
				{	// OFF
					Attributes &= ~FileAttributes.Hidden;
				}
			}
			get{ return ((Attributes & FileAttributes.Hidden) != 0 ? true : false); }
		}

		/// <summary>
		/// [hI[
		/// </summary>
		public bool ReadOnly
		{
			set
			{
				if( value )
				{	// ON
					Attributes |= FileAttributes.ReadOnly;
				}
				else
				{	// OFF
					Attributes &= ~FileAttributes.ReadOnly;
				}
			}
			get{ return ((Attributes & FileAttributes.ReadOnly) != 0 ? true : false); }
		}
		
		#region ### FileSystemInfo vpeB
		/// <summary>
		/// O
		/// </summary>
		public string Name
		{
			get{ return Fsi.Name; }
		}

		/// <summary>
		/// tpX
		/// </summary>
		public string FullName
		{
			get{ return Fsi.FullName; }
		}

		/// <summary>
		/// gq
		/// </summary>
		public string Extension
		{
			get{ return Fsi.Extension; }
		}

		/// <summary>
		/// 
		/// </summary>
		public FileAttributes Attributes
		{
			set{ Fsi.Attributes = value; }
			get{ return Fsi.Attributes; }
		}

		/// <summary>
		/// ݃`FbN
		/// </summary>
		public bool Exists
		{
			get{ return Fsi.Exists; }
		}

		/// <summary>
		/// 쐬
		/// </summary>
		public DateTime CreationTime
		{
			set{ Fsi.CreationTime = value; }
			get{ return Fsi.CreationTime; }
		}

		/// <summary>
		/// XV
		/// </summary>
		public DateTime LastWriteTime
		{
			set{ Fsi.LastWriteTime = value; }
			get{ return Fsi.LastWriteTime; }
		}
		#endregion
	}
}
