using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Runtime.InteropServices;
using System.Xml;

namespace TimeStamper
{
	/// <summary>
	/// MainForm ̊Tv̐ł
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		#region ### 萔`
		/// <summary>ݒt@C</summary>
		private const string ENV_FILE = "env.xml";

		/// <summary>C[WXg̃ACRCfbNX</summary>
		enum IconIdx : int
		{
			Desktop   = 0,
			MyDoc     = 1,
			Drive     = 2,
			Folder    = 3,
			Folder_h  = 4,
			Folder_r  = 5,
			Folder_hr = 6,
			File      = 7,
			File_h    = 8,
			File_r    = 9,
			File_hr   = 10,
		}
		/// <summary>Xgr[̃TuACẽCfbNX</summary>
		enum LvwSubItmIdx : int
		{
			Name   = 0,
			Rename = 1,
			Size   = 2,
			CTime  = 3,
			WTime  = 4,
			Attr   = 5,
		}
		#endregion

		#region ### GetDriveType
		// GetDriveType̖߂l
		// const int DRIVE_UNKNOWN     = 0;
		// const int DRIVE_NO_ROOT_DIR = 1;
		// const int DRIVE_REMOVABLE   = 2;
		// const int DRIVE_FIXED       = 3;
		// const int DRIVE_REMOTE      = 4;
		// const int DRIVE_CDROM       = 5;
		// const int DRIVE_RAMDISK     = 6;
		enum DriveType : int
		{
			Unknown = 0,
			NoRootDir = 1,
			Removable = 2,
			Fixed = 3,
			Remote = 4,
			CDROM = 5,
			RAMDisk = 6,
		}

		[DllImport( "kernel32.dll", EntryPoint = "GetDriveType", CharSet = CharSet.Auto )] 
		static extern int GetDriveType( [MarshalAs( UnmanagedType.LPTStr )] string nDrive );
		#endregion

		#region ### Xgr[\[gpNX
		/// <summary>
		/// Xgr[\[gpNX
		/// </summary>
		class ListViewItemComparer : IComparer 
		{
			private int		_SortCol = 0;
			private bool	Order = true;

			public int SortCol
			{
				set
				{
					if( _SortCol == value )
					{
						Order = (Order ? false : true);
					}
					else
					{
						Order = true;
						_SortCol = value;
					}			
				}
				get { return _SortCol; }
			}

			public int Compare(object x, object y) 
			{
				// ~
				if( Order == false )	return String.Compare(((ListViewItem)y).SubItems[SortCol].Text, ((ListViewItem)x).SubItems[SortCol].Text);

				// 
				return String.Compare(((ListViewItem)x).SubItems[SortCol].Text, ((ListViewItem)y).SubItems[SortCol].Text);
			}
		}
		#endregion

		#region ### ϐ

		private ListViewItemComparer	LvwSorter = null;
		private ViewForm				_FormPrview = null;


		private System.Windows.Forms.TreeView TvwFolder;
		private System.Windows.Forms.ListView LvwFile;
		private System.Windows.Forms.Panel PnlLeft;
		private System.Windows.Forms.Panel PnlRight;
		private System.Windows.Forms.TextBox TbxFile;
		private System.Windows.Forms.StatusBar SbarMessage;
		private System.Windows.Forms.Panel PnlMain;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.ImageList IltIcons;
		private System.Windows.Forms.ContextMenu CtmLvwFile;
		private System.Windows.Forms.RadioButton RbtRename;
		private System.Windows.Forms.RadioButton RbtTimeStamp;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.ComboBox CbxFilter;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.MenuItem MiAllChk;
		private System.Windows.Forms.MenuItem MiAllUnChk;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.ColumnHeader colhedName;
		private System.Windows.Forms.ColumnHeader colhedSize;
		private System.Windows.Forms.ColumnHeader colhedCreate;
		private System.Windows.Forms.ColumnHeader colhedUpdate;
		private System.Windows.Forms.ColumnHeader colhedAttr;
		private System.Windows.Forms.ColumnHeader colhedRename;
		private TimeStamper.TimeStampCtrl TsCtrl;
		private System.Windows.Forms.Button BtnUpdate;
		private TimeStamper.RenameCtrl RnCtrl;
		private System.Windows.Forms.Button BtnCheck;
		private System.Windows.Forms.MenuItem MiSelChk;
		private System.Windows.Forms.MenuItem MiSelUnChk;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem MiFileInfo;
		private System.Windows.Forms.CheckBox ChkWriteLog;
		private System.Windows.Forms.MenuItem MiFile;
		private System.Windows.Forms.MenuItem MiExit;
		private System.Windows.Forms.MainMenu MmForm;
		private System.Windows.Forms.ToolBar TbarMain;
		private System.Windows.Forms.ToolBarButton TbbFolder;
		private System.Windows.Forms.ToolBarButton TbbFile;
		private System.Windows.Forms.ToolBarButton TbbInfo;
		private System.Windows.Forms.Button BtnUp;
		private System.Windows.Forms.Button BtnDown;
		private System.Windows.Forms.MenuItem MiDispFile;
		private System.Windows.Forms.MenuItem MiDispFolder;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem MiVersion;
		private System.ComponentModel.IContainer components;

		#endregion

		#region ### RXgN^
		/// <summary>
		/// RXgN^
		/// </summary>
		public MainForm()
		{
			InitializeComponent();
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhł̃\bh̓e
		/// R[h GfB^ŕύXȂł
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.TvwFolder = new System.Windows.Forms.TreeView();
			this.IltIcons = new System.Windows.Forms.ImageList(this.components);
			this.PnlLeft = new System.Windows.Forms.Panel();
			this.PnlRight = new System.Windows.Forms.Panel();
			this.LvwFile = new System.Windows.Forms.ListView();
			this.colhedName = new System.Windows.Forms.ColumnHeader();
			this.colhedRename = new System.Windows.Forms.ColumnHeader();
			this.colhedSize = new System.Windows.Forms.ColumnHeader();
			this.colhedCreate = new System.Windows.Forms.ColumnHeader();
			this.colhedUpdate = new System.Windows.Forms.ColumnHeader();
			this.colhedAttr = new System.Windows.Forms.ColumnHeader();
			this.CtmLvwFile = new System.Windows.Forms.ContextMenu();
			this.MiAllChk = new System.Windows.Forms.MenuItem();
			this.MiAllUnChk = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.MiSelChk = new System.Windows.Forms.MenuItem();
			this.MiSelUnChk = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.MiDispFile = new System.Windows.Forms.MenuItem();
			this.MiDispFolder = new System.Windows.Forms.MenuItem();
			this.MiFileInfo = new System.Windows.Forms.MenuItem();
			this.TbxFile = new System.Windows.Forms.TextBox();
			this.SbarMessage = new System.Windows.Forms.StatusBar();
			this.PnlMain = new System.Windows.Forms.Panel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.RbtRename = new System.Windows.Forms.RadioButton();
			this.RbtTimeStamp = new System.Windows.Forms.RadioButton();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.CbxFilter = new System.Windows.Forms.ComboBox();
			this.label4 = new System.Windows.Forms.Label();
			this.TsCtrl = new TimeStamper.TimeStampCtrl();
			this.BtnUpdate = new System.Windows.Forms.Button();
			this.RnCtrl = new TimeStamper.RenameCtrl();
			this.BtnCheck = new System.Windows.Forms.Button();
			this.ChkWriteLog = new System.Windows.Forms.CheckBox();
			this.MmForm = new System.Windows.Forms.MainMenu();
			this.MiFile = new System.Windows.Forms.MenuItem();
			this.MiVersion = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.MiExit = new System.Windows.Forms.MenuItem();
			this.TbarMain = new System.Windows.Forms.ToolBar();
			this.TbbFolder = new System.Windows.Forms.ToolBarButton();
			this.TbbFile = new System.Windows.Forms.ToolBarButton();
			this.TbbInfo = new System.Windows.Forms.ToolBarButton();
			this.BtnUp = new System.Windows.Forms.Button();
			this.BtnDown = new System.Windows.Forms.Button();
			this.PnlLeft.SuspendLayout();
			this.PnlRight.SuspendLayout();
			this.PnlMain.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// TvwFolder
			// 
			this.TvwFolder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.TvwFolder.HideSelection = false;
			this.TvwFolder.ImageList = this.IltIcons;
			this.TvwFolder.Location = new System.Drawing.Point(5, 0);
			this.TvwFolder.Name = "TvwFolder";
			this.TvwFolder.Size = new System.Drawing.Size(185, 360);
			this.TvwFolder.TabIndex = 0;
			this.TvwFolder.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.TvwFolder_AfterSelect);
			this.TvwFolder.BeforeExpand += new System.Windows.Forms.TreeViewCancelEventHandler(this.TvwFolder_BeforeExpand);
			// 
			// IltIcons
			// 
			this.IltIcons.ImageSize = new System.Drawing.Size(16, 16);
			this.IltIcons.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("IltIcons.ImageStream")));
			this.IltIcons.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// PnlLeft
			// 
			this.PnlLeft.Controls.Add(this.TvwFolder);
			this.PnlLeft.Dock = System.Windows.Forms.DockStyle.Left;
			this.PnlLeft.Location = new System.Drawing.Point(0, 0);
			this.PnlLeft.Name = "PnlLeft";
			this.PnlLeft.Size = new System.Drawing.Size(190, 360);
			this.PnlLeft.TabIndex = 1;
			// 
			// PnlRight
			// 
			this.PnlRight.Controls.Add(this.LvwFile);
			this.PnlRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.PnlRight.Location = new System.Drawing.Point(195, 0);
			this.PnlRight.Name = "PnlRight";
			this.PnlRight.Size = new System.Drawing.Size(577, 360);
			this.PnlRight.TabIndex = 4;
			// 
			// LvwFile
			// 
			this.LvwFile.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.LvwFile.CheckBoxes = true;
			this.LvwFile.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.colhedName,
																					  this.colhedRename,
																					  this.colhedSize,
																					  this.colhedCreate,
																					  this.colhedUpdate,
																					  this.colhedAttr});
			this.LvwFile.ContextMenu = this.CtmLvwFile;
			this.LvwFile.GridLines = true;
			this.LvwFile.HideSelection = false;
			this.LvwFile.LabelEdit = true;
			this.LvwFile.Location = new System.Drawing.Point(0, 0);
			this.LvwFile.Name = "LvwFile";
			this.LvwFile.Size = new System.Drawing.Size(570, 360);
			this.LvwFile.SmallImageList = this.IltIcons;
			this.LvwFile.TabIndex = 0;
			this.LvwFile.View = System.Windows.Forms.View.Details;
			this.LvwFile.DoubleClick += new System.EventHandler(this.LvwFile_DoubleClick);
			this.LvwFile.AfterLabelEdit += new System.Windows.Forms.LabelEditEventHandler(this.LvwFile_AfterLabelEdit);
			this.LvwFile.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.LvwFile_ColumnClick);
			this.LvwFile.SelectedIndexChanged += new System.EventHandler(this.LvwFile_SelectedIndexChanged);
			this.LvwFile.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.LvwFile_ItemCheck);
			// 
			// colhedName
			// 
			this.colhedName.Text = "O";
			this.colhedName.Width = 160;
			// 
			// colhedRename
			// 
			this.colhedRename.Text = "VO";
			this.colhedRename.Width = 160;
			// 
			// colhedSize
			// 
			this.colhedSize.Text = "TCY";
			this.colhedSize.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.colhedSize.Width = 80;
			// 
			// colhedCreate
			// 
			this.colhedCreate.Text = "쐬";
			this.colhedCreate.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colhedCreate.Width = 100;
			// 
			// colhedUpdate
			// 
			this.colhedUpdate.Text = "XV";
			this.colhedUpdate.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colhedUpdate.Width = 100;
			// 
			// colhedAttr
			// 
			this.colhedAttr.Text = "";
			this.colhedAttr.Width = 100;
			// 
			// CtmLvwFile
			// 
			this.CtmLvwFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.MiAllChk,
																					   this.MiAllUnChk,
																					   this.menuItem1,
																					   this.MiSelChk,
																					   this.MiSelUnChk,
																					   this.menuItem2,
																					   this.MiDispFile,
																					   this.MiDispFolder,
																					   this.MiFileInfo});
			this.CtmLvwFile.Popup += new System.EventHandler(this.CtmLvwFile_Popup);
			// 
			// MiAllChk
			// 
			this.MiAllChk.Index = 0;
			this.MiAllChk.Text = "Să`FbN";
			this.MiAllChk.Click += new System.EventHandler(this.MiAllChk_Click);
			// 
			// MiAllUnChk
			// 
			this.MiAllUnChk.Index = 1;
			this.MiAllUnChk.Text = "Să`FbN";
			this.MiAllUnChk.Click += new System.EventHandler(this.MiAllUnChk_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 2;
			this.menuItem1.Text = "-";
			// 
			// MiSelChk
			// 
			this.MiSelChk.Index = 3;
			this.MiSelChk.Text = "It@C`FbN";
			this.MiSelChk.Click += new System.EventHandler(this.MiSelChk_Click);
			// 
			// MiSelUnChk
			// 
			this.MiSelUnChk.Index = 4;
			this.MiSelUnChk.Text = "It@C̃`FbN";
			this.MiSelUnChk.Click += new System.EventHandler(this.MiSelUnChk_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 5;
			this.menuItem2.Text = "-";
			// 
			// MiDispFile
			// 
			this.MiDispFile.Index = 6;
			this.MiDispFile.Text = "t@C\";
			this.MiDispFile.Click += new System.EventHandler(this.MiDispFile_Click);
			// 
			// MiDispFolder
			// 
			this.MiDispFolder.Index = 7;
			this.MiDispFolder.Text = "tH_\";
			this.MiDispFolder.Click += new System.EventHandler(this.MiDispFolder_Click);
			// 
			// MiFileInfo
			// 
			this.MiFileInfo.Index = 8;
			this.MiFileInfo.Text = "EChE\";
			this.MiFileInfo.Click += new System.EventHandler(this.MiFileInfo_Click);
			// 
			// TbxFile
			// 
			this.TbxFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.TbxFile.Location = new System.Drawing.Point(5, 28);
			this.TbxFile.Name = "TbxFile";
			this.TbxFile.ReadOnly = true;
			this.TbxFile.Size = new System.Drawing.Size(760, 19);
			this.TbxFile.TabIndex = 6;
			this.TbxFile.Text = "";
			// 
			// SbarMessage
			// 
			this.SbarMessage.Location = new System.Drawing.Point(0, 545);
			this.SbarMessage.Name = "SbarMessage";
			this.SbarMessage.Size = new System.Drawing.Size(772, 20);
			this.SbarMessage.TabIndex = 32;
			// 
			// PnlMain
			// 
			this.PnlMain.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.PnlMain.Controls.Add(this.PnlRight);
			this.PnlMain.Controls.Add(this.splitter1);
			this.PnlMain.Controls.Add(this.PnlLeft);
			this.PnlMain.Location = new System.Drawing.Point(0, 50);
			this.PnlMain.Name = "PnlMain";
			this.PnlMain.Size = new System.Drawing.Size(772, 360);
			this.PnlMain.TabIndex = 33;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(190, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(5, 360);
			this.splitter1.TabIndex = 4;
			this.splitter1.TabStop = false;
			// 
			// RbtRename
			// 
			this.RbtRename.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.RbtRename.Location = new System.Drawing.Point(15, 50);
			this.RbtRename.Name = "RbtRename";
			this.RbtRename.Size = new System.Drawing.Size(105, 20);
			this.RbtRename.TabIndex = 1;
			this.RbtRename.Text = "t@CύX";
			this.RbtRename.Click += new System.EventHandler(this.RbtMenu_Click);
			// 
			// RbtTimeStamp
			// 
			this.RbtTimeStamp.Checked = true;
			this.RbtTimeStamp.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.RbtTimeStamp.Location = new System.Drawing.Point(15, 25);
			this.RbtTimeStamp.Name = "RbtTimeStamp";
			this.RbtTimeStamp.Size = new System.Drawing.Size(155, 20);
			this.RbtTimeStamp.TabIndex = 0;
			this.RbtTimeStamp.TabStop = true;
			this.RbtTimeStamp.Text = "^CX^vEύX";
			this.RbtTimeStamp.Click += new System.EventHandler(this.RbtMenu_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.RbtRename);
			this.groupBox1.Controls.Add(this.RbtTimeStamp);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(5, 450);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(185, 85);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "j[";
			// 
			// CbxFilter
			// 
			this.CbxFilter.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.CbxFilter.Items.AddRange(new object[] {
														   "*.*",
														   "*.bmp",
														   "*.jpg",
														   "*.png",
														   "*.gif",
														   "*.ico",
														   "*.txt",
														   "*.dat",
														   "*.exe",
														   "*.dll",
														   "*.ini"});
			this.CbxFilter.Location = new System.Drawing.Point(650, 5);
			this.CbxFilter.MaxDropDownItems = 32;
			this.CbxFilter.Name = "CbxFilter";
			this.CbxFilter.Size = new System.Drawing.Size(115, 20);
			this.CbxFilter.TabIndex = 8;
			this.CbxFilter.Text = "*.*";
			this.CbxFilter.KeyDown += new System.Windows.Forms.KeyEventHandler(this.CbxFilter_KeyDown);
			this.CbxFilter.SelectedIndexChanged += new System.EventHandler(this.CbxFilter_SelectedIndexChanged);
			// 
			// label4
			// 
			this.label4.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label4.Location = new System.Drawing.Point(600, 5);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(45, 20);
			this.label4.TabIndex = 7;
			this.label4.Text = "tB^:";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// TsCtrl
			// 
			this.TsCtrl.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.TsCtrl.AttributeChk = false;
			this.TsCtrl.CreationDate = new System.DateTime(2005, 4, 15, 0, 0, 0, 0);
			this.TsCtrl.CreationDateChk = false;
			this.TsCtrl.CreationTime = new System.DateTime(2005, 4, 15, 0, 0, 0, 0);
			this.TsCtrl.CreationTimeChk = false;
			this.TsCtrl.HiddenChk = false;
			this.TsCtrl.LastWriteDate = new System.DateTime(2005, 4, 15, 0, 0, 0, 0);
			this.TsCtrl.LastWriteDateChk = false;
			this.TsCtrl.LastWriteTime = new System.DateTime(2005, 4, 15, 0, 0, 0, 0);
			this.TsCtrl.LastWriteTimeChk = false;
			this.TsCtrl.Location = new System.Drawing.Point(195, 450);
			this.TsCtrl.Name = "TsCtrl";
			this.TsCtrl.ReadOnlyChk = false;
			this.TsCtrl.Size = new System.Drawing.Size(575, 85);
			this.TsCtrl.TabIndex = 34;
			// 
			// BtnUpdate
			// 
			this.BtnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.BtnUpdate.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnUpdate.Location = new System.Drawing.Point(625, 415);
			this.BtnUpdate.Name = "BtnUpdate";
			this.BtnUpdate.Size = new System.Drawing.Size(140, 25);
			this.BtnUpdate.TabIndex = 36;
			this.BtnUpdate.Text = "XV";
			this.BtnUpdate.Click += new System.EventHandler(this.BtnUpdate_Click);
			// 
			// RnCtrl
			// 
			this.RnCtrl.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.RnCtrl.ChkExt = false;
			this.RnCtrl.LeftText = "";
			this.RnCtrl.Location = new System.Drawing.Point(195, 450);
			this.RnCtrl.Name = "RnCtrl";
			this.RnCtrl.NewText = "";
			this.RnCtrl.NumDigit = 3;
			this.RnCtrl.NumStart = 1;
			this.RnCtrl.OldText = "";
			this.RnCtrl.RightText = "";
			this.RnCtrl.Size = new System.Drawing.Size(575, 85);
			this.RnCtrl.TabIndex = 37;
			this.RnCtrl.Visible = false;
			// 
			// BtnCheck
			// 
			this.BtnCheck.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.BtnCheck.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnCheck.Location = new System.Drawing.Point(480, 415);
			this.BtnCheck.Name = "BtnCheck";
			this.BtnCheck.Size = new System.Drawing.Size(140, 25);
			this.BtnCheck.TabIndex = 38;
			this.BtnCheck.Text = "mF";
			this.BtnCheck.Click += new System.EventHandler(this.BtnCheck_Click);
			// 
			// ChkWriteLog
			// 
			this.ChkWriteLog.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.ChkWriteLog.Checked = true;
			this.ChkWriteLog.CheckState = System.Windows.Forms.CheckState.Checked;
			this.ChkWriteLog.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.ChkWriteLog.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.ChkWriteLog.Location = new System.Drawing.Point(445, 5);
			this.ChkWriteLog.Name = "ChkWriteLog";
			this.ChkWriteLog.Size = new System.Drawing.Size(150, 20);
			this.ChkWriteLog.TabIndex = 42;
			this.ChkWriteLog.Text = "XVOt@Cɏo";
			// 
			// MmForm
			// 
			this.MmForm.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.MiFile});
			// 
			// MiFile
			// 
			this.MiFile.Index = 0;
			this.MiFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.MiVersion,
																				   this.menuItem4,
																				   this.MiExit});
			this.MiFile.Text = "t@C(&F)";
			// 
			// MiVersion
			// 
			this.MiVersion.Index = 0;
			this.MiVersion.Text = "o[W(&V)";
			this.MiVersion.Click += new System.EventHandler(this.MiVersion_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 1;
			this.menuItem4.Text = "-";
			// 
			// MiExit
			// 
			this.MiExit.Index = 2;
			this.MiExit.Text = "I(&X)";
			this.MiExit.Click += new System.EventHandler(this.MiExit_Click);
			// 
			// TbarMain
			// 
			this.TbarMain.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																						this.TbbFolder,
																						this.TbbFile,
																						this.TbbInfo});
			this.TbarMain.DropDownArrows = true;
			this.TbarMain.ImageList = this.IltIcons;
			this.TbarMain.Location = new System.Drawing.Point(0, 0);
			this.TbarMain.Name = "TbarMain";
			this.TbarMain.ShowToolTips = true;
			this.TbarMain.Size = new System.Drawing.Size(772, 28);
			this.TbarMain.TabIndex = 43;
			this.TbarMain.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.TbarMain.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.TbarMain_ButtonClick);
			// 
			// TbbFolder
			// 
			this.TbbFolder.ImageIndex = 3;
			this.TbbFolder.Pushed = true;
			this.TbbFolder.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.TbbFolder.Text = "tH_";
			// 
			// TbbFile
			// 
			this.TbbFile.ImageIndex = 7;
			this.TbbFile.Pushed = true;
			this.TbbFile.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.TbbFile.Text = "t@C";
			// 
			// TbbInfo
			// 
			this.TbbInfo.ImageIndex = 11;
			this.TbbInfo.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.TbbInfo.Text = "EChE";
			// 
			// BtnUp
			// 
			this.BtnUp.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.BtnUp.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnUp.Location = new System.Drawing.Point(195, 415);
			this.BtnUp.Name = "BtnUp";
			this.BtnUp.Size = new System.Drawing.Size(40, 25);
			this.BtnUp.TabIndex = 44;
			this.BtnUp.Text = "";
			this.BtnUp.Click += new System.EventHandler(this.BtnUp_Click);
			// 
			// BtnDown
			// 
			this.BtnDown.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.BtnDown.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.BtnDown.Location = new System.Drawing.Point(240, 415);
			this.BtnDown.Name = "BtnDown";
			this.BtnDown.Size = new System.Drawing.Size(40, 25);
			this.BtnDown.TabIndex = 45;
			this.BtnDown.Text = "";
			this.BtnDown.Click += new System.EventHandler(this.BtnDown_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(772, 565);
			this.Controls.Add(this.BtnDown);
			this.Controls.Add(this.BtnUp);
			this.Controls.Add(this.ChkWriteLog);
			this.Controls.Add(this.TbxFile);
			this.Controls.Add(this.PnlMain);
			this.Controls.Add(this.CbxFilter);
			this.Controls.Add(this.BtnCheck);
			this.Controls.Add(this.BtnUpdate);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.TbarMain);
			this.Controls.Add(this.SbarMessage);
			this.Controls.Add(this.TsCtrl);
			this.Controls.Add(this.RnCtrl);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.KeyPreview = true;
			this.Menu = this.MmForm;
			this.Name = "MainForm";
			this.Text = "TimeStamper";
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.MainForm_KeyDown);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.MainForm_Closing);
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.PnlLeft.ResumeLayout(false);
			this.PnlRight.ResumeLayout(false);
			this.PnlMain.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region ### NEI
		/// <summary>
		/// AvP[ṼC Gg |Cgł
		/// </summary>
		[STAThread]
		static void Main() 
		{
			MutexEx		m = new MutexEx( "TimeStamper.exe" );
			if( m.Create() )
			{	// NOK
				Application.Run(new MainForm());
			}
			else
			{	// 2dNG[bZ[W\Ȃ
				MessageBox.Show( "̃vO͊ɋNĂ܂B", "2dN" );
			}
			m.Close();
		}

		/// <summary>
		/// tH[[h
		/// </summary>
		private void MainForm_Load(object sender, System.EventArgs e)
		{
			this.Text = "TimeStamper: Ver " + Application.ProductVersion.ToString();

			string	curPath = "";

			try
			{	// ݒǂݍ
				XmlDocumentEx	doc = new XmlDocumentEx( Application.StartupPath, ENV_FILE );
				XmlNode			node;

				for( int i = 0; i < doc.DocumentElement.ChildNodes.Count; i++ )
				{
					node = doc.DocumentElement.ChildNodes[ i ];

					if( node.Name == "path" )
					{
						curPath = node.InnerText;						
					}
					else if( node.Name == "blog" )
					{
						ChkWriteLog.Checked = bool.Parse( node.InnerText );
					}
					else if( node.Name == "bfolder" )
					{
						TbbFolder.Pushed = bool.Parse( node.InnerText );
					}
					else if( node.Name == "bfile" )
					{
						TbbFile.Pushed = bool.Parse( node.InnerText );
					}
				}
			}
			catch
			{
			}


			// hCuZbg
			SetDrive();


			// OȈԕFOJĂtH_܂ŊJ
			if( curPath.Length == 0 )	return;
			string[]	names = curPath.Split( new char[]{'\\'}, 100 );
			TreeNodeCollection	nodes = TvwFolder.Nodes;

			for( int i = 0; i < names.Length; i++ )
			{
				nodes = NodeOpen( nodes, names[i], (i == names.Length - 1 ? true : false) );
				if( nodes == null )	return;
			}
		}

		/// <summary>
		/// vm[hJilast=truȅꍇAIj
		/// </summary>
		private TreeNodeCollection NodeOpen( TreeNodeCollection nodes, string name, bool last )
		{
			TreeNode	node;

			for( int i = 0; i < nodes.Count; i++ )
			{
				node = nodes[ i ];

				if( node.Text == name ||
					node.Text == name + "\\" )
				{
					if( last )
					{
						TvwFolder.SelectedNode = node;
					}
					else
					{
						node.Expand();
					}

					return node.Nodes;
				}
			}
			return null;
		}

		/// <summary>
		/// I
		/// </summary>
		private void MiExit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}
		
		/// <summary>
		/// o[W
		/// </summary>
		private void MiVersion_Click(object sender, System.EventArgs e)
		{
			DlgVersion	dv = new DlgVersion();
			dv.ShowDialog();
		}

		/// <summary>
		/// I
		/// </summary>
		private void MainForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{	// ݒۑ
				XmlDocumentEx	doc = new XmlDocumentEx( "<env></env>" );
				doc.AddElt( doc.DocumentElement, "path",    TvwFolder.SelectedNode != null ? TvwFolder.SelectedNode.FullPath.Replace( @"\\", @"\" ) : "" );
				doc.AddElt( doc.DocumentElement, "bfolder", TbbFolder.Pushed.ToString() );
				doc.AddElt( doc.DocumentElement, "bfile",   TbbFile.Pushed.ToString() );
				doc.AddElt( doc.DocumentElement, "blog",    ChkWriteLog.Checked.ToString() );
				doc.SaveXml( Path.Combine( Application.StartupPath, ENV_FILE ) );
			}
			catch
			{
			}
		}


		#endregion

		#region ### c[r[֘A
		/// <summary>
		/// gp\hCu擾
		/// </summary>
		private void SetDrive()
		{
			TvwFolder.Nodes.Clear();

			TreeNode	node;

			// fXNgbv
			node                    = TvwFolder.Nodes.Add( "fXNgbv" );
			node.ImageIndex         = (int)IconIdx.Desktop;
			node.SelectedImageIndex = (int)IconIdx.Desktop;
			node.Tag                = System.Environment.GetFolderPath( Environment.SpecialFolder.DesktopDirectory );
			node.Nodes.Add("+");	// [+] \ׂ̃_~[

			TvwFolder.SelectedNode = node;


			// }ChLg
			node                    = TvwFolder.Nodes.Add( "}C hLg" );
			node.ImageIndex         = (int)IconIdx.MyDoc;
			node.SelectedImageIndex = (int)IconIdx.MyDoc;
			node.Tag                = System.Environment.GetFolderPath( Environment.SpecialFolder.Personal );
			node.Nodes.Add("+");	// [+] \ׂ̃_~[

			string[]	drives = Directory.GetLogicalDrives();
			DriveType	driveType;

			foreach ( string drive in drives )
			{
				driveType = (DriveType)GetDriveType( drive );
 
				switch ( driveType )
				{
					case DriveType.Fixed:		// Œ hCu
						node                    = TvwFolder.Nodes.Add( drive );
						node.ImageIndex         = (int)IconIdx.Drive;
						node.SelectedImageIndex = (int)IconIdx.Drive;
						node.Tag                = drive;
						node.Nodes.Add("+");	// [+] \ׂ̃_~[

						break;
					default:
					case DriveType.Removable:	// [ou hCu
					case DriveType.CDROM:		// CD-ROM hCu
					case DriveType.Remote:		// lbg[N hCu
					case DriveType.RAMDisk:		// RAM fBXN
					case DriveType.NoRootDir:	// ([gfBNg݂܂)
					case DriveType.Unknown:		// (ʕs\)
						break;
				}
			}

		}

		/// <summary>
		/// m[hWJO
		/// </summary>
		private void TvwFolder_BeforeExpand(object sender, System.Windows.Forms.TreeViewCancelEventArgs e)
		{
			Cursor.Current = Cursors.WaitCursor;

			FillTvwFolder( e.Node );

			Cursor.Current = Cursors.Default;
		}

		/// <summary>
		/// TufBNgm[hɒǉ
		/// </summary>
		private void FillTvwFolder( TreeNode curNode )
		{
			try
			{
				// _~[m[hNA
				curNode.Nodes.Clear();

				string			curPath = curNode.Tag.ToString().Replace( @"\\", @"\" );
				DirectoryInfo	curDir = new DirectoryInfo( curPath );
				curDir.Refresh();

				// fBNg݂΁Am[hǉ
				if( curDir.Exists == false )	return;

				DirectoryInfo[]	dirs = curDir.GetDirectories();
				Sort( dirs );

				TreeNode		node;
				int				imgidx;

				foreach (DirectoryInfo di in dirs)
				{
					if((di.Attributes & FileAttributes.System) != 0)	continue;

					imgidx = (int)IconIdx.Folder;
					if((di.Attributes & FileAttributes.Hidden  ) != 0)	imgidx += 1;
					if((di.Attributes & FileAttributes.ReadOnly) != 0)	imgidx += 2;

					node                    = curNode.Nodes.Add( di.Name );
					node.ImageIndex         = imgidx;
					node.SelectedImageIndex = imgidx;
					node.Tag                = di.FullName;

					if( di.GetDirectories().Length > 0 )
					{	// ʃfBNg݂ꍇA[+] \ׂ̃_~[u
						node.Nodes.Add("+");
					}
				}
			}
			catch (Exception e)
			{
				SbarMessage.Text = e.Message;
			}
		}

		/// <summary>
		/// m[hI
		/// </summary>
		private void TvwFolder_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			Cursor.Current = Cursors.WaitCursor;

			FillLvwFile( e.Node );

			Cursor.Current = Cursors.Default;
		}

		/// <summary>
		/// m[hJĎwtH_I
		/// </summary>
		private void ExpandTvwFolder( string diName )
		{
			if( TvwFolder.SelectedNode != null )
			{
				TvwFolder.SelectedNode.Expand();

				TreeNode	node;
				for( int i = 0; i < TvwFolder.SelectedNode.Nodes.Count; i++ )
				{
					node = TvwFolder.SelectedNode.Nodes[ i ];
					if( node.Text == diName )
					{
						TvwFolder.SelectedNode = node;
						return;
					}
				}
			}
		}
		#endregion

		#region ### Xgr[֘A
		/// <summary>
		/// Tut@CXgr[ɒǉ
		/// </summary>
		private void FillLvwFile( TreeNode curNode )
		{
			if( curNode == null )	return;

			try
			{
				LvwFile.Items.Clear();

				if( FormPrview != null )
				{
					FormPrview.CurItem = null;
				}

				string			curPath = curNode.Tag.ToString().Replace( @"\\", @"\" );
				DirectoryInfo	curDir = new DirectoryInfo( curPath );
				curDir.Refresh();

				if( curDir.Exists == false )	return;

				TbxFile.Text = curPath;

				//LvwFile.BeginUpdate();

				if( TbbFolder.Pushed )
				{	// tH_̗
					DirectoryInfo[]	dirs = curDir.GetDirectories( CbxFilter.Text );
					Sort( dirs );

					foreach (DirectoryInfo di in dirs)
					{
						if((di.Attributes & FileAttributes.System) != 0)	continue;

						InsertRow( di );
					}
				}

				if( TbbFile.Pushed )
				{	// t@C̗
					FileInfo[]	files = curDir.GetFiles( CbxFilter.Text );
					Sort( files );

					foreach (FileInfo fi in files)
					{
						if((fi.Attributes & FileAttributes.System) != 0)	continue;

						InsertRow( fi );
					}
				}

				//LvwFile.EndUpdate();

				SbarMessage.Text = LvwFile.Items.Count + " ̃IuWFNg";
			}
			catch (Exception e)
			{
				SbarMessage.Text = e.Message;
			}
		}

		/// <summary>
		/// z̃\[g
		/// </summary>
		private void Sort( FileSystemInfo[] fis )
		{
			FileSystemInfo	fi1, fi2;

			for( int i = 0; i < fis.Length - 1; i++ )
			{
				for( int j = i + 1; j < fis.Length; j++ )
				{
					fi1 = fis[i];
					fi2 = fis[j];

					if( fi1.Name.CompareTo( fi2.Name ) > 0 )
					{
						fis[i] = fi2;
						fis[j] = fi1;
					}
				}
			}
		}

		/// <summary>
		/// Xgɒǉ
		/// </summary>
		private void InsertRow( FileSystemInfo fi )
		{
			ListViewItem	lvi = LvwFile.Items.Add( fi.Name );

			lvi.SubItems.AddRange( new string[]{ "", "", "", "", "" } );
			
			UpdateRow( lvi, new FileInfoEx( fi ) );
		}

		/// <summary>
		/// Xg̍XV
		/// </summary>
		public void UpdateRow( ListViewItem lvi, FileInfoEx fix )
		{
			int		imgidx = (int)(fix.IsFile ? IconIdx.File : IconIdx.Folder);
			if( fix.Hidden )	imgidx += 1;
			if( fix.ReadOnly )	imgidx += 2;

			lvi.Text       = fix.Name;
			lvi.ImageIndex = imgidx;

			lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";

			if( fix.IsFile )
			{	// t@C̏ꍇ
				lvi.SubItems[ (int)LvwSubItmIdx.Size ].Text = fix.SizeStr;
			}

			lvi.SubItems[ (int)LvwSubItmIdx.CTime ].Text = fix.CreationTime.ToString(  "yy/MM/dd HH:mm" );
			lvi.SubItems[ (int)LvwSubItmIdx.WTime ].Text = fix.LastWriteTime.ToString( "yy/MM/dd HH:mm" );
			lvi.SubItems[ (int)LvwSubItmIdx.Attr  ].Text = fix.Attributes.ToString();

			lvi.Tag = fix.FullName;
		}

		/// <summary>
		/// Is̈ړ
		/// </summary>
		public void MoveRow( ListViewItem lvi, int move )
		{
			int	idx = LvwFile.Items.IndexOf( lvi );
			idx += move;

			if( idx < 0 )	idx = 0;
			if( idx > LvwFile.Items.Count - 1 )	idx = LvwFile.Items.Count - 1;

			if( lvi != null )	lvi.Selected = false;
			LvwFile.Items[idx].Selected = true;

		}

		/// <summary>
		/// t@CXg`FbNԐ؂ւ
		/// </summary>
		private void LvwFile_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			ListViewItem	lvi = LvwFile.Items[ e.Index ];

			if( e.NewValue == CheckState.Checked )
			{
			}
			else
			{
			}
		}

		/// <summary>
		/// t@CXgI؂ւ
		/// </summary>
		private void LvwFile_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if( LvwFile.SelectedItems.Count > 0 )
			{
				ListViewItem	lvi = LvwFile.SelectedItems[0];
				TbxFile.Text = (lvi.Tag != null ? lvi.Tag.ToString() : "");

				if( FormPrview != null )
				{
					FormPrview.CurItem = lvi;
				}
			}
			else
			{
				TbxFile.Text = "";

				if( FormPrview != null )
				{
					FormPrview.CurItem = null;
				}
			}
		}

		/// <summary>
		/// t@CXg_uNbN
		/// </summary>
		private void LvwFile_DoubleClick(object sender, System.EventArgs e)
		{
			if( LvwFile.SelectedItems.Count > 0 )
			{
				ListViewItem	lvi = LvwFile.SelectedItems[0];

				if( lvi.Tag != null )
				{
					FileSystemInfo	fi = new FileInfo( lvi.Tag.ToString() );
					if( (fi.Attributes & FileAttributes.Directory) != 0 )
					{	// tH_
						ExpandTvwFolder( fi.Name );
					}
					else
					{	// t@C
						try
						{
							System.Diagnostics.Process.Start( lvi.Tag.ToString() );
						}
						catch (Exception ex)
						{
							SbarMessage.Text = ex.Message;
						}
					}
				}
			}
		}

		/// <summary>
		/// t@CXgJNbN
		/// </summary>
		private void LvwFile_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if( LvwSorter == null )
			{
				LvwSorter = new ListViewItemComparer();
			}

			LvwSorter.SortCol = e.Column;

			LvwFile.ListViewItemSorter = LvwSorter;
			LvwFile.Sort();
			LvwFile.ListViewItemSorter = null;	// ςȂƃXgɃACe邽тɃ\[gĂ܂HHH
		}

		/// <summary>
		/// t@CҏWI
		/// </summary>
		private void LvwFile_AfterLabelEdit(object sender, System.Windows.Forms.LabelEditEventArgs e)
		{
			if( e.Label == null || e.Label.Length == 0 )
			{
				e.CancelEdit = true;
				return;
			}

			try
			{
				ListViewItem	lvi = LvwFile.Items[ e.Item ];

				string	oldPath = lvi.Tag.ToString();
				string	newPath = Path.Combine( Path.GetDirectoryName( oldPath ), e.Label );
					
				if( Path.GetExtension(oldPath) != Path.GetExtension(newPath) )
				{
					if( DialogResult.OK != MessageBox.Show( this,
						"gqύXƁAt@CgȂȂ\܂B\r\nύX܂H",
						"O̕ύX", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning ) )
					{
						e.CancelEdit = true;
						return;
					}
				}

				// l[
				File.Move( oldPath, newPath );

				lvi.Tag = newPath;
			}
			catch (Exception ex)
			{
				SbarMessage.Text = ex.Message;
			}
		}

		/// <summary>
		/// l[mFiAԁj
		/// </summary>
		private void CheckRename( string ltxt, string rtxt, int numstart, int numdigit)
		{
			ListViewItem	lvi;
			string			rename;
			string			ext;
			int				cnt = 0;

			//LvwFile.BeginUpdate();//܂AȂ

			try
			{
				for( int i = 0; i < LvwFile.Items.Count; i++ )
				{
					lvi = LvwFile.Items[i];

					if( lvi.Checked == false )
					{	// `FbN̕tĂ̂Ώ
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";
						lvi.ForeColor = SystemColors.WindowText;
						continue;
					}

					rename = ltxt + (cnt + numstart).ToString( "D" + numdigit.ToString() ) + rtxt;	// t@C
					ext = Path.GetExtension( lvi.Tag.ToString() );	// gq

					if( ext != null && ext.Length > 0 )
					{
						rename = rename + ext;
					}

					lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = rename;
					lvi.ForeColor = Color.Green;

					cnt++;
				}

				SbarMessage.Text = cnt.ToString() + "̃t@CXV̑ΏۂłB";
			}
			catch( Exception e )
			{
				SbarMessage.Text = e.Message;
			}

			//LvwFile.EndUpdate();
		}

		/// <summary>
		/// l[mFiuj
		/// </summary>
		private void CheckRename( string oldtxt, string newtxt, bool bfnm, bool bext )
		{
			ListViewItem	lvi;
			string			rename, fnm, ext;
			int				cnt = 0;

			//LvwFile.BeginUpdate();//܂AȂ

			try
			{
				for( int i = 0; i < LvwFile.Items.Count; i++ )
				{
					lvi = LvwFile.Items[i];

					/***
					if( lvi.Checked == false )
					{	// `FbN̕tĂ̂Ώ
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";
						lvi.ForeColor = SystemColors.WindowText;
						continue;
					}
					***/

					if( bfnm && bext )
					{	// uɃt@Cgq܂߂
						rename = lvi.Text.Replace( oldtxt, newtxt );
					}
					else
					{	// t@Corgq
						fnm = Path.GetFileNameWithoutExtension( lvi.Tag.ToString() );
						ext = Path.GetExtension( lvi.Tag.ToString() );

						rename =
							(bfnm ? fnm.Replace( oldtxt, newtxt ) : fnm) +
							(bext ? ext.Replace( oldtxt, newtxt ) : ext);
					}

					if( rename != lvi.Text )
					{
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = rename;
						lvi.Checked = true;
						lvi.ForeColor = Color.Green;
						cnt++;
					}
					else
					{	// ύXȂ߃l[ΏۂO
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";
						lvi.Checked = false;
						lvi.ForeColor = SystemColors.WindowText;
					}
				}

				SbarMessage.Text = cnt.ToString() + "̃t@CXV̑ΏۂłB";
			}
			catch( Exception e )
			{
				SbarMessage.Text = e.Message;
			}

			//LvwFile.EndUpdate();
		}

		/// <summary>
		/// l[mFi啶̏j
		/// </summary>
		private void CheckRename( int option, bool bfnm, bool bext )
		{
			ListViewItem	lvi;
			string			rename, fnm, ext;
			int				cnt = 0;

			//LvwFile.BeginUpdate();//܂AȂ

			try
			{
				for( int i = 0; i < LvwFile.Items.Count; i++ )
				{
					lvi = LvwFile.Items[i];

					if( lvi.Checked == false )
					{	// `FbN̕tĂ̂Ώ
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";
						lvi.ForeColor = SystemColors.WindowText;
						continue;
					}

					if( bfnm && bext )
					{	// uɃt@Cgq܂߂
						if( option == RenameCtrl.OPTION_LOWER )
						{
							rename = lvi.Text.ToLower();
						}
						else
						{
							rename = lvi.Text.ToUpper();
						}
					}
					else
					{	// t@Corgq
						fnm = Path.GetFileNameWithoutExtension( lvi.Tag.ToString() );
						ext = Path.GetExtension( lvi.Tag.ToString() );

						if( option == RenameCtrl.OPTION_LOWER )
						{
							rename =
								(bfnm ? fnm.ToLower() : fnm) +
								(bext ? ext.ToLower() : ext);
						}
						else
						{
							rename =
								(bfnm ? fnm.ToUpper() : fnm) +
								(bext ? ext.ToUpper() : ext);
						}

					}

					if( rename != lvi.Text )
					{
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = rename;
						lvi.Checked = true;
						lvi.ForeColor = Color.Green;
						cnt++;
					}
					else
					{	// ύXȂ߃l[ΏۂO
						lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text = "";
						lvi.Checked = false;
						lvi.ForeColor = SystemColors.WindowText;
					}
				}

				SbarMessage.Text = cnt.ToString() + "̃t@CXV̑ΏۂłB";
			}
			catch( Exception e )
			{
				SbarMessage.Text = e.Message;
			}

			//LvwFile.EndUpdate();
		}

		/// <summary>
		/// Să`FbNor
		/// </summary>
		private void LvwFileAllChk( System.Collections.IList lvic, bool chk )
		{
			for( int i = 0; i < lvic.Count; i++ )
			{
				((ListViewItem)lvic[i]).Checked = chk;
			}
		}
		/// <summary>
		/// Să`FbN
		/// </summary>
		private void MiAllChk_Click(object sender, System.EventArgs e)
		{
			LvwFileAllChk( LvwFile.Items, true );
		}
		/// <summary>
		/// SẴ`FbN
		/// </summary>
		private void MiAllUnChk_Click(object sender, System.EventArgs e)
		{
			LvwFileAllChk( LvwFile.Items, false );
		}
		/// <summary>
		/// It@C`FbN
		/// </summary>
		private void MiSelChk_Click(object sender, System.EventArgs e)
		{
			LvwFileAllChk( LvwFile.SelectedItems, true );
		}
		/// <summary>
		/// It@C`FbN
		/// </summary>
		private void MiSelUnChk_Click(object sender, System.EventArgs e)
		{
			LvwFileAllChk( LvwFile.SelectedItems, false );
		}
		/// <summary>
		/// EChE\
		/// </summary>
		private void MiFileInfo_Click(object sender, System.EventArgs e)
		{
			TbbInfo.Pushed = (TbbInfo.Pushed ? false : true);		
			TbarMain_ButtonClick( TbbInfo );
		}
		/// <summary>
		/// t@C\
		/// </summary>
		private void MiDispFile_Click(object sender, System.EventArgs e)
		{
			TbbFile.Pushed = (TbbFile.Pushed ? false : true);		
			TbarMain_ButtonClick( TbbFile );
		}
		/// <summary>
		/// tH_\
		/// </summary>
		private void MiDispFolder_Click(object sender, System.EventArgs e)
		{
			TbbFolder.Pushed = (TbbFolder.Pushed ? false : true);		
			TbarMain_ButtonClick( TbbFolder );
		}
		/// <summary>
		/// ReLXgj[|bvAbv
		/// </summary>
		private void CtmLvwFile_Popup(object sender, System.EventArgs e)
		{
			MiAllUnChk.Enabled = (LvwFile.CheckedItems.Count == 0 ? false : true);
			MiAllChk.Enabled = (LvwFile.CheckedItems.Count == LvwFile.Items.Count ? false : true);

			if( LvwFile.SelectedItems.Count > 0 )
			{
				MiSelChk.Enabled = true;
				MiSelUnChk.Enabled = true;
			}
			else
			{
				MiSelChk.Enabled = false;
				MiSelUnChk.Enabled = false;
			}

			MiFileInfo.Checked = TbbInfo.Pushed;
			MiDispFile.Checked = TbbFile.Pushed;
			MiDispFolder.Checked = TbbFolder.Pushed;
		}

		/// <summary>
		/// L[_ECxg
		/// </summary>
		private void MainForm_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			Console.WriteLine( e.KeyData.ToString() );
			if( e.Control && e.KeyCode == Keys.A )
			{	// Ctrl+A
				for( int i = 0; i < LvwFile.Items.Count; i++ )
				{
					//LvwFile.Items[i].Selected = true;
					LvwFile.Items[i].Checked = true;
				}
				LvwFile.Focus();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private void BtnUp_Click(object sender, System.EventArgs e)
		{
			ListViewItem	lvi1, lvi2;
			int				idx;

			LvwFile.BeginUpdate();

			for( int i = 0; i < LvwFile.SelectedIndices.Count; i++ )
			{
				idx = LvwFile.SelectedIndices[i];

				if( idx == 0 )	break;

				lvi1 = LvwFile.Items[ idx ];
				lvi2 = LvwFile.Items[ idx - 1 ];

				LvwFile.Items.RemoveAt( idx - 1 );
				LvwFile.Items.Insert( idx, lvi2 );
			}		
	
			LvwFile.Focus();
			LvwFile.EndUpdate();
		}

		/// <summary>
		/// 
		/// </summary>
		private void BtnDown_Click(object sender, System.EventArgs e)
		{
			ListViewItem	lvi1, lvi2;
			int				idx;

			LvwFile.BeginUpdate();

			for( int i = LvwFile.SelectedIndices.Count - 1; i >= 0; i-- )
			{
				idx = LvwFile.SelectedIndices[i];

				if( idx == LvwFile.Items.Count - 1 )	break;

				lvi1 = LvwFile.Items[ idx ];
				lvi2 = LvwFile.Items[ idx + 1 ];

				LvwFile.Items.RemoveAt( idx );
				LvwFile.Items.Insert( idx + 1, lvi1 );
			}		

			LvwFile.Focus();
			LvwFile.EndUpdate();
		}
		
		#endregion

		#region ### ^CX^vEt@C֘A
		/// <summary>
		/// t@C̃^CX^vEύX
		/// </summary>
		private void TimeStampFiles( System.Collections.IList lvic )
		{
			if( lvic.Count == 0 )
			{
				SbarMessage.Text = "XVΏۂ̃t@Cw肳Ă܂";
				return;
			}

			if( TsCtrl.UpdateChk == false )
			{
				SbarMessage.Text = "XVew肳Ă܂";
				return;
			}

			if( DialogResult.OK != MessageBox.Show( this, lvic.Count + " ̃t@CXV܂", "mF", MessageBoxButtons.OKCancel ) )	return;

			Cursor.Current = Cursors.WaitCursor;

			int				cnt = 0;
			int				err = 0;
			ListViewItem	lvi;
			StreamWriter	sw = null;

			if( ChkWriteLog.Checked )
			{
				string	logfile = "ts" + DateTime.Now.ToString( "yyyyMMddHHmm" ) + ".log";
				sw = new StreamWriter( Path.Combine( Application.StartupPath, logfile ), false, System.Text.Encoding.GetEncoding("Shift_JIS") );
				if( sw != null )
				{
					sw.Write( "TimeStamper: Ver " + Application.ProductVersion.ToString() + "\r\n" );
					sw.Write( "[timestamp] Start: " + DateTime.Now.ToString() + "\r\n" );
					sw.Write( "[" + TvwFolder.SelectedNode.Tag.ToString().Replace( @"\\", @"\" ) + "]\r\n\r\n" );
				}
			}


			DlgWait	dw = new DlgWait( this, 0, lvic.Count );
			dw.Show();

			for( int i = 0; i < lvic.Count; i++ )
			{
				lvi = (ListViewItem)lvic[i];
				dw.Step();

				if( ChangeAttr( lvi, sw ) )
				{
					lvi.ForeColor = Color.Blue;
					cnt++;
				}
				else
				{
					lvi.ForeColor = Color.Red;
					err++;
				}
			}

			dw.Close();

			if( sw != null )
			{
				sw.Write( "\r\n[timestamp] End: " + DateTime.Now.ToString() + "\r\n" );
				sw.Write( "I: " + cnt + ",@" + "G[: " + err + "\r\n" );
				sw.Close();
			}

			Cursor.Current = Cursors.Default;

			SbarMessage.Text = "I: " + cnt + ",@" + "G[: " + err;
		}

		/// <summary>
		/// t@C̃^CX^vEύX
		/// </summary>
		private bool ChangeAttr( ListViewItem lvi, StreamWriter sw )
		{
			try
			{
				FileInfoEx	fix = new FileInfoEx( lvi.Tag.ToString() );

				if( fix.Exists == false )	return false;

				string		ymd, hm;
				bool		readonly_flag = false;

				if( sw != null )
				{	// XVO
					sw.Write( fix.Name + ", " +
						fix.CreationTime.ToString( "yyyy/MM/dd hh:mm" ) + ", " +
						fix.LastWriteTime.ToString( "yyyy/MM/dd hh:mm" ) + ", " +
						fix.Attributes.ToString() + " --> "
						);
				}

				if( fix.ReadOnly )
				{	// ǂݎp̏ꍇAύXł悤ꎞ
					fix.ReadOnly = false;
					readonly_flag = true;
				}
	
				// t@C쐬ύX
				if( TsCtrl.UpdateCreationChk )
				{
					ymd = fix.CreationTime.ToString( "yyyy/MM/dd" );
					hm  = fix.CreationTime.ToString( "HH:mm:ss" );

					if( TsCtrl.CreationDateChk )
					{
						ymd = TsCtrl.CreationDate.ToString( "yyyy/MM/dd" );
					}
					if( TsCtrl.CreationTimeChk )
					{
						hm = TsCtrl.CreationTime.ToString( "HH:mm:ss" );
					}

					fix.CreationTime = DateTime.Parse( ymd + " " + hm );
				}

				// t@CXVύX
				if( TsCtrl.UpdateLastWriteChk )
				{
					ymd = fix.LastWriteTime.ToString( "yyyy/MM/dd" );
					hm  = fix.LastWriteTime.ToString( "HH:mm:ss" );

					if( TsCtrl.LastWriteDateChk )
					{
						ymd = TsCtrl.LastWriteDate.ToString( "yyyy/MM/dd" );
					}
					if( TsCtrl.LastWriteTimeChk )
					{
						hm = TsCtrl.LastWriteTime.ToString( "HH:mm:ss" );
					}

					fix.LastWriteTime = DateTime.Parse( ymd + " " + hm );
				}

				// ύX
				if( TsCtrl.AttributeChk )
				{
					// B
					fix.Hidden = TsCtrl.HiddenChk;
					// [hI[
					fix.ReadOnly = TsCtrl.ReadOnlyChk;
				}
				else if( readonly_flag )
				{	// ǂݎpɖ߂
					fix.ReadOnly = readonly_flag;
				}

				// Xgɔf
				UpdateRow( lvi, fix );

				if( sw != null )
				{	// XV
					sw.Write( 
						fix.CreationTime.ToString( "yyyy/MM/dd hh:mm" ) + ", " +
						fix.LastWriteTime.ToString( "yyyy/MM/dd hh:mm" ) + ", " +
						fix.Attributes.ToString() + "\r\n"
						);
				}

			}
			catch (Exception e)
			{
				if( sw != null )
				{	// G[o
					sw.Write( e.Message + "\r\n" );
				}
				return false;
			}

			return true;
		}
		#endregion

		#region ### l[֘A
		/// <summary>
		/// t@C̖OύX
		/// </summary>
		private void RenameFiles( System.Collections.IList lvic )
		{
			if( lvic.Count == 0 )
			{
				SbarMessage.Text = "XVΏۂ̃t@Cw肳Ă܂";
				return;
			}

			if( DialogResult.OK != MessageBox.Show( this, lvic.Count + " ̃t@CXV܂", "mF", MessageBoxButtons.OKCancel ) )	return;

			Cursor.Current = Cursors.WaitCursor;

			int				cnt = 0;
			int				err = 0;
			ListViewItem	lvi;
			StreamWriter	sw = null;

			if( ChkWriteLog.Checked )
			{
				string	logfile = "rn" + DateTime.Now.ToString( "yyyyMMddHHmm" ) + ".log";
				sw = new StreamWriter( Path.Combine( Application.StartupPath, logfile ), false, System.Text.Encoding.GetEncoding("Shift_JIS") );
				if( sw != null )
				{
					sw.Write( "TimeStamper: Ver " + Application.ProductVersion.ToString() + "\r\n\r\n" );
					sw.Write( "[Rename] Start: " + DateTime.Now.ToString() + "\r\n" );
					sw.Write( "[" + TvwFolder.SelectedNode.Tag.ToString().Replace( @"\\", @"\" ) + "]\r\n\r\n" );
				}
			}

			DlgWait	dw = new DlgWait( this, 0, lvic.Count );
			dw.Show();

			for( int i = 0; i < lvic.Count; i++ )
			{
				lvi = (ListViewItem)lvic[i];
				dw.Step();

				if( ChangeName( lvi, sw ) )
				{
					lvi.ForeColor = Color.Blue;
					cnt++;
				}
				else
				{
					lvi.ForeColor = Color.Red;
					err++;
				}
			}

			dw.Close();

			if( sw != null )
			{
				sw.Write( "\r\n[Rename] End: " + DateTime.Now.ToString() + "\r\n" );
				sw.Write( "I: " + cnt + ", " + "G[: " + err + "\r\n" );
				sw.Close();
			}

			Cursor.Current = Cursors.Default;

			SbarMessage.Text = "I: " + cnt + ", " + "G[: " + err;
		}
		/// <summary>
		/// t@C̖OύX
		/// </summary>
		private bool ChangeName( ListViewItem lvi, StreamWriter sw )
		{
			try
			{
				FileInfoEx	fix = new FileInfoEx( lvi.Tag.ToString() );

				if( fix.Exists == false )	return false;

				string		oldName = fix.Name;

				fix.Rename( lvi.SubItems[ (int)LvwSubItmIdx.Rename ].Text );

				// Xgɔf
				UpdateRow( lvi, fix );

				if( sw != null )
				{	// Oo
					sw.Write( oldName + " --> " + fix.Name + "\r\n" );
				}
			}
			catch (Exception e)
			{
				if( sw != null )
				{	// G[o
					sw.Write( e.Message + "\r\n" );
				}
				return false;
			}

			return true;
		}
		
		#endregion

		#region ### ֘A
		/// <summary>
		/// XV{^
		/// </summary>
		private void UnSelectedAll()
		{
			// I
			for( int i = LvwFile.SelectedItems.Count - 1; i >= 0; i-- )
			{
				LvwFile.SelectedItems[i].Selected = false;
			}
			// tH[JX
			if( LvwFile.FocusedItem != null )
			{
				LvwFile.FocusedItem.Focused = false;
			}

		}
		
		/// <summary>
		/// XV{^
		/// </summary>
		private void BtnUpdate_Click(object sender, System.EventArgs e)
		{
			UnSelectedAll();

			if( RbtTimeStamp.Checked )
			{	// ^CX^vEXV
				TimeStampFiles( LvwFile.CheckedItems );
			}
			else
			{	// l[
				RenameFiles( LvwFile.CheckedItems );
			}

		}

		/// <summary>
		/// mF{^
		/// </summary>
		private void BtnCheck_Click(object sender, System.EventArgs e)
		{
			UnSelectedAll();

			if( RbtTimeStamp.Checked )
			{	// ^CX^vEXV
			}
			else
			{	// l[
				if( RnCtrl.Option == RenameCtrl.OPTION_NUMBER )
				{	// A
					CheckRename( RnCtrl.LeftText, RnCtrl.RightText, RnCtrl.NumStart, RnCtrl.NumDigit );
				}
				else if( RnCtrl.Option == RenameCtrl.OPTION_CHANGE )
				{	// u
					CheckRename( RnCtrl.OldText, RnCtrl.NewText, RnCtrl.ChkFname, RnCtrl.ChkExt );
				}
				else
				{	// 啶̏
					CheckRename( RnCtrl.Option, RnCtrl.ChkFname, RnCtrl.ChkExt );
				}
			}
		}

		/// <summary>
		/// j[WI{^I
		/// </summary>
		private void RbtMenu_Click(object sender, System.EventArgs e)
		{
			TsCtrl.Visible = RbtTimeStamp.Checked;
			RnCtrl.Visible = RbtRename.Checked;

			if( RbtTimeStamp.Checked )
			{	// ^CX^vEXV
				colhedRename.Width = 0;
				BtnCheck.Enabled = false;
			}
			else
			{	// l[
				colhedRename.Width = 160;
				BtnCheck.Enabled = true;
			}
		}

		/// <summary>
		/// tB^[
		/// </summary>
		private void CbxFilter_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if( e.KeyCode == Keys.Return )
			{
				FillLvwFile( TvwFolder.SelectedNode );
			}
		}
		/// <summary>
		/// tB^[
		/// </summary>
		private void CbxFilter_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			FillLvwFile( TvwFolder.SelectedNode );
		}

		/// <summary>
		/// c[o[{^NbN
		/// </summary>
		private void TbarMain_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			TbarMain_ButtonClick( e.Button );
		}
		/// <summary>
		/// c[o[{^NbN
		/// </summary>
		private void TbarMain_ButtonClick( System.Windows.Forms.ToolBarButton btn )
		{
			if( btn == TbbFolder ||
				btn == TbbFile )
			{
				FillLvwFile( TvwFolder.SelectedNode );
			}
			else if( btn == TbbInfo )
			{
				ShwoFormPrview();
			}
		}
		#endregion

		#region ### t@CEChE
		/// <summary>
		/// t@CEChE\
		/// </summary>
		private void ShwoFormPrview()
		{
			if( TbbInfo.Pushed )
			{
				_FormPrview = new ViewForm( this );

				if( LvwFile.SelectedItems.Count > 0 )
				{
					_FormPrview.CurItem = LvwFile.SelectedItems[0];
				}
				else
				{
					_FormPrview.CurItem = null;
				}

				_FormPrview.Show();
			}
			else
			{
				if( FormPrview != null )
				{
					_FormPrview.Close();
					_FormPrview = null;
				}
			}
		}

		/// <summary>
		/// t@CEChEꂽ
		/// </summary>
		public void FormPrviewClosed()
		{
			TbbInfo.Pushed = false;
		}

		/// <summary>
		/// t@CEChE
		/// </summary>
		public ViewForm FormPrview
		{
			set { _FormPrview = value; }
			get { return _FormPrview; }
		}
		#endregion
	}
}
