// WorkChkDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "WorkChk.h"
#include "WorkChkDlg.h"


#include "WCHook.h"
#pragma comment(lib,"WCHook.lib")


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



#define	WC_TASKTRAY_ID		100

#define	WM_TRAYMSG			(WM_USER +  1)
#define	WM_WC_CLEAR			(WM_USER +  2)
#define	WM_WC_EXIT			(WM_USER +  3)

#define	WM_WC_BLANK			(WM_USER + 10)


/////////////////////////////////////////////////////////////////////////////
// CWorkChkDlg _CAO

CWorkChkDlg::CWorkChkDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWorkChkDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWorkChkDlg)
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_HideFlg = TRUE;
}

void CWorkChkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWorkChkDlg)
	DDX_Control(pDX, IDC_LIST, m_CntList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWorkChkDlg, CDialog)
	//{{AFX_MSG_MAP(CWorkChkDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_NOTIFY(LVN_GETDISPINFO, IDC_LIST, OnGetdispinfoList)
	ON_WM_SIZE()
	ON_WM_MEASUREITEM()
	ON_WM_DRAWITEM()
	ON_WM_WINDOWPOSCHANGING()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWorkChkDlg bZ[W nh

void CWorkChkDlg::OnWindowPosChanging(WINDOWPOS FAR* lpwndpos) 
{
	CDialog::OnWindowPosChanging(lpwndpos);

	if( m_HideFlg )
	{
		//m_HideFlg = FALSE;
		lpwndpos->flags &= ~SWP_SHOWWINDOW;
		CDialog::OnWindowPosChanging(lpwndpos);	
	}
}

BOOL CWorkChkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	// VXeŎgĂ郁j[tHg擾
	NONCLIENTMETRICS	stNCMetrics;
	stNCMetrics.cbSize = sizeof( NONCLIENTMETRICS );
	::SystemParametersInfo( SPI_GETNONCLIENTMETRICS, sizeof( NONCLIENTMETRICS ), &stNCMetrics, 0 );
	m_mFont = stNCMetrics.lfMenuFont;

	// ^XNgCpf[^
	m_Tray.cbSize           = sizeof( NOTIFYICONDATA );
	m_Tray.hWnd             = m_hWnd;
	m_Tray.uID	            = WC_TASKTRAY_ID;
	m_Tray.uFlags           = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	m_Tray.uCallbackMessage = WM_TRAYMSG;
	m_Tray.hIcon            = m_hIcon;
	lstrcpy( m_Tray.szTip, "Work Checker Ver1.04" );

	SetTaskTrayIcon( TRUE );

	m_CntList.InsertColumn( 0, "{^", LVCFMT_LEFT,  144, 0 );
	m_CntList.InsertColumn( 1, "",   LVCFMT_RIGHT,  50, 1 );
	m_CntList.SetExtendedStyle( LVS_EX_FLATSB | LVS_EX_INFOTIP );	// `bv
	m_CntList.SetItemCount( CNT_MAX );

	for( int i = 0; i < CNT_MAX; i++ )	m_Count[i] = 0;

	ZeroMemory( m_KeyBuf, sizeof(m_KeyBuf) );

	SetWindowPos( &wndTopMost, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE );
	ShowWindow( SW_HIDE );

	StartHook( m_hWnd );

	m_StartTime = CTime::GetCurrentTime();

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CWorkChkDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CWorkChkDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWorkChkDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

    if( nType == SIZE_MINIMIZED )
    {
		ShowWindow( SW_HIDE );
	}
	else
	{
		if( m_CntList )
		{
			CRect	cr;
			GetClientRect( &cr );
			m_CntList.MoveWindow( cr.left, cr.top, cr.Width(), cr.Height() );
			m_CntList.SetColumnWidth( 0, cr.Width() - 72 );
			m_CntList.SetColumnWidth( 1, 50 );
		}
	}
}

void CWorkChkDlg::CountUp( int idx ) 
{
	if( idx < 0 && idx >= CNT_MAX )	return;

	m_Count[idx]++;

	if( IsWindowVisible() )
	{
		m_CntList.Invalidate( FALSE );
	}
}

char * CWorkChkDlg::IdxToStr( int idx, char *str ) 
{
	if( idx < 7 )
	{
		switch( idx ){
		case 0:	strcpy( str, "NbN" );		break;
		case 1:	strcpy( str, "_uNbN" );	break;
		case 2:	strcpy( str, "ENbN" );		break;
		case 3:	strcpy( str, "E_uNbN" );	break;
		case 4:	strcpy( str, "NbN" );		break;
		case 5:	strcpy( str, "_uNbN" );	break;
		case 6:	strcpy( str, "邭" );	break;
		}
	}
	else if( idx < 33 )
	{
		sprintf( str, "%c", 'A' + idx - 7 );
	}
	else if( idx < 43 )
	{
		sprintf( str, "%c", '0' + idx - 33 );
	}
	else
	{
		switch( idx ){
		case  43:	strcpy( str, "LBUTTON" );	break;
		case  44:	strcpy( str, "RBUTTON" );	break;
		case  45:	strcpy( str, "CANCEL" );	break;
		case  46:	strcpy( str, "MBUTTON" );	break;
		case  47:	strcpy( str, "BACK" );		break;
		case  48:	strcpy( str, "TAB" );		break;
		case  49:	strcpy( str, "CLEAR" );		break;
		case  50:	strcpy( str, "RETURN" );	break;
		case  51:	strcpy( str, "SHIFT" );		break;
		case  52:	strcpy( str, "CONTROL" );	break;
		case  53:	strcpy( str, "MENU" );		break;
		case  54:	strcpy( str, "PAUSE" );		break;
		case  55:	strcpy( str, "CAPITAL" );	break;
		case  56:	strcpy( str, "KANA" );		break;
		case  57:	strcpy( str, "JUNJA" );		break;
		case  58:	strcpy( str, "FINAL" );		break;
		case  59:	strcpy( str, "KANJI" );		break;
		case  60:	strcpy( str, "ESCAPE" );	break;
		case  61:	strcpy( str, "CONVERT" );	break;
		case  62:	strcpy( str, "NONCONVERT" );	break;
		case  63:	strcpy( str, "ACCEPT" );	break;
		case  64:	strcpy( str, "MODECHANGE" );	break;
		case  65:	strcpy( str, "SPACE" );		break;
		case  66:	strcpy( str, "PRIOR" );		break;
		case  67:	strcpy( str, "NEXT" );		break;
		case  68:	strcpy( str, "END" );		break;
		case  69:	strcpy( str, "HOME" );		break;
		case  70:	strcpy( str, "LEFT" );		break;
		case  71:	strcpy( str, "UP" );		break;
		case  72:	strcpy( str, "RIGHT" );		break;
		case  73:	strcpy( str, "DOWN" );		break;
		case  74:	strcpy( str, "SELECT" );	break;
		case  75:	strcpy( str, "PRINT" );		break;
		case  76:	strcpy( str, "EXECUTE" );	break;
		case  77:	strcpy( str, "SNAPSHOT" );	break;
		case  78:	strcpy( str, "INSERT" );	break;
		case  79:	strcpy( str, "DELETE" );	break;
		case  80:	strcpy( str, "HELP" );		break;
		case  81:	strcpy( str, "LWIN" );		break;
		case  82:	strcpy( str, "RWIN" );		break;
		case  83:	strcpy( str, "APPS" );		break;
		case  84:	strcpy( str, "NUMPAD0" );	break;
		case  85:	strcpy( str, "NUMPAD1" );	break;
		case  86:	strcpy( str, "NUMPAD2" );	break;
		case  87:	strcpy( str, "NUMPAD3" );	break;
		case  88:	strcpy( str, "NUMPAD4" );	break;
		case  89:	strcpy( str, "NUMPAD5" );	break;
		case  90:	strcpy( str, "NUMPAD6" );	break;
		case  91:	strcpy( str, "NUMPAD7" );	break;
		case  92:	strcpy( str, "NUMPAD8" );	break;
		case  93:	strcpy( str, "NUMPAD9" );	break;
		case  94:	strcpy( str, "MULTIPLY" );	break;
		case  95:	strcpy( str, "ADD" );		break;
		case  96:	strcpy( str, "SEPARATOR" );	break;
		case  97:	strcpy( str, "SUBTRACT" );	break;
		case  98:	strcpy( str, "DECIMAL" );	break;
		case  99:	strcpy( str, "DIVIDE" );	break;
		case 100:	strcpy( str, "F1" );		break;
		case 101:	strcpy( str, "F2" );		break;
		case 102:	strcpy( str, "F3" );		break;
		case 103:	strcpy( str, "F4" );		break;
		case 104:	strcpy( str, "F5" );		break;
		case 105:	strcpy( str, "F6" );		break;
		case 106:	strcpy( str, "F7" );		break;
		case 107:	strcpy( str, "F8" );		break;
		case 108:	strcpy( str, "F9" );		break;
		case 109:	strcpy( str, "F10" );		break;
		case 110:	strcpy( str, "F11" );		break;
		case 111:	strcpy( str, "F12" );		break;
		case 112:	strcpy( str, "F13" );		break;
		case 113:	strcpy( str, "F14" );		break;
		case 114:	strcpy( str, "F15" );		break;
		case 115:	strcpy( str, "F16" );		break;
		case 116:	strcpy( str, "F17" );		break;
		case 117:	strcpy( str, "F18" );		break;
		case 118:	strcpy( str, "F19" );		break;
		case 119:	strcpy( str, "F20" );		break;
		case 120:	strcpy( str, "F21" );		break;
		case 121:	strcpy( str, "F22" );		break;
		case 122:	strcpy( str, "F23" );		break;
		case 123:	strcpy( str, "F24" );		break;
		case 124:	strcpy( str, "NUMLOCK" );	break;
		case 125:	strcpy( str, "SCROLL" );	break;
		case 126:	strcpy( str, "LSHIFT" );	break;
		case 127:	strcpy( str, "RSHIFT" );	break;
		case 128:	strcpy( str, "LCONTROL" );	break;
		case 129:	strcpy( str, "RCONTROL" );	break;
		case 130:	strcpy( str, "LMENU" );		break;
		case 131:	strcpy( str, "RMENU" );		break;
		default:	strcpy( str, "?" );			break;
		}
	}

	return str;
}

int CWorkChkDlg::vKeyToIdx( int vkey ) 
{
	if( vkey >= 'A' && vkey <= 'Z' )
	{
		return ( vkey - 'A' + 7 );
	}
	else if( vkey >= '0' && vkey <= '9' )
	{
		return ( vkey - '0' + 33 );
	}

	switch( vkey ){
	case VK_LBUTTON:		return  43;
	case VK_RBUTTON:		return  44;
	case VK_CANCEL:			return  45;
	case VK_MBUTTON:		return  46;
	case VK_BACK:			return  47;
	case VK_TAB:			return  48;
	case VK_CLEAR:			return  49;
	case VK_RETURN:			return  50;
	case VK_SHIFT:			return  51;
	case VK_CONTROL:		return  52;
	case VK_MENU:			return  53;
	case VK_PAUSE:			return  54;
	case VK_CAPITAL:		return  55;
	case VK_KANA:			return  56;
	case VK_JUNJA:			return  57;
	case VK_FINAL:			return  58;
	case VK_KANJI:			return  59;
	case VK_ESCAPE:			return  60;
	case VK_CONVERT:		return  61;
	case VK_NONCONVERT:		return  62;
	case VK_ACCEPT:			return  63;
	case VK_MODECHANGE:		return  64;
	case VK_SPACE:			return  65;
	case VK_PRIOR:			return  66;
	case VK_NEXT:			return  67;
	case VK_END:			return  68;
	case VK_HOME:			return  69;
	case VK_LEFT:			return  70;
	case VK_UP:				return  71;
	case VK_RIGHT:			return  72;
	case VK_DOWN:			return  73;
	case VK_SELECT:			return  74;
	case VK_PRINT:			return  75;
	case VK_EXECUTE:		return  76;
	case VK_SNAPSHOT:		return  77;
	case VK_INSERT:			return  78;
	case VK_DELETE:			return  79;
	case VK_HELP:			return  80;
	case VK_LWIN:			return  81;
	case VK_RWIN:			return  82;
	case VK_APPS:			return  83;
	case VK_NUMPAD0:		return  84;
	case VK_NUMPAD1:		return  85;
	case VK_NUMPAD2:		return  86;
	case VK_NUMPAD3:		return  87;
	case VK_NUMPAD4:		return  88;
	case VK_NUMPAD5:		return  89;
	case VK_NUMPAD6:		return  90;
	case VK_NUMPAD7:		return  91;
	case VK_NUMPAD8:		return  92;
	case VK_NUMPAD9:		return  93;
	case VK_MULTIPLY:		return  94;
	case VK_ADD:			return  95;
	case VK_SEPARATOR:		return  96;
	case VK_SUBTRACT:		return  97;
	case VK_DECIMAL:		return  98;
	case VK_DIVIDE:			return  99;
	case VK_F1:				return 100;
	case VK_F2:				return 101;
	case VK_F3:				return 102;
	case VK_F4:				return 103;
	case VK_F5:				return 104;
	case VK_F6:				return 105;
	case VK_F7:				return 106;
	case VK_F8:				return 107;
	case VK_F9:				return 108;
	case VK_F10:			return 109;
	case VK_F11:			return 110;
	case VK_F12:			return 111;
	case VK_F13:			return 112;
	case VK_F14:			return 113;
	case VK_F15:			return 114;
	case VK_F16:			return 115;
	case VK_F17:			return 116;
	case VK_F18:			return 117;
	case VK_F19:			return 118;
	case VK_F20:			return 119;
	case VK_F21:			return 120;
	case VK_F22:			return 121;
	case VK_F23:			return 122;
	case VK_F24:			return 123;
	case VK_NUMLOCK:		return 124;
	case VK_SCROLL:			return 125;
	case VK_LSHIFT:			return 126;
	case VK_RSHIFT:			return 127;
	case VK_LCONTROL:		return 128;
	case VK_RCONTROL:		return 129;
	case VK_LMENU:			return 130;
	case VK_RMENU:			return 131;
	}

	return 132;
}

void CWorkChkDlg::KeyLog( int vkey ) 
{
	char	buf[KEY_BUFF+64], keybuf[KEY_BUFF], tmp[64];

	ZeroMemory( buf, sizeof(buf) );
	ZeroMemory( tmp, sizeof(tmp) );
	ZeroMemory( keybuf, sizeof(keybuf) );

	strcpy( buf, IdxToStr( vKeyToIdx(vkey), tmp ) );

	if( strlen(m_KeyBuf) + strlen(buf) >= KEY_BUFF-1 )	strncpy( keybuf, &m_KeyBuf[strlen(buf)], KEY_BUFF-1 );
	else												strcpy( keybuf, m_KeyBuf );

	strcat( keybuf, buf );
	strncpy( m_KeyBuf, keybuf, KEY_BUFF-1 );

	sprintf( buf, "WorkChecker [%s]", m_KeyBuf );
	SetWindowText( buf );
}

LRESULT CWorkChkDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch( message ) {
	case WC_LBUTTONDBLCLK:	CountUp( 1 );	//break;
	case WC_LBUTTONDOWN:	CountUp( 0 );	break;
	case WC_RBUTTONDBLCLK:	CountUp( 3 );	//break;
	case WC_RBUTTONDOWN:	CountUp( 2 );	break;
	case WC_MBUTTONDBLCLK:	CountUp( 5 );	//break;
	case WC_MBUTTONDOWN:	CountUp( 4 );	break;

	case WC_NCLBUTTONDOWN:	CountUp( 0 );	break;
	case WC_NCRBUTTONDOWN:	CountUp( 2 );	break;
	case WC_NCMBUTTONDOWN:	CountUp( 4 );	break;
	case WC_MOUSEWHEEL:		CountUp( 6 );	break;

	case WC_KEYDOWN:
		CountUp( vKeyToIdx( wParam ) );
		KeyLog( wParam );
		break;

	case WM_TRAYMSG:	// ^XNgC̃bZ[W
		if( wParam == WC_TASKTRAY_ID )
		{
			if( lParam == WM_RBUTTONDOWN )
			{	// ENbN
				CPoint	pt;
				CMenu	cmenu;
				char	tmp1[256], tmp2[64];
				int		i, pos = 0;

				GetCursorPos( &pt );
				cmenu.CreatePopupMenu();

				for( i = 0; i < CNT_MAX; i++ )
				{
					ZeroMemory( tmp2, sizeof(tmp2) );
					sprintf( tmp1, "%s [%ld]", IdxToStr( i, tmp2 ), m_Count[i] );
					cmenu.InsertMenu( pos++, MF_BYPOSITION | MF_OWNERDRAW | (i && i % 45 == 0 ? MF_MENUBARBREAK : 0), WM_WC_BLANK+i, tmp1 );
				}

				cmenu.InsertMenu( pos++, MF_BYPOSITION | MF_SEPARATOR );
				cmenu.InsertMenu( pos++, MF_BYPOSITION, WM_WC_CLEAR,  "JEg̃NA" );
				cmenu.InsertMenu( pos++, MF_BYPOSITION | MF_SEPARATOR );
				cmenu.InsertMenu( pos++, MF_BYPOSITION, WM_WC_EXIT,  "WorkChk̏I(&X)" );
				SetForegroundWindow();
				cmenu.TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this );
				cmenu.DestroyMenu();
			}
			else if( lParam == WM_LBUTTONDOWN )
			{	// NbN
				if( IsWindowVisible() )
				{
					m_HideFlg = TRUE;
					ShowWindow( SW_HIDE );
				}
				else
				{
					m_HideFlg = FALSE;
					WINDOWPLACEMENT	wndpl;
					ZeroMemory( &wndpl, sizeof(WINDOWPLACEMENT) );
					wndpl.length = sizeof(WINDOWPLACEMENT);
					GetWindowPlacement( &wndpl );
					if( wndpl.showCmd == SW_SHOWMINIMIZED )
					{	// ŏĂ猳̃TCY
						ShowWindow( SW_RESTORE );
					}
					ShowWindow( SW_SHOW );
				}
			}
		}
		break;

	case WM_QUERYENDSESSION:
		OutputLog();
		break;
	}

	return CDialog::WindowProc(message, wParam, lParam);
}


BOOL CWorkChkDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	int		wmId = LOWORD(wParam);

	switch( wmId ) {
	case WM_WC_CLEAR:
		{
			OutputLog();

			for( int i = 0; i < CNT_MAX; i++ )	m_Count[i] = 0;

			m_CntList.Invalidate( FALSE );

			m_StartTime = CTime::GetCurrentTime();
		}
		break;
	case WM_WC_EXIT:
		EndDialog( IDOK );
		break;
	}

	return CDialog::OnCommand(wParam, lParam);
}

BOOL CWorkChkDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message == WM_KEYDOWN &&
		(pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE) )
	{
		ShowWindow( SW_HIDE );
		return TRUE;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CWorkChkDlg::OutputLog( void )
{
	FILE 	*fp;
	int		i;
	char	buf[2048], tmp[64];

	m_EndTime = CTime::GetCurrentTime();

	ZeroMemory( buf, sizeof(buf) );
	ZeroMemory( tmp, sizeof(tmp) );


	sprintf( buf, "%04d/%02d/%02d,%02d:%02d,%04d/%02d/%02d,%02d:%02d,",
		m_StartTime.GetYear(), m_StartTime.GetMonth(), m_StartTime.GetDay(), m_StartTime.GetHour(), m_StartTime.GetMinute(),
		m_EndTime.GetYear(),   m_EndTime.GetMonth(),   m_EndTime.GetDay(),   m_EndTime.GetHour(),   m_EndTime.GetMinute() );

	for( i = 0; i < CNT_MAX; i++ )
	{
		sprintf( tmp, "%d%s", m_Count[i], i == (CNT_MAX-1) ? "\n" : "," );
		strcat( buf, tmp );
	}

	BOOL			flg_new = FALSE;
	WIN32_FIND_DATA	wfd;
	HANDLE			hFile = FindFirstFile( "wclog.csv", &wfd );

	if( hFile == INVALID_HANDLE_VALUE )    flg_new = TRUE;    // t@C
	FindClose(hFile);

	if( (fp = fopen("wclog.csv", "a+")) != NULL )
	{
		if( flg_new )
		{
			char	hed[2048], tmp2[64];
			ZeroMemory( hed,  sizeof(hed)  );

			strcpy( hed, "N,,I,," );

			for( i = 0; i < CNT_MAX; i++ )
			{
				ZeroMemory( tmp2, sizeof(tmp2) );
				sprintf( tmp, "%s%s", IdxToStr( i, tmp2 ), i == (CNT_MAX-1) ? "\n" : "," );
				strcat( hed, tmp );
			}
			fwrite( hed, strlen(hed), 1, fp );
		}

		fwrite( buf, strlen(buf), 1, fp );
		fclose( fp );
	}
}

void CWorkChkDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	SetTaskTrayIcon( FALSE );
	EndHook();
}

void CWorkChkDlg::SetTaskTrayIcon( BOOL set )
{
	if( !m_Tray.hWnd )	return;

	if( set )
	{	// ^XNgCɕ\
		if( Shell_NotifyIcon( NIM_MODIFY, &m_Tray ) == FALSE ) {
			Shell_NotifyIcon( NIM_ADD,    &m_Tray );
		}
	}
	else
	{	// ^XNgC폜
		Shell_NotifyIcon( NIM_DELETE, &m_Tray );
	}
}

void CWorkChkDlg::OnGetdispinfoList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	LV_ITEM* pItem = &(pDispInfo)->item;

	if( pItem->mask  & LVIF_TEXT )
	{
		switch( pItem->iSubItem ){
		case 0: //
			char	tmp[64];
			ZeroMemory( tmp, sizeof(tmp) );
			strcpy( pItem->pszText, IdxToStr( pItem->iItem, tmp ) );
			break;

		case 1: //
			sprintf( pItem->pszText, "%ld", m_Count[pItem->iItem] );
			break;
		}
	}

	*pResult = 0;
}



void CWorkChkDlg::OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMI) 
{
	if( lpMI->CtlType == ODT_MENU )
	{
		CDC		*pdc = GetDC();
		CFont	*of, cf;
		CSize	sz;
		cf.CreateFontIndirect( &m_mFont );
		of = pdc->SelectObject( &cf );
		sz = pdc->GetTextExtent( (LPCTSTR)lpMI->itemData );
		lpMI->itemWidth  = max(sz.cx, 80) + 40;
		lpMI->itemHeight = sz.cy + 2;
		pdc->SelectObject( of );
		ReleaseDC( pdc );
	}

	CDialog::OnMeasureItem(nIDCtl, lpMI);
}

void CWorkChkDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDI) 
{
	if( lpDI->CtlType == ODT_MENU )
	{
		int		idx = lpDI->itemID - WM_WC_BLANK;
		char	tmp[64];
		RECT	rc = lpDI->rcItem;

		rc.left  += 10;
		rc.right -= 10;
		ZeroMemory( tmp, sizeof(tmp) );
		DrawText( lpDI->hDC, IdxToStr( idx, tmp ), -1, &rc, DT_LEFT  | DT_VCENTER | DT_SINGLELINE );
		sprintf( tmp, "%ld", m_Count[idx] );
		DrawText( lpDI->hDC, tmp, -1, &rc, DT_RIGHT | DT_VCENTER | DT_SINGLELINE );
	}

	CDialog::OnDrawItem(nIDCtl, lpDI);
}

