// EnvDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "FCopy.h"
#include "EnvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEnvDlg _CAO


CEnvDlg::CEnvDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEnvDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEnvDlg)
	m_NmFolder = FALSE;
	m_HHMI = FALSE;
	m_MMDD = FALSE;
	m_YYYY = FALSE;
	m_CpyFolder = _T("");
	m_CurFolder = _T("");
	//}}AFX_DATA_INIT
}


void CEnvDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEnvDlg)
	DDX_Control(pDX, IDC_LIST_FILE, m_ListFile);
	DDX_Control(pDX, IDC_LIST_FOLDER, m_ListFolder);
	DDX_Check(pDX, IDC_CHK_FOLDER, m_NmFolder);
	DDX_Check(pDX, IDC_CHK_HHMI, m_HHMI);
	DDX_Check(pDX, IDC_CHK_MMDD, m_MMDD);
	DDX_Check(pDX, IDC_CHK_YYYY, m_YYYY);
	DDX_Text(pDX, IDC_EDIT_CPYFOLDER, m_CpyFolder);
	DDX_Text(pDX, IDC_EDIT_CURFOLDER, m_CurFolder);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEnvDlg, CDialog)
	//{{AFX_MSG_MAP(CEnvDlg)
	ON_BN_CLICKED(IDC_BTN_ADDFLD, OnBtnAddfld)
	ON_BN_CLICKED(IDC_BTN_DELFLD, OnBtnDelfld)
	ON_BN_CLICKED(IDC_BTN_ADDFIL, OnBtnAddfil)
	ON_BN_CLICKED(IDC_BTN_DELFIL, OnBtnDelfil)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_FILE, OnDblclkListFile)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_FOLDER, OnDblclkListFolder)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_FOLDER, OnEndlabeleditListFolder)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_FILE, OnEndlabeleditListFile)
	ON_BN_CLICKED(IDC_CHK_FOLDER, OnChkFName)
	ON_BN_CLICKED(IDC_CHK_YYYY, OnChkFName)
	ON_BN_CLICKED(IDC_CHK_MMDD, OnChkFName)
	ON_BN_CLICKED(IDC_CHK_HHMI, OnChkFName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEnvDlg bZ[W nh

BOOL CEnvDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_NmFolder = G_ENV.m_NmFolder;
	m_YYYY = G_ENV.m_YYYY;
	m_MMDD = G_ENV.m_MMDD;
	m_HHMI = G_ENV.m_HHMI;

	m_CurFolder  = "Folder";
	m_CpyFolder  = m_NmFolder ? "Folder" : "";
	m_CpyFolder += m_YYYY ? "YYYY" : "";
	m_CpyFolder += m_MMDD ? "MMDD" : "";
	m_CpyFolder += m_HHMI ? "HHMI" : "";

	m_ListFolder.InsertColumn( 0, "tH_", LVCFMT_LEFT, 90, 1 );
	m_ListFile.InsertColumn( 0, "gq", LVCFMT_LEFT, 90, 1 );

	char	string[1024], *token;
	int		i = 1;

	ZeroMemory( string, sizeof(string) );
	strcpy( string, LPCTSTR( G_ENV.m_DelFolder ) );

	token = strtok( string, "|" );
	while( token != NULL )
	{
		m_ListFolder.InsertItem( i++, token );
		token = strtok( NULL, "|" );
	}

	ZeroMemory( string, sizeof(string) );
	strcpy( string, LPCTSTR( G_ENV.m_DelFile ) );

	token = strtok( string, "|" );
	while( token != NULL )
	{
		m_ListFile.InsertItem( i++, token );
		token = strtok( NULL, "|" );
	}

	UpdateData( FALSE );

	return TRUE;
}

void CEnvDlg::OnOK() 
{
	int		i, max;

	max = m_ListFolder.GetItemCount();
	G_ENV.m_DelFolder.Empty();
	G_ENV.m_DelFolder = "|";
	for( i = 0; i < max; i++ )
	{
		G_ENV.m_DelFolder += m_ListFolder.GetItemText( i, 0 );
		G_ENV.m_DelFolder += "|";
	}

	max = m_ListFile.GetItemCount();
	G_ENV.m_DelFile.Empty();
	G_ENV.m_DelFile = "|";
	for( i = 0; i < max; i++ )
	{
		G_ENV.m_DelFile += m_ListFile.GetItemText( i, 0 );
		G_ENV.m_DelFile += "|";
	}

	CDialog::OnOK();

	G_ENV.m_NmFolder = m_NmFolder;
	G_ENV.m_HHMI = m_HHMI;
	G_ENV.m_MMDD = m_MMDD;
	G_ENV.m_YYYY = m_YYYY;
}

BOOL CEnvDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message == WM_KEYDOWN &&
		m_ListFolder.GetEditControl() == NULL &&
		m_ListFile.GetEditControl()   == NULL &&
		(pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE) )	return TRUE;
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CEnvDlg::OnBtnAddfld() 
{
	int		max = m_ListFolder.GetItemCount();
	m_ListFolder.InsertItem( max, "tH_" );
	m_ListFolder.SetFocus();
	m_ListFolder.EditLabel( max );
}

void CEnvDlg::OnBtnAddfil() 
{
	int		max = m_ListFile.GetItemCount();
	m_ListFile.InsertItem( max, "gq" );
	m_ListFile.SetFocus();
	m_ListFile.EditLabel( max );
}

void CEnvDlg::OnBtnDelfld() 
{
	int	item;

	if( (item = m_ListFolder.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFolder.DeleteItem( item );
	}
}

void CEnvDlg::OnBtnDelfil() 
{
	int	item;

	if( (item = m_ListFile.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFile.DeleteItem( item );
	}
}

void CEnvDlg::OnDblclkListFolder(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int	item;

	if( (item = m_ListFolder.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFolder.EditLabel( item );
	}

	*pResult = 0;
}

void CEnvDlg::OnDblclkListFile(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int	item;

	if( (item = m_ListFile.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFile.EditLabel( item );
	}

	*pResult = 0;
}

void CEnvDlg::OnEndlabeleditListFolder(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString		cbuf;
	CEdit		*ce = m_ListFolder.GetEditControl();

	if( ce )
	{
		ce->GetWindowText( cbuf );
		m_ListFolder.SetItemText( pDispInfo->item.iItem, 0, cbuf );
		if( cbuf.IsEmpty() )	m_ListFolder.DeleteItem( pDispInfo->item.iItem );
	}

	*pResult = 0;
}

void CEnvDlg::OnEndlabeleditListFile(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString		cbuf;
	CEdit		*ce = m_ListFile.GetEditControl();

	if( ce )
	{
		ce->GetWindowText( cbuf );
		m_ListFile.SetItemText( pDispInfo->item.iItem, 0, cbuf );
		if( cbuf.IsEmpty() )	m_ListFile.DeleteItem( pDispInfo->item.iItem );
	}

	*pResult = 0;
}

void CEnvDlg::OnChkFName() 
{
	UpdateData( TRUE );

	m_CpyFolder  = m_NmFolder ? "Folder" : "";
	m_CpyFolder += m_YYYY ? "YYYY" : "";
	m_CpyFolder += m_MMDD ? "MMDD" : "";
	m_CpyFolder += m_HHMI ? "HHMI" : "";

	UpdateData( FALSE );
}
