// EnvDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GetStr.h"
#include "EnvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEnvDlg _CAO


CEnvDlg::CEnvDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEnvDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEnvDlg)
	m_TgtFile = _T("");
	m_StrFlg = -1;
	m_Token = _T("");
	//}}AFX_DATA_INIT
}


void CEnvDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEnvDlg)
	DDX_Control(pDX, IDC_LIST_FILE, m_ListFile);
	DDX_CBIndex(pDX, IDC_CMB_STR, m_StrFlg);
	DDX_Text(pDX, IDC_EDIT_TOKEN, m_Token);
	DDV_MaxChars(pDX, m_Token, 1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEnvDlg, CDialog)
	//{{AFX_MSG_MAP(CEnvDlg)
	ON_BN_CLICKED(IDC_BTN_ADDFIL, OnBtnAddfil)
	ON_BN_CLICKED(IDC_BTN_DELFIL, OnBtnDelfil)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_FILE, OnDblclkListFile)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_FILE, OnEndlabeleditListFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEnvDlg bZ[W nh

BOOL CEnvDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ListFile.InsertColumn( 0, "gq", LVCFMT_LEFT, 90, 1 );

	m_StrFlg = G_ENV.m_StrFlg;
	m_Token  = G_ENV.m_Token;

	char	string[1024], *token;
	int		i = 1;

	ZeroMemory( string, sizeof(string) );
	strcpy( string, LPCTSTR( G_ENV.m_TgtFile ) );

	token = strtok( string, "|" );
	while( token != NULL )
	{
		m_ListFile.InsertItem( i++, token );
		token = strtok( NULL, "|" );
	}

	UpdateData( FALSE );

	return TRUE;
}

void CEnvDlg::OnOK() 
{
	int		i, max;

	max = m_ListFile.GetItemCount();
	G_ENV.m_TgtFile.Empty();
	G_ENV.m_TgtFile = "|";
	for( i = 0; i < max; i++ )
	{
		G_ENV.m_TgtFile += m_ListFile.GetItemText( i, 0 );
		G_ENV.m_TgtFile += "|";
	}

	CDialog::OnOK();

	G_ENV.m_StrFlg = m_StrFlg;
	G_ENV.m_Token  = m_Token;
}

BOOL CEnvDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message == WM_KEYDOWN &&
		m_ListFile.GetEditControl()   == NULL &&
		(pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE) )	return TRUE;
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CEnvDlg::OnBtnAddfil() 
{
	int		max = m_ListFile.GetItemCount();
	m_ListFile.InsertItem( max, "gq" );
	m_ListFile.SetFocus();
	m_ListFile.EditLabel( max );
}

void CEnvDlg::OnBtnDelfil() 
{
	int	item;

	if( (item = m_ListFile.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFile.DeleteItem( item );
	}
}

void CEnvDlg::OnDblclkListFile(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int	item;

	if( (item = m_ListFile.GetNextItem( -1, LVNI_SELECTED )) != -1 )
	{
		m_ListFile.EditLabel( item );
	}

	*pResult = 0;
}

void CEnvDlg::OnEndlabeleditListFile(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString		cbuf;
	CEdit		*ce = m_ListFile.GetEditControl();

	if( ce )
	{
		ce->GetWindowText( cbuf );
		m_ListFile.SetItemText( pDispInfo->item.iItem, 0, cbuf );
		if( cbuf.IsEmpty() )	m_ListFile.DeleteItem( pDispInfo->item.iItem );
	}

	*pResult = 0;
}

