using System;
using System.IO;
using System.Threading;

namespace TimeStamper
{
	/// <summary>
	/// t@CXgɗ񋓂XbhǗNX
	/// </summary>
	public class FileSearch
	{
		public event System.EventHandler	AddFile = null;	// t@CǉCxg
		public event System.EventHandler	EndFile = null;	// t@CICxg

		private Thread		thread;
		private string[]	Files = null;
		private bool		ChkSubFolder = false;

		public FileSearch( String[] fs, bool bl ) 
		{
			Files  = fs;
			ChkSubFolder = bl;

			thread = new Thread( new ThreadStart( ThreadProc ) );
		}

		public void Start() 
		{
			thread.Start();
		}

		public void Abort() 
		{
			if( thread.IsAlive )	thread.Abort();
		}

		public void ThreadProc() 
		{
			AddFiles( Files );

			// t@C̃XgAbvI ʒmCxg
			if( EndFile != null )	EndFile( null, System.EventArgs.Empty );
		}

		private void AddFiles( string[] files )
		{
			FileInfo	fi;

			foreach( string fname in files ) 
			{
				//if( File.Exists( fname ) == false )	continue;
				fi = new System.IO.FileInfo( fname );

				if( (fi.Attributes & FileAttributes.Directory) != 0 )
				{	// tH_̑݃`FbN
					if( Directory.Exists( fname ) == false )	continue;
				}
				else
				{	// t@C̑݃`FbN
					if( File.Exists( fname ) == false )	continue;
				}

				// t@CPǉ ʒmCxg
				if( AddFile != null )	AddFile( fname, System.EventArgs.Empty );

				if( ChkSubFolder == true )
				{
					fi = new System.IO.FileInfo( fname );

					if( (fi.Attributes & FileAttributes.Directory) != 0 )
					{	// tH_̏ꍇAċN
						AddFiles( Directory.GetFileSystemEntries( fname ) );
					}
				}
			}
		}
	}
}
