using System;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;
using System.Reflection;
using System.Collections;

namespace TimeStamper
{
	/// <summary>
	/// MainForm ̊Tv̐łB
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private ListViewItemComparer	lvSorter = null;
		private	FileSearch				thFileSearch = null;

		private System.Windows.Forms.ListView FileLView;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.Button UpdateButton;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.CheckBox HiddenChkBox;
		private System.Windows.Forms.CheckBox ReadOnlyChkBox;
		private System.Windows.Forms.CheckBox SubFolderChkBox;
		private System.Windows.Forms.Button UpdateAllButton;
		private System.Windows.Forms.DateTimePicker CreationDatePicker;
		private System.Windows.Forms.DateTimePicker CreationTimePicker;
		private System.Windows.Forms.CheckBox CreationDateChkBox;
		private System.Windows.Forms.CheckBox CreationTimeChkBox;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.CheckBox LastWriteTimeChkBox;
		private System.Windows.Forms.DateTimePicker LastWriteTimePicker;
		private System.Windows.Forms.DateTimePicker LastWriteDatePicker;
		private System.Windows.Forms.CheckBox LastWriteDateChkBox;
		private System.Windows.Forms.Button CopyButton1;
		private System.Windows.Forms.Button CopyButton2;
		private System.Windows.Forms.StatusBar MainStatusBar;
		private System.Windows.Forms.CheckBox AttributeChkBox;
		private System.Windows.Forms.ImageList LViewImageList;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ContextMenu LViewMenu;
		private System.Windows.Forms.MenuItem menuItemDel;
		private System.Windows.Forms.MenuItem menuItemAddFile;
		private System.Windows.Forms.MenuItem menuItemAddFolder;
		private System.Windows.Forms.MenuItem menuItemDelAll;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.Panel WaitPanel;
		private System.Windows.Forms.Label WaitLabel;
		private System.Windows.Forms.Button StopButton;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.IContainer components;

		public MainForm()
		{
			InitializeComponent();
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.FileLView = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.LViewMenu = new System.Windows.Forms.ContextMenu();
			this.menuItemDel = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItemAddFile = new System.Windows.Forms.MenuItem();
			this.menuItemAddFolder = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItemDelAll = new System.Windows.Forms.MenuItem();
			this.LViewImageList = new System.Windows.Forms.ImageList(this.components);
			this.CreationDatePicker = new System.Windows.Forms.DateTimePicker();
			this.CreationTimePicker = new System.Windows.Forms.DateTimePicker();
			this.CreationDateChkBox = new System.Windows.Forms.CheckBox();
			this.HiddenChkBox = new System.Windows.Forms.CheckBox();
			this.CreationTimeChkBox = new System.Windows.Forms.CheckBox();
			this.ReadOnlyChkBox = new System.Windows.Forms.CheckBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.CloseButton = new System.Windows.Forms.Button();
			this.UpdateButton = new System.Windows.Forms.Button();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.AttributeChkBox = new System.Windows.Forms.CheckBox();
			this.SubFolderChkBox = new System.Windows.Forms.CheckBox();
			this.UpdateAllButton = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.LastWriteTimeChkBox = new System.Windows.Forms.CheckBox();
			this.LastWriteTimePicker = new System.Windows.Forms.DateTimePicker();
			this.LastWriteDatePicker = new System.Windows.Forms.DateTimePicker();
			this.LastWriteDateChkBox = new System.Windows.Forms.CheckBox();
			this.CopyButton1 = new System.Windows.Forms.Button();
			this.CopyButton2 = new System.Windows.Forms.Button();
			this.MainStatusBar = new System.Windows.Forms.StatusBar();
			this.WaitPanel = new System.Windows.Forms.Panel();
			this.label1 = new System.Windows.Forms.Label();
			this.StopButton = new System.Windows.Forms.Button();
			this.WaitLabel = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.WaitPanel.SuspendLayout();
			this.SuspendLayout();
			// 
			// FileLView
			// 
			this.FileLView.AllowDrop = true;
			this.FileLView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this.columnHeader1,
																						this.columnHeader2,
																						this.columnHeader3,
																						this.columnHeader4,
																						this.columnHeader5});
			this.FileLView.ContextMenu = this.LViewMenu;
			this.FileLView.Font = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.FileLView.FullRowSelect = true;
			this.FileLView.HideSelection = false;
			this.FileLView.LargeImageList = this.LViewImageList;
			this.FileLView.Location = new System.Drawing.Point(8, 8);
			this.FileLView.Name = "FileLView";
			this.FileLView.Size = new System.Drawing.Size(616, 364);
			this.FileLView.SmallImageList = this.LViewImageList;
			this.FileLView.TabIndex = 0;
			this.FileLView.View = System.Windows.Forms.View.Details;
			this.FileLView.DoubleClick += new System.EventHandler(this.FileLView_DoubleClick);
			this.FileLView.DragDrop += new System.Windows.Forms.DragEventHandler(this.FileLView_DragDrop);
			this.FileLView.DragEnter += new System.Windows.Forms.DragEventHandler(this.FileLView_DragEnter);
			this.FileLView.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.FileLView_ColumnClick);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "t@C";
			this.columnHeader1.Width = 120;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "쐬";
			this.columnHeader2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.columnHeader2.Width = 90;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "XV";
			this.columnHeader3.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.columnHeader3.Width = 90;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "tpX";
			this.columnHeader4.Width = 260;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "";
			this.columnHeader5.Width = 160;
			// 
			// LViewMenu
			// 
			this.LViewMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemDel,
																					  this.menuItem2,
																					  this.menuItemAddFile,
																					  this.menuItemAddFolder,
																					  this.menuItem3,
																					  this.menuItemDelAll});
			this.LViewMenu.Popup += new System.EventHandler(this.LViewMenu_Popup);
			// 
			// menuItemDel
			// 
			this.menuItemDel.Index = 0;
			this.menuItemDel.Text = "Xg폜";
			this.menuItemDel.Click += new System.EventHandler(this.menuItemDel_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "-";
			// 
			// menuItemAddFile
			// 
			this.menuItemAddFile.Index = 2;
			this.menuItemAddFile.Text = "t@Cǉ";
			this.menuItemAddFile.Click += new System.EventHandler(this.menuItemAddFile_Click);
			// 
			// menuItemAddFolder
			// 
			this.menuItemAddFolder.Index = 3;
			this.menuItemAddFolder.Text = "tH_ǉ";
			this.menuItemAddFolder.Click += new System.EventHandler(this.menuItemAddFolder_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 4;
			this.menuItem3.Text = "-";
			// 
			// menuItemDelAll
			// 
			this.menuItemDelAll.Index = 5;
			this.menuItemDelAll.Text = "XgS폜";
			this.menuItemDelAll.Click += new System.EventHandler(this.menuItemDelAll_Click);
			// 
			// LViewImageList
			// 
			this.LViewImageList.ImageSize = new System.Drawing.Size(16, 16);
			this.LViewImageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// CreationDatePicker
			// 
			this.CreationDatePicker.Location = new System.Drawing.Point(72, 32);
			this.CreationDatePicker.Name = "CreationDatePicker";
			this.CreationDatePicker.Size = new System.Drawing.Size(112, 19);
			this.CreationDatePicker.TabIndex = 1;
			// 
			// CreationTimePicker
			// 
			this.CreationTimePicker.Format = System.Windows.Forms.DateTimePickerFormat.Time;
			this.CreationTimePicker.Location = new System.Drawing.Point(72, 56);
			this.CreationTimePicker.Name = "CreationTimePicker";
			this.CreationTimePicker.Size = new System.Drawing.Size(72, 19);
			this.CreationTimePicker.TabIndex = 2;
			// 
			// CreationDateChkBox
			// 
			this.CreationDateChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.CreationDateChkBox.Location = new System.Drawing.Point(16, 32);
			this.CreationDateChkBox.Name = "CreationDateChkBox";
			this.CreationDateChkBox.Size = new System.Drawing.Size(56, 16);
			this.CreationDateChkBox.TabIndex = 3;
			this.CreationDateChkBox.Text = "t";
			this.CreationDateChkBox.CheckedChanged += new System.EventHandler(this.ChkBox_CheckedChanged);
			// 
			// HiddenChkBox
			// 
			this.HiddenChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.HiddenChkBox.Location = new System.Drawing.Point(40, 64);
			this.HiddenChkBox.Name = "HiddenChkBox";
			this.HiddenChkBox.Size = new System.Drawing.Size(104, 16);
			this.HiddenChkBox.TabIndex = 4;
			this.HiddenChkBox.Text = "Bt@C";
			// 
			// CreationTimeChkBox
			// 
			this.CreationTimeChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.CreationTimeChkBox.Location = new System.Drawing.Point(16, 56);
			this.CreationTimeChkBox.Name = "CreationTimeChkBox";
			this.CreationTimeChkBox.Size = new System.Drawing.Size(48, 16);
			this.CreationTimeChkBox.TabIndex = 5;
			this.CreationTimeChkBox.Text = "";
			this.CreationTimeChkBox.CheckedChanged += new System.EventHandler(this.ChkBox_CheckedChanged);
			// 
			// ReadOnlyChkBox
			// 
			this.ReadOnlyChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.ReadOnlyChkBox.Location = new System.Drawing.Point(40, 44);
			this.ReadOnlyChkBox.Name = "ReadOnlyChkBox";
			this.ReadOnlyChkBox.Size = new System.Drawing.Size(104, 16);
			this.ReadOnlyChkBox.TabIndex = 6;
			this.ReadOnlyChkBox.Text = "ǂݎp";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.CreationTimeChkBox);
			this.groupBox1.Controls.Add(this.CreationTimePicker);
			this.groupBox1.Controls.Add(this.CreationDatePicker);
			this.groupBox1.Controls.Add(this.CreationDateChkBox);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(8, 404);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(200, 96);
			this.groupBox1.TabIndex = 8;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "t@C쐬ύXIvV";
			// 
			// CloseButton
			// 
			this.CloseButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.CloseButton.Location = new System.Drawing.Point(476, 508);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.Size = new System.Drawing.Size(148, 32);
			this.CloseButton.TabIndex = 10;
			this.CloseButton.Text = "";
			this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);
			// 
			// UpdateButton
			// 
			this.UpdateButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.UpdateButton.ForeColor = System.Drawing.Color.Blue;
			this.UpdateButton.Location = new System.Drawing.Point(160, 508);
			this.UpdateButton.Name = "UpdateButton";
			this.UpdateButton.Size = new System.Drawing.Size(148, 32);
			this.UpdateButton.TabIndex = 11;
			this.UpdateButton.Text = "I𒆂̃t@CXV";
			this.UpdateButton.Click += new System.EventHandler(this.UpdateButton_Click);
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.AttributeChkBox);
			this.groupBox3.Controls.Add(this.HiddenChkBox);
			this.groupBox3.Controls.Add(this.ReadOnlyChkBox);
			this.groupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox3.Location = new System.Drawing.Point(456, 404);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(168, 96);
			this.groupBox3.TabIndex = 13;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "t@CύXIvV";
			// 
			// AttributeChkBox
			// 
			this.AttributeChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.AttributeChkBox.Location = new System.Drawing.Point(16, 20);
			this.AttributeChkBox.Name = "AttributeChkBox";
			this.AttributeChkBox.Size = new System.Drawing.Size(88, 16);
			this.AttributeChkBox.TabIndex = 7;
			this.AttributeChkBox.Text = "ύX";
			this.AttributeChkBox.CheckedChanged += new System.EventHandler(this.ChkBox_CheckedChanged);
			// 
			// SubFolderChkBox
			// 
			this.SubFolderChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.SubFolderChkBox.Location = new System.Drawing.Point(24, 376);
			this.SubFolderChkBox.Name = "SubFolderChkBox";
			this.SubFolderChkBox.Size = new System.Drawing.Size(340, 16);
			this.SubFolderChkBox.TabIndex = 16;
			this.SubFolderChkBox.Text = "tH_̏ꍇ z̃t@CΏۂƂ";
			// 
			// UpdateAllButton
			// 
			this.UpdateAllButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.UpdateAllButton.ForeColor = System.Drawing.Color.Red;
			this.UpdateAllButton.Location = new System.Drawing.Point(316, 508);
			this.UpdateAllButton.Name = "UpdateAllButton";
			this.UpdateAllButton.Size = new System.Drawing.Size(148, 32);
			this.UpdateAllButton.TabIndex = 19;
			this.UpdateAllButton.Text = "SẴt@CXV";
			this.UpdateAllButton.Click += new System.EventHandler(this.UpdateAllButton_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.LastWriteTimeChkBox);
			this.groupBox2.Controls.Add(this.LastWriteTimePicker);
			this.groupBox2.Controls.Add(this.LastWriteDatePicker);
			this.groupBox2.Controls.Add(this.LastWriteDateChkBox);
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox2.Location = new System.Drawing.Point(248, 404);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(200, 96);
			this.groupBox2.TabIndex = 20;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "t@CXVύXIvV";
			// 
			// LastWriteTimeChkBox
			// 
			this.LastWriteTimeChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.LastWriteTimeChkBox.Location = new System.Drawing.Point(16, 56);
			this.LastWriteTimeChkBox.Name = "LastWriteTimeChkBox";
			this.LastWriteTimeChkBox.Size = new System.Drawing.Size(48, 16);
			this.LastWriteTimeChkBox.TabIndex = 5;
			this.LastWriteTimeChkBox.Text = "";
			this.LastWriteTimeChkBox.CheckedChanged += new System.EventHandler(this.ChkBox_CheckedChanged);
			// 
			// LastWriteTimePicker
			// 
			this.LastWriteTimePicker.Format = System.Windows.Forms.DateTimePickerFormat.Time;
			this.LastWriteTimePicker.Location = new System.Drawing.Point(72, 56);
			this.LastWriteTimePicker.Name = "LastWriteTimePicker";
			this.LastWriteTimePicker.Size = new System.Drawing.Size(72, 19);
			this.LastWriteTimePicker.TabIndex = 2;
			// 
			// LastWriteDatePicker
			// 
			this.LastWriteDatePicker.Location = new System.Drawing.Point(72, 32);
			this.LastWriteDatePicker.Name = "LastWriteDatePicker";
			this.LastWriteDatePicker.Size = new System.Drawing.Size(112, 19);
			this.LastWriteDatePicker.TabIndex = 1;
			// 
			// LastWriteDateChkBox
			// 
			this.LastWriteDateChkBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.LastWriteDateChkBox.Location = new System.Drawing.Point(16, 32);
			this.LastWriteDateChkBox.Name = "LastWriteDateChkBox";
			this.LastWriteDateChkBox.Size = new System.Drawing.Size(56, 16);
			this.LastWriteDateChkBox.TabIndex = 3;
			this.LastWriteDateChkBox.Text = "t";
			this.LastWriteDateChkBox.CheckedChanged += new System.EventHandler(this.ChkBox_CheckedChanged);
			// 
			// CopyButton1
			// 
			this.CopyButton1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.CopyButton1.Location = new System.Drawing.Point(216, 420);
			this.CopyButton1.Name = "CopyButton1";
			this.CopyButton1.Size = new System.Drawing.Size(24, 32);
			this.CopyButton1.TabIndex = 21;
			this.CopyButton1.Text = ">";
			this.CopyButton1.Click += new System.EventHandler(this.CopyButton1_Click);
			// 
			// CopyButton2
			// 
			this.CopyButton2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.CopyButton2.Location = new System.Drawing.Point(216, 460);
			this.CopyButton2.Name = "CopyButton2";
			this.CopyButton2.Size = new System.Drawing.Size(24, 32);
			this.CopyButton2.TabIndex = 22;
			this.CopyButton2.Text = "<";
			this.CopyButton2.Click += new System.EventHandler(this.CopyButton2_Click);
			// 
			// MainStatusBar
			// 
			this.MainStatusBar.Location = new System.Drawing.Point(0, 546);
			this.MainStatusBar.Name = "MainStatusBar";
			this.MainStatusBar.Size = new System.Drawing.Size(634, 22);
			this.MainStatusBar.SizingGrip = false;
			this.MainStatusBar.TabIndex = 24;
			// 
			// WaitPanel
			// 
			this.WaitPanel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.WaitPanel.Controls.Add(this.label1);
			this.WaitPanel.Controls.Add(this.StopButton);
			this.WaitPanel.Controls.Add(this.WaitLabel);
			this.WaitPanel.Location = new System.Drawing.Point(104, 148);
			this.WaitPanel.Name = "WaitPanel";
			this.WaitPanel.Size = new System.Drawing.Size(424, 108);
			this.WaitPanel.TabIndex = 25;
			this.WaitPanel.Visible = false;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 12);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(392, 16);
			this.label1.TabIndex = 3;
			this.label1.Text = "t@Co^c";
			// 
			// StopButton
			// 
			this.StopButton.Location = new System.Drawing.Point(172, 76);
			this.StopButton.Name = "StopButton";
			this.StopButton.Size = new System.Drawing.Size(80, 23);
			this.StopButton.TabIndex = 2;
			this.StopButton.Text = "f";
			this.StopButton.Click += new System.EventHandler(this.StopButton_Click);
			// 
			// WaitLabel
			// 
			this.WaitLabel.Location = new System.Drawing.Point(16, 36);
			this.WaitLabel.Name = "WaitLabel";
			this.WaitLabel.Size = new System.Drawing.Size(392, 32);
			this.WaitLabel.TabIndex = 1;
			this.WaitLabel.Text = "label1";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(634, 568);
			this.Controls.Add(this.WaitPanel);
			this.Controls.Add(this.MainStatusBar);
			this.Controls.Add(this.CopyButton2);
			this.Controls.Add(this.CopyButton1);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.UpdateAllButton);
			this.Controls.Add(this.SubFolderChkBox);
			this.Controls.Add(this.UpdateButton);
			this.Controls.Add(this.CloseButton);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.FileLView);
			this.Controls.Add(this.groupBox3);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "TimeStamper Ver 1.00";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.MainForm_Closing);
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.WaitPanel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			ControlEnabled();

			CreationTimePicker.Value  = DateTime.Parse( CreationTimePicker.Value.ToString( "yyyy/MM/dd" ) + " 00:00:00" );
			LastWriteTimePicker.Value = DateTime.Parse( LastWriteTimePicker.Value.ToString( "yyyy/MM/dd" ) + " 00:00:00" );

			/***
			// ԕ
			Cursor.Current = Cursors.WaitCursor;

			ResumeClass		rc = new ResumeClass();

			if( rc.ReadXml( Path.Combine( Application.StartupPath, "resume.xml" ) ) )
			{
				SubFolderChkBox.Checked = rc.chksub;
				if( rc.files != null &&
					rc.files.Length > 0 )	FileListUp( rc.files, false );
			}

			Cursor.Current = Cursors.Default;
			***/
		}

		private void MainForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if( thFileSearch != null )	thFileSearch.Abort();

			/***
			// ԕۑ
			Cursor.Current = Cursors.WaitCursor;

			ResumeClass		rc = new ResumeClass();

			rc.chksub = SubFolderChkBox.Checked;

			if( FileLView.Items.Count > 0 )
			{
				rc.files = new string[ FileLView.Items.Count ];

				for( int i = 0; i < FileLView.Items.Count; i++ )
				{
					rc.files[i] = FileLView.Items[i].SubItems[3].Text;
				}
			}
			rc.SaveXml( Path.Combine( Application.StartupPath, "resume.xml" ) );

			Cursor.Current = Cursors.Default;
			***/
		}

		private void FileLView_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
		{
			if( e.Data.GetDataPresent( DataFormats.FileDrop ) )
			{
				e.Effect = DragDropEffects.Copy;
			}
			else
			{
				e.Effect = DragDropEffects.None;
			}
		}

		private void FileLView_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{
			FileListUp( (string[])e.Data.GetData( DataFormats.FileDrop ), SubFolderChkBox.Checked );
		}

		private void FileLView_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if( lvSorter == null )	lvSorter = new ListViewItemComparer();

			lvSorter.SortCol = e.Column;

			FileLView.ListViewItemSorter = lvSorter;

			FileLView.Sort();

			FileLView.ListViewItemSorter = null;	// ςȂƃXgɃACe邽тɃ\[gĂ܂HHH
		}

		private void FileLView_DoubleClick(object sender, System.EventArgs e)
		{
			if( FileLView.SelectedItems.Count > 0 )
			{
				System.Diagnostics.Process.Start( FileLView.SelectedItems[0].SubItems[3].Text );
			}
		}

		private void StopButton_Click(object sender, System.EventArgs e)
		{
			if( thFileSearch != null )	thFileSearch.Abort();

			EndFile( null, System.EventArgs.Empty );
		}

		private void menuItemDel_Click(object sender, System.EventArgs e)
		{
			Cursor.Current = Cursors.WaitCursor;

			for( int i = FileLView.SelectedItems.Count - 1; i >= 0; i-- )
			{
				FileLView.SelectedItems[i].Remove();
			}

			Cursor.Current = Cursors.Default;

			MainStatusBar.Text = FileLView.Items.Count + " ̃IuWFNg";
		}

		private void menuItemAddFile_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog	dlg = new OpenFileDialog();
			dlg.Filter = "ׂẴt@C (*.*)|*.*";

			if( dlg.ShowDialog() == DialogResult.OK )
			{
				FileListUp( dlg.FileNames, SubFolderChkBox.Checked );
			}
		}

		private void menuItemAddFolder_Click(object sender, System.EventArgs e)
		{
			FolderBrowserDialog	dlg = new FolderBrowserDialog();
			dlg.ShowNewFolderButton = false;

			if( dlg.ShowDialog() == DialogResult.OK )
			{
				FileListUp( new string[] { dlg.SelectedPath }, SubFolderChkBox.Checked );
			}
		}

		private void menuItemDelAll_Click(object sender, System.EventArgs e)
		{
			MainStatusBar.Text = "";
			FileLView.Items.Clear();
			LViewImageList.Images.Clear();
		}

		private void LViewMenu_Popup(object sender, System.EventArgs e)
		{
			for( int i = 0; i < LViewMenu.MenuItems.Count; i++ )
			{
				LViewMenu.MenuItems[i].Enabled = (thFileSearch == null ? true : false);
			}
			
			if( FileLView.SelectedItems.Count == 0 )
			{
				menuItemDel.Enabled = false;
			}
		}

		private void CloseButton_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void CopyButton1_Click(object sender, System.EventArgs e)
		{
			LastWriteDateChkBox.Checked = CreationDateChkBox.Checked;
			LastWriteTimeChkBox.Checked = CreationTimeChkBox.Checked;
			LastWriteDatePicker.Value = CreationDatePicker.Value;
			LastWriteTimePicker.Value = CreationTimePicker.Value;
		}

		private void CopyButton2_Click(object sender, System.EventArgs e)
		{
			CreationDateChkBox.Checked = LastWriteDateChkBox.Checked;
			CreationTimeChkBox.Checked = LastWriteTimeChkBox.Checked;
			CreationDatePicker.Value = LastWriteDatePicker.Value;
			CreationTimePicker.Value = LastWriteTimePicker.Value;
		}

		private void UpdateButton_Click(object sender, System.EventArgs e)
		{
			UpdateFiles( FileLView.SelectedItems );
		}

		private void UpdateAllButton_Click(object sender, System.EventArgs e)
		{
			UpdateFiles( FileLView.Items );
		}

		private void ChkBox_CheckedChanged(object sender, System.EventArgs e)
		{
			ControlEnabled();
		}

		/// <summary>
		/// Rg[̏ԂύX
		/// </summary>
		private void ControlEnabled()
		{
			ReadOnlyChkBox.Enabled = AttributeChkBox.Checked;
			HiddenChkBox.Enabled = AttributeChkBox.Checked;

			CreationDatePicker.Enabled = CreationDateChkBox.Checked;
			CreationTimePicker.Enabled = CreationTimeChkBox.Checked;

			LastWriteDatePicker.Enabled = LastWriteDateChkBox.Checked;
			LastWriteTimePicker.Enabled = LastWriteTimeChkBox.Checked;
		}

		/// <summary>
		/// t@CXgAbvXbhJn
		/// </summary>
		private void FileListUp( string[] files, bool subchk )
		{
			if( thFileSearch != null )	return;

			// XbhNX쐬
			thFileSearch = new FileSearch( files, subchk );

			thFileSearch.AddFile += new System.EventHandler( this.AddFile );
			thFileSearch.EndFile += new System.EventHandler( this.EndFile );

			WaitPanel.Visible = true;

			thFileSearch.Start();
		}

		/// <summary>
		/// t@CXgAbvI
		/// </summary>
		private void EndFile(object sender, System.EventArgs evt)
		{
			MainStatusBar.Text = FileLView.Items.Count + " ̃IuWFNg";
			WaitPanel.Visible = false;

			thFileSearch = null;
		}

		/// <summary>
		/// t@CXgɒǉ
		/// </summary>
		private void AddFile(object sender, System.EventArgs evt)
		{
			string			fname = (string)sender;

			WaitLabel.Text = fname;

			FileInfo		fi = new System.IO.FileInfo( fname );
			ListViewItem	lvi = new ListViewItem( fi.Name );

			lvi.Checked = true;
			lvi.SubItems.Add( fi.CreationTime.ToString( "yy/MM/dd HH:mm" ) );
			lvi.SubItems.Add( fi.LastWriteTime.ToString( "yy/MM/dd HH:mm" ) );
			lvi.SubItems.Add( fi.FullName );
			lvi.SubItems.Add( fi.Attributes.ToString() );

			try
			{
				Icon	ico = SHIcon.Get( fi.FullName );

				if( ico != null )
				{
					int	idx = LViewImageList.Images.Add( ico.ToBitmap(), Color.Transparent );
					lvi.ImageIndex = idx;
				}
			}
			catch( Exception exc )
			{
				MessageBox.Show( exc.Message );
			}

			FileLView.Items.Add( lvi );
		}

		/// <summary>
		/// t@C̃^CX^vEύX
		/// </summary>
		private bool FileChgAttributes( ListViewItem lvi )
		{
			FileSystemInfo	fi = new System.IO.FileInfo( lvi.SubItems[3].Text );

			if( (fi.Attributes & FileAttributes.Directory) != 0 )
			{	// tH_ꍇ
				//return ChgDirectoryAttribute( lvi );
				fi = new System.IO.DirectoryInfo( lvi.SubItems[3].Text );
			}

			if( fi.Exists == false )	return false;

			DateTime	tm;
			string		ymd, hm;
			bool		readonly_flag = false;


			if( (fi.Attributes & FileAttributes.ReadOnly) != 0 )
			{	// ǂݎp̏ꍇAύXł悤ꎞ
				fi.Attributes &= ~FileAttributes.ReadOnly;
				readonly_flag = true;
			}
	
			// t@C쐬ύX
			if( CreationDateChkBox.Checked || CreationTimeChkBox.Checked )
			{
				ymd = fi.CreationTime.ToString( "yyyy/MM/dd" );
				hm  = fi.CreationTime.ToString( "HH:mm:ss" );

				if( CreationDateChkBox.Checked )
				{
					ymd = CreationDatePicker.Value.ToString( "yyyy/MM/dd" );
				}

				if( CreationTimeChkBox.Checked )
				{
					hm = CreationTimePicker.Value.ToString( "HH:mm:ss" );
				}
				tm = DateTime.Parse( ymd + " " + hm );
				fi.CreationTime = tm;
			}

			// t@CXVύX
			if( LastWriteDateChkBox.Checked || LastWriteTimeChkBox.Checked )
			{
				ymd = fi.LastWriteTime.ToString( "yyyy/MM/dd" );
				hm  = fi.LastWriteTime.ToString( "HH:mm:ss" );

				if( LastWriteDateChkBox.Checked )
				{
					ymd = LastWriteDatePicker.Value.ToString( "yyyy/MM/dd" );
				}

				if( LastWriteTimeChkBox.Checked )
				{
					hm = LastWriteTimePicker.Value.ToString( "HH:mm:ss" );
				}
				tm = DateTime.Parse( ymd + " " + hm );
				fi.LastWriteTime = tm;
			}

			// ύX
			if( AttributeChkBox.Checked )
			{
				if( HiddenChkBox.Checked )
				{
					fi.Attributes |= FileAttributes.Hidden;
				}
				else
				{
					fi.Attributes &= ~FileAttributes.Hidden;
				}

				if( ReadOnlyChkBox.Checked )
				{
					fi.Attributes |= FileAttributes.ReadOnly;
				}
				else
				{
					fi.Attributes &= ~FileAttributes.ReadOnly;
				}
			}
			else if( readonly_flag )
			{	// ǂݎpɖ߂
				fi.Attributes |= FileAttributes.ReadOnly;
			}

			// Xgɔf
			lvi.SubItems[1].Text = fi.CreationTime.ToString( "yy/MM/dd HH:mm" );
			lvi.SubItems[2].Text = fi.LastWriteTime.ToString( "yy/MM/dd HH:mm" );
			lvi.SubItems[4].Text = fi.Attributes.ToString();

			return true;
		}

		/// <summary>
		/// t@C̃^CX^vEύX
		/// </summary>
		private void UpdateFiles( System.Collections.IList lvic )
		{
			if( lvic.Count == 0 )
			{
				MainStatusBar.Text = "XVΏۂ̃t@Cw肳Ă܂";
				return;
			}

			if( CreationDateChkBox.Checked  == false &&
				CreationTimeChkBox.Checked  == false &&
				LastWriteDateChkBox.Checked == false &&
				LastWriteTimeChkBox.Checked == false &&
				AttributeChkBox.Checked     == false )
			{
				MainStatusBar.Text = "XVew肳Ă܂";
				return;
			}

			if( DialogResult.OK != MessageBox.Show( this, lvic.Count + " ̃t@CXV܂", "mF", MessageBoxButtons.OKCancel ) )	return;

			Cursor.Current = Cursors.WaitCursor;

			int	cnt = 0, err = 0;

			for( int i = 0; i < lvic.Count; i++ )
			{
				try
				{
					if( FileChgAttributes( (ListViewItem)lvic[i] ) )
					{
						((ListViewItem)lvic[i]).ForeColor = Color.Blue;
						cnt++;
					}
					else
					{
						((ListViewItem)lvic[i]).ForeColor = Color.Red;
						err++;
					}
				}
				catch( Exception e )
				{
					MainStatusBar.Text = e.Message;
					((ListViewItem)lvic[i]).ForeColor = Color.Red;
					err++;
				}
			}

			Cursor.Current = Cursors.Default;

			MainStatusBar.Text = "I: " + cnt + ",@" + "G[: " + err;
		}
	}

	/// <summary>
	/// Ȉԕۑp̃NX
	/// </summary>
	public class ResumeClass
	{
		public bool		chksub = false;
		public string[]	files  = null;

		// ۑ
		public bool SaveXml( string fname )
		{
			try
			{
				XmlSerializer	serializer = new XmlSerializer( typeof( ResumeClass ) );
				TextWriter		writer = new StreamWriter( fname );

				serializer.Serialize( writer, this );
				writer.Close();
			}
			catch
			{
				return false;
			}
			return true;
		}

		// Ǎ
		public bool ReadXml( string fname )
		{
			try
			{
				XmlSerializer	serializer = new XmlSerializer( typeof( ResumeClass ) );
				TextReader		reader = new StreamReader( fname );
				ResumeClass		rc = (ResumeClass)serializer.Deserialize( reader );

				this.chksub = rc.chksub;
				this.files  = rc.files;

				reader.Close();
			}
			catch
			{
				// WEt@C
				return false;
			}
			return true;
		}
	}

	/// <summary>
	/// Xgr[\[gp
	/// </summary>
	class ListViewItemComparer : IComparer 
	{
		private int		_SortCol = 0;
		private bool	Order = true;

		public int SortCol
		{
			set
			{
				if( _SortCol == value )
				{
					Order = (Order ? false : true);
				}
				else
				{
					Order = true;
					_SortCol = value;
				}			
			}
			get { return _SortCol; }
		}

		public int Compare(object x, object y) 
		{
			// ~
			if( Order == false )	return String.Compare(((ListViewItem)y).SubItems[SortCol].Text, ((ListViewItem)x).SubItems[SortCol].Text);

			// 
			return String.Compare(((ListViewItem)x).SubItems[SortCol].Text, ((ListViewItem)y).SubItems[SortCol].Text);
		}
	}
}
