using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace TimeStamper
{
	/// <summary>
	/// t@CɊ֘AtACR擾
	/// </summary>
	public class SHIcon
	{
		[StructLayout(LayoutKind.Sequential)]
		private struct SHFILEINFO
		{
			const int		MAX_PATH = 260;
			internal		IntPtr hIcon;
			internal int	iIcon;
			internal uint	dwAttributes;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
			internal string	szDisplayName;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
			internal string	szTypeName;
		}

		[DllImport("shell32.dll")]
		private static extern IntPtr SHGetFileInfo(
			string pszPath,
			uint dwFileAttributes,
			ref SHFILEINFO psfi,
			uint cbFileInfo,
			uint uFlags );

		public static Icon Get( string fname )
		{
			const uint	SHGFI_ICON      = 0x000000100;
			//const uint	SHGFI_LARGEICON = 0x000000000;
			const uint	SHGFI_SMALLICON = 0x000000001;
			
			SHFILEINFO	shfi = new SHFILEINFO();
			SHGetFileInfo( fname, 0, ref shfi, (uint)Marshal.SizeOf( shfi ), SHGFI_ICON | SHGFI_SMALLICON );

			return Icon.FromHandle( shfi.hIcon );
		}
	}
}
